/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.tartarus.snowball.SnowballProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSStemmingFilter
extends TokenFilter {
    private static final Logger LOGGER = Logger.getLogger(FTSStemmingFilter.class);
    private SnowballProgram stemmer;
    private Hashtable<String, String> rootTable;
    private boolean addStemmedTerm = false;
    private Token stemmedTerm = new Token();

    public FTSStemmingFilter(TokenStream input, SnowballProgram stemmer, Hashtable<String, String> rootTable) {
        super(input);
        this.stemmer = stemmer;
        this.rootTable = rootTable;
    }

    public FTSStemmingFilter(TokenStream in, String name) {
        super(in);
        try {
            Class<?> stemClass = Class.forName("org.tartarus.snowball.ext." + name + "Stemmer");
            this.stemmer = (SnowballProgram)stemClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " rewrite: Failed to get the " + name + " stemmer"), (Throwable)e);
        }
    }

    public final Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        try {
            if (this.addStemmedTerm) {
                this.addStemmedTerm = false;
                return this.stemmedTerm;
            }
            Token nextToken = this.input.next(reusableToken);
            if (nextToken == null) {
                return null;
            }
            String originalTerm = nextToken.term();
            String finalTerm = null;
            if (this.rootTable.containsKey(originalTerm)) {
                finalTerm = this.rootTable.get(originalTerm);
            } else {
                this.stemmer.setCurrent(originalTerm);
                this.stemmer.stem();
                finalTerm = this.stemmer.getCurrent();
            }
            if (!originalTerm.equals(finalTerm)) {
                nextToken.setTermBuffer(finalTerm);
                Object object = nextToken.clone();
                this.stemmedTerm = (Token)object;
                this.stemmedTerm.setTermBuffer(originalTerm);
                this.stemmedTerm.setPositionIncrement(0);
                this.addStemmedTerm = true;
            }
            return nextToken;
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSStemmingFilter: failed to get next term "), (Throwable)e);
            }
            return null;
        }
    }
}

