/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FTSRootCharacterFilter
extends TokenFilter {
    private Hashtable<String, String> rootCharTable;
    private char[] output = new char[512];
    private int outputPos;
    private TermAttribute termAtt;

    public FTSRootCharacterFilter(TokenStream input, Hashtable<String, String> rootCharTable) {
        super(input);
        this.rootCharTable = rootCharTable;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.termBuffer();
            int length = this.termAtt.termLength();
            for (int i = 0; i < length; ++i) {
                char c = buffer[i];
                if (c < '\u0080') continue;
                this.foldToASCII(buffer, length);
                this.termAtt.setTermBuffer(this.output, 0, this.outputPos);
                break;
            }
            return true;
        }
        return false;
    }

    public void foldToASCII(char[] input, int length) {
        int maxSizeNeeded = 4 * length;
        if (this.output.length < maxSizeNeeded) {
            this.output = new char[ArrayUtil.getNextSize((int)maxSizeNeeded)];
        }
        this.outputPos = 0;
        for (int pos = 0; pos < length; ++pos) {
            char c = input[pos];
            if (c < '\u0080') {
                this.output[this.outputPos++] = c;
                continue;
            }
            String strCharString = Character.toString(c);
            if (this.rootCharTable.containsKey(strCharString)) {
                char[] tempCharArray = this.rootCharTable.get(strCharString).toCharArray();
                for (int x = 0; x < tempCharArray.length; ++x) {
                    this.output[this.outputPos++] = tempCharArray[x];
                }
                continue;
            }
            this.output[this.outputPos++] = c;
        }
    }
}

