/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.support;

import com.bmc.thirdparty.org.springframework.aop.MethodMatcher;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Method;

public abstract class MethodMatchers {
    public static MethodMatcher union(MethodMatcher a2, MethodMatcher b2) {
        return new UnionMethodMatcher(a2, b2);
    }

    public static MethodMatcher intersection(MethodMatcher a2, MethodMatcher b2) {
        return new IntersectionMethodMatcher(a2, b2);
    }

    private static class IntersectionMethodMatcher
    implements MethodMatcher,
    Serializable {
        private MethodMatcher a;
        private MethodMatcher b;

        private IntersectionMethodMatcher(MethodMatcher a2, MethodMatcher b2) {
            Assert.notNull(a2, "First MethodMatcher must not be null");
            Assert.notNull(b2, "Second MethodMatcher must not be null");
            this.a = a2;
            this.b = b2;
        }

        public boolean matches(Method method, Class targetClass) {
            return this.a.matches(method, targetClass) && this.b.matches(method, targetClass);
        }

        public boolean isRuntime() {
            return this.a.isRuntime() || this.b.isRuntime();
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            boolean aMatches = this.a.isRuntime() ? this.a.matches(method, targetClass, args) : this.a.matches(method, targetClass);
            boolean bMatches = this.b.isRuntime() ? this.b.matches(method, targetClass, args) : this.b.matches(method, targetClass);
            return aMatches && bMatches;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntersectionMethodMatcher)) {
                return false;
            }
            IntersectionMethodMatcher that = (IntersectionMethodMatcher)other;
            return this.a.equals(that.a) && this.b.equals(that.b);
        }

        public int hashCode() {
            int code = 17;
            code = 37 * code + this.a.hashCode();
            code = 37 * code + this.b.hashCode();
            return code;
        }
    }

    private static class UnionMethodMatcher
    implements MethodMatcher,
    Serializable {
        private MethodMatcher a;
        private MethodMatcher b;

        private UnionMethodMatcher(MethodMatcher a2, MethodMatcher b2) {
            Assert.notNull(a2, "First MethodMatcher must not be null");
            Assert.notNull(b2, "Second MethodMatcher must not be null");
            this.a = a2;
            this.b = b2;
        }

        public boolean matches(Method method, Class targetClass) {
            return this.a.matches(method, targetClass) || this.b.matches(method, targetClass);
        }

        public boolean isRuntime() {
            return this.a.isRuntime() || this.b.isRuntime();
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            return this.a.matches(method, targetClass, args) || this.b.matches(method, targetClass, args);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UnionMethodMatcher)) {
                return false;
            }
            UnionMethodMatcher that = (UnionMethodMatcher)obj;
            return this.a.equals(that.a) && this.b.equals(that.b);
        }

        public int hashCode() {
            int code = 17;
            code = 37 * code + this.a.hashCode();
            code = 37 * code + this.b.hashCode();
            return code;
        }
    }
}

