/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.collections.buffer;

import com.bmc.thirdparty.org.apache.commons.collections.Buffer;
import com.bmc.thirdparty.org.apache.commons.collections.BufferUnderflowException;
import com.bmc.thirdparty.org.apache.commons.collections.buffer.SynchronizedBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;

public class BlockingBuffer
extends SynchronizedBuffer {
    private static final long serialVersionUID = 1719328905017860541L;
    private final long timeout;

    public static Buffer decorate(Buffer buffer) {
        return new BlockingBuffer(buffer);
    }

    public static Buffer decorate(Buffer buffer, long timeoutMillis) {
        return new BlockingBuffer(buffer, timeoutMillis);
    }

    protected BlockingBuffer(Buffer buffer) {
        super(buffer);
        this.timeout = 0L;
    }

    protected BlockingBuffer(Buffer buffer, long timeoutMillis) {
        super(buffer);
        this.timeout = timeoutMillis < 0L ? 0L : timeoutMillis;
    }

    public boolean add(Object o2) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.collection.add(o2);
            this.lock.notifyAll();
            boolean bl = result;
            return bl;
        }
    }

    public boolean addAll(Collection c2) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.collection.addAll(c2);
            this.lock.notifyAll();
            boolean bl = result;
            return bl;
        }
    }

    public Object get() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    if (this.timeout <= 0L) {
                        this.lock.wait();
                        continue;
                    }
                    Object object2 = this.get(this.timeout);
                    return object2;
                }
                catch (InterruptedException e2) {
                    PrintWriter out = new PrintWriter(new StringWriter());
                    e2.printStackTrace(out);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + out.toString());
                }
            }
            Object object3 = this.getBuffer().get();
            return object3;
        }
    }

    public Object get(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            long expiration = System.currentTimeMillis() + timeout;
            long timeLeft = expiration - System.currentTimeMillis();
            while (timeLeft > 0L && this.collection.isEmpty()) {
                try {
                    this.lock.wait(timeLeft);
                    timeLeft = expiration - System.currentTimeMillis();
                }
                catch (InterruptedException e2) {
                    PrintWriter out = new PrintWriter(new StringWriter());
                    e2.printStackTrace(out);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + out.toString());
                }
            }
            if (this.collection.isEmpty()) {
                throw new BufferUnderflowException("Timeout expired");
            }
            Object object2 = this.getBuffer().get();
            return object2;
        }
    }

    public Object remove() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    if (this.timeout <= 0L) {
                        this.lock.wait();
                        continue;
                    }
                    Object object2 = this.remove(this.timeout);
                    return object2;
                }
                catch (InterruptedException e2) {
                    PrintWriter out = new PrintWriter(new StringWriter());
                    e2.printStackTrace(out);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + out.toString());
                }
            }
            Object object3 = this.getBuffer().remove();
            return object3;
        }
    }

    public Object remove(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            long expiration = System.currentTimeMillis() + timeout;
            long timeLeft = expiration - System.currentTimeMillis();
            while (timeLeft > 0L && this.collection.isEmpty()) {
                try {
                    this.lock.wait(timeLeft);
                    timeLeft = expiration - System.currentTimeMillis();
                }
                catch (InterruptedException e2) {
                    PrintWriter out = new PrintWriter(new StringWriter());
                    e2.printStackTrace(out);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + out.toString());
                }
            }
            if (this.collection.isEmpty()) {
                throw new BufferUnderflowException("Timeout expired");
            }
            Object object2 = this.getBuffer().remove();
            return object2;
        }
    }
}

