/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.PropInfo;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.apiconverter.ArAttachmentInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.arsys.arcompress.ARCompressor;
import com.bmc.arsys.arcompress.ARDecompressor;
import com.bmc.arsys.arrpc.ArAttachStruct8;
import com.bmc.arsys.arrpc.ArBufStruct8;
import com.bmc.arsys.arrpc.ArLocStruct8;
import com.bmc.arsys.arrpc.ArPropList;
import com.bmc.arsys.arrpc.ArPropStruct;
import com.bmc.arsys.arrpc.ArTimestamp;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.utils.ARByteArrayBuffer;
import com.bmc.arsys.utils.StringByteUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;

public class ValueObjectFactory {
    public static ArValueStruct setValueObject(int n, Value value, String string) throws ARException {
        ArValueStruct arValueStruct = ValueObjectFactory.setValueObject(value, string);
        return arValueStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArValueStruct setValueObject(Value value, String string) throws ARException {
        if (value == null) {
            return new ArValueStruct();
        }
        ArValueStruct arValueStruct = null;
        int n = value.getDataType().toInt();
        Object object = value.getValue();
        if (object == null) {
            switch (n) {
                case 4: 
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 41: 
                case 42: 
                case 43: {
                    n = 0;
                }
            }
        }
        switch (n) {
            case 9: {
                return new ArValueStruct(n, (Object)ApiToRpcMapping.getInstance().toRpcArByteList((ByteListValue)object));
            }
            case 7: {
                return new ArValueStruct(n, (Object)new ArTimestamp((int)((Timestamp)object).getValue()));
            }
            case 13: {
                return new ArValueStruct(n, (Object)((DateInfo)object).getValue());
            }
            case 14: {
                return new ArValueStruct(n, (Object)((int)((Time)object).getValue()));
            }
            case 10: {
                return new ArValueStruct(n, (Object)ConversionUtil.getStringValue((Object)((BigDecimal)object)));
            }
            case 12: {
                return new ArValueStruct(n, (Object)ApiToRpcMapping.getInstance().toRpcArCurrencyStruct((CurrencyValue)object));
            }
            case 41: {
                return new ArValueStruct(n, (Object)ApiToRpcMapping.getInstance().toRpcArCoordList((List)object));
            }
            case 11: {
                AttachmentValue attachmentValue = (AttachmentValue)object;
                byte[] byArray = new byte[]{};
                if (attachmentValue == null) return new ArValueStruct(49, (Object)new ArAttachStruct8());
                if (attachmentValue.getContent() == null) return new ArValueStruct(49, (Object)new ArAttachStruct8());
                ARCompressor aRCompressor = new ARCompressor();
                byte[] byArray2 = attachmentValue.getContent();
                ARByteArrayBuffer aRByteArrayBuffer = new ARByteArrayBuffer();
                try {
                    aRCompressor.setInput(byArray2);
                    int n2 = aRCompressor.deflate(aRByteArrayBuffer);
                    attachmentValue.setCompressedSize((long)n2);
                    byArray = aRByteArrayBuffer.getBuffer();
                }
                finally {
                    aRByteArrayBuffer.setBuffer(null);
                    aRByteArrayBuffer = null;
                    aRCompressor = null;
                }
                ArLocStruct8 arLocStruct8 = new ArLocStruct8(attachmentValue.getLocationType(), (Object)new ArBufStruct8(byArray));
                return new ArValueStruct(49, (Object)new ArAttachStruct8(attachmentValue.getName(), (int)attachmentValue.getOriginalSize(), (int)attachmentValue.getCompressedSize(), arLocStruct8));
            }
            case 8: 
            case 40: {
                return new ArValueStruct(n, (Object)StringByteUtil.longToULong((long)((Long)object)));
            }
            case 5: {
                if (object instanceof DiaryListValue) {
                    if (((DiaryListValue)object).getAppendedText() == null) return new ArValueStruct(n, (Object)((DiaryListValue)object).encode());
                    return new ArValueStruct(n, (Object)((DiaryListValue)object).getAppendedText());
                }
                if (!(object instanceof String)) return new ArValueStruct(n, (Object)"");
                return new ArValueStruct(n, object);
            }
            case 1: {
                return new ArValueStruct(n, (Object)((Keyword)value.getValue()).toInt());
            }
            case 6: {
                return new ArValueStruct(n, (Object)((Number)value.getValue()).intValue());
            }
            default: {
                return new ArValueStruct(n, object);
            }
        }
    }

    public static Value getValueObject(int n, ArValueStruct arValueStruct, String string) throws ARException {
        Value value = null;
        value = ValueObjectFactory.getValueObject(arValueStruct);
        return value;
    }

    public static Value getValueObject(ArValueStruct arValueStruct) throws ARException {
        if (arValueStruct == null) {
            return new Value();
        }
        Value value = null;
        switch (arValueStruct.dataType) {
            case 0: {
                value = new Value();
                break;
            }
            case 1: {
                value = new Value(Keyword.toKeyword((int)arValueStruct.keyNum));
                break;
            }
            case 2: {
                value = new Value(arValueStruct.intVal);
                break;
            }
            case 3: {
                value = new Value(arValueStruct.realVal);
                break;
            }
            case 4: 
            case 42: 
            case 43: {
                value = new Value(arValueStruct.charVal);
                break;
            }
            case 5: {
                try {
                    value = new Value(DiaryListValue.decode((String)arValueStruct.diaryVal));
                }
                catch (ARException aRException) {
                    value = new Value((Object)arValueStruct.diaryVal, DataType.DIARY);
                }
                break;
            }
            case 6: {
                value = new Value((Object)new Integer(arValueStruct.enumVal), DataType.toDataType((int)6));
                break;
            }
            case 7: {
                value = new Value(new Timestamp((long)arValueStruct.timeVal.getValue()));
                break;
            }
            case 8: {
                value = new Value(ValueObjectFactory.intToULong(arValueStruct.maskVal));
                break;
            }
            case 10: {
                value = new Value(new BigDecimal(arValueStruct.decimalVal));
                break;
            }
            case 11: {
                ARDecompressor aRDecompressor = new ARDecompressor();
                try {
                    byte[] byArray = arValueStruct.attachVal.getLoc().buf.getBuffer();
                    aRDecompressor.setInput(byArray);
                    byte[] byArray2 = aRDecompressor.inflate();
                    AttachmentValue attachmentValue = new AttachmentValue(arValueStruct.attachVal.getName(), byArray2);
                    attachmentValue.setCompressedSize((long)arValueStruct.attachVal.getCompSize());
                    attachmentValue.setOriginalSize((long)arValueStruct.attachVal.getOrigSize());
                    value = new Value(attachmentValue);
                    break;
                }
                catch (DataFormatException dataFormatException) {
                    throw new ARException(2, 160, dataFormatException.getMessage());
                }
                finally {
                    aRDecompressor.end();
                    aRDecompressor = null;
                }
            }
            case 12: {
                value = new Value(ApiToRpcMapping.getInstance().fromRpcArCurrencyStructToCurrencyInfo(arValueStruct.currencyVal));
                break;
            }
            case 13: {
                value = new Value(new DateInfo(arValueStruct.dateVal));
                break;
            }
            case 14: {
                value = new Value(new Time((long)arValueStruct.timeOfDayVal));
                break;
            }
            case 40: {
                value = new Value(ValueObjectFactory.intToULong(arValueStruct.ulongVal));
                break;
            }
            case 49: {
                ArAttachStruct8 arAttachStruct8 = arValueStruct.attachVal8;
                if (arAttachStruct8 == null) break;
                value = new Value((AttachmentValue)new ArAttachmentInfo(arAttachStruct8.getName(), (long)arAttachStruct8.getOrigSize(), (long)arAttachStruct8.getCompSize(), arAttachStruct8.getLoc().buf.getBuffer(), ArAttachmentInfo.UNCOMPRESS));
                break;
            }
            case 9: {
                value = new Value(new ByteListValue(41, arValueStruct.byteListVal.getBytes()));
                break;
            }
            case 41: {
                value = new Value(ApiToRpcMapping.getInstance().fromRpcArCoordList(arValueStruct.coordListVal));
                break;
            }
            default: {
                throw new IllegalArgumentException("datatype not supported by Value");
            }
        }
        return value;
    }

    public static long intToULong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int uLongToInt(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public static PropInfo[] getPropList(ArPropList arPropList) throws ARException {
        if (arPropList == null) {
            return null;
        }
        PropInfo[] propInfoArray = new PropInfo[arPropList.value.length];
        for (int i = 0; i < arPropList.value.length; ++i) {
            Value value = ValueObjectFactory.getValueObject(arPropList.value[i].value);
            propInfoArray[i] = new PropInfo(arPropList.value[i].prop, value);
        }
        return propInfoArray;
    }

    public static ArPropList setPropList(PropInfo[] propInfoArray) throws ARException {
        if (propInfoArray == null) {
            return null;
        }
        ArrayList<ArPropStruct> arrayList = new ArrayList<ArPropStruct>();
        for (int i = 0; i < propInfoArray.length; ++i) {
            if (propInfoArray[i] == null) continue;
            ArValueStruct arValueStruct = ValueObjectFactory.setValueObject(propInfoArray[i].getPropertyValue(), ARPluginSvrThreadLocalStorageBlock.getTLB().getRemoteHostCharSet());
            arrayList.add(new ArPropStruct(propInfoArray[i].getPropertyTag(), arValueStruct));
        }
        return new ArPropList(arrayList.toArray(new ArPropStruct[arrayList.size()]));
    }
}

