/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.registry;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.webservices.uddiapi.Criteria;
import com.bmc.webservices.uddiapi.CriteriaArrayList;
import com.bmc.webservices.uddiapi.RegistryServerInfo;
import com.bmc.webservices.uddiapi.RegistryServerInfoFactory;
import com.bmc.webservices.uddiapi.Service;
import com.bmc.webservices.uddiapi.ServiceAccessPoint;
import com.bmc.webservices.uddiapi.ServiceArrayList;
import com.bmc.webservices.uddiapi.UDDIRegistry;
import com.bmc.webservices.uddiapi.UDDIRegistryFactory;
import com.bmc.webservices.uddiapi.User;
import com.bmc.webservices.uddiapi.UserFactory;
import com.bmc.webservices.uddiapi.impl.CriteriaImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARDBCRegistryQuery
extends ARDBCPlugin {
    private String sBNKeyword = "BN";
    private String sANKeyword = "AN";
    private String sWSKeyword = "W";
    private String sWSVKeyword = "WV";
    private String sIVKeyword = "IV";
    private String sCLKeyword = "CL";
    private RegistryServerInfo serverInfo;
    private UDDIRegistry uddiRegistry;
    private User user;
    private String registryLocation = null;
    private String tempRegLocation = null;
    private String registryAdminUser;
    private String registryAdminPassword;
    private URL securityServiceAccessPoint;
    private URL inquiryAccessPoint;
    private URL publishingAccessPoint;
    private URL subscriptionAccessPoint;
    private int onEventFlag = 0;
    private boolean checkLocation = true;
    private ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARDBC.REGISTRY", this);
    private final ReentrantLock lock = new ReentrantLock();
    String urlWsdl = "";
    String urlEP = "";
    String keyKey = "";
    String applicationName = "";
    String businessName = "";
    String webService = "";
    String webServiceVersion = "";
    String criteriaList = "";
    String interfaceVersion = "";

    public static void init(ARPluginContext aRPluginContext) {
        System.out.println("Static initialize method invoked");
        System.out.println("UserDefined value for ARRegistry " + aRPluginContext.getConfigItem("ARRegistry"));
    }

    @Override
    public List<VendorForm> getListForms(ARPluginContext aRPluginContext) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getListForms()");
        ArrayList<VendorForm> arrayList = new ArrayList<VendorForm>();
        VendorForm vendorForm = new VendorForm("ARSYS.ARDBC.REGISTRY", "AR System WebService Registry Query");
        try {
            arrayList.add(vendorForm);
        }
        catch (Exception exception) {
            new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error fetching table names from the datasource", exception.getMessage())));
        }
        return arrayList;
    }

    @Override
    public List<ARVendorField> getMultipleFields(ARPluginContext aRPluginContext, VendorForm vendorForm) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getMultipleFields()");
        ArrayList<ARVendorField> arrayList = new ArrayList<ARVendorField>();
        ARVendorField aRVendorField = null;
        CharacterFieldLimit characterFieldLimit = null;
        try {
            characterFieldLimit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            aRVendorField = new ARVendorField("Business Name", 8033, 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("Application Name", 8034, 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            characterFieldLimit = new CharacterFieldLimit(255, 2, 1, "WebServiceList", null, 0);
            aRVendorField = new ARVendorField("Web Service", 8037, 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            characterFieldLimit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            aRVendorField = new ARVendorField("Application Version", 8038, 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("WSDL URL", 8059, 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("End Point URL", 8061, 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            characterFieldLimit = new CharacterFieldLimit(0, 2, 1, null, null, 0);
            aRVendorField = new ARVendorField("Category List", 8086, 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            characterFieldLimit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            aRVendorField = new ARVendorField("Interface Version", 8088, 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
        }
        catch (Exception exception) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error fetching Columnnames for the table " + vendorForm.getTableName(), exception.getMessage())));
        }
        return arrayList;
    }

    private void parseQualifierToGetKey(QualifierInfo qualifierInfo) throws ARException {
        try {
            if (qualifierInfo == null) {
                return;
            }
            switch (qualifierInfo.getOperation()) {
                case 1: 
                case 2: {
                    this.parseQualifierToGetKey(qualifierInfo.getLeftOperand());
                    this.parseQualifierToGetKey(qualifierInfo.getRightOperand());
                    return;
                }
                case 3: {
                    return;
                }
                case 5: {
                    return;
                }
                case 0: {
                    return;
                }
                case 4: {
                    if (qualifierInfo.getRelationalOperationInfo().getOperation() == 1 || qualifierInfo.getRelationalOperationInfo().getOperation() == 7) {
                        if (this.businessName == "" && (qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sBNKeyword) || qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8033L).toString()))) {
                            this.businessName = qualifierInfo.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.applicationName == "" && (qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sANKeyword) || qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8034L).toString()))) {
                            this.applicationName = qualifierInfo.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.webService == "" && (qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sWSKeyword) || qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8037L).toString()))) {
                            this.webService = qualifierInfo.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.webServiceVersion == "" && (qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sWSVKeyword) || qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8038L).toString()))) {
                            this.webServiceVersion = qualifierInfo.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.interfaceVersion == "" && (qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sIVKeyword) || qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8088L).toString()))) {
                            this.interfaceVersion = qualifierInfo.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        } else if (this.criteriaList == "" && (qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(this.sCLKeyword) || qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(8086L).toString()))) {
                            this.criteriaList = qualifierInfo.getRelationalOperationInfo().getRightOperand().getValue().toString();
                        }
                    }
                    return;
                }
            }
            throw new ARException(2, 142, Integer.toString(qualifierInfo.getOperation()));
        }
        catch (Exception exception) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error parsing qualification", exception.getMessage())));
            return;
        }
    }

    @Override
    public List<Entry> getListEntryWithFields(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, QualifierInfo qualifierInfo, List<SortInfo> list2, List<EntryListFieldInfo> list3, int n, int n2, OutputInteger outputInteger) throws ARException {
        ArrayList<Entry> arrayList;
        block47: {
            aRPluginContext.logMessage(this.pluginInfo, 0, "getListEntryWithFields()");
            arrayList = new ArrayList<Entry>();
            Entry entry = null;
            ServiceArrayList serviceArrayList = null;
            CriteriaArrayList criteriaArrayList = null;
            String string2 = "";
            try {
                int n3;
                this.businessName = "";
                this.applicationName = "";
                this.webService = "";
                this.webServiceVersion = "";
                this.criteriaList = "";
                this.interfaceVersion = "";
                criteriaArrayList = null;
                this.parseQualifierToGetKey(qualifierInfo);
                aRPluginContext.logMessage(this.pluginInfo, 0, "businessName=" + this.businessName);
                aRPluginContext.logMessage(this.pluginInfo, 0, "applicationName=" + this.applicationName);
                aRPluginContext.logMessage(this.pluginInfo, 0, "webService=" + this.webService);
                aRPluginContext.logMessage(this.pluginInfo, 0, "webServiceVersion=" + this.webServiceVersion);
                aRPluginContext.logMessage(this.pluginInfo, 0, "criteriaList=" + this.criteriaList);
                aRPluginContext.logMessage(this.pluginInfo, 0, "interfaceVersion=" + this.interfaceVersion);
                if (this.businessName != "") {
                    this.businessName = this.businessName.replace("\\Q", "\\\\Q");
                    this.businessName = this.businessName.replace("\\E", "\\\\E");
                    if (this.businessName.startsWith("%") && this.businessName.endsWith("%")) {
                        string2 = ".*\\Q";
                        this.businessName = this.businessName.replace("%", "");
                        string2 = string2.concat(this.businessName);
                        string2 = string2.concat("\\E.*");
                    } else if (this.businessName.endsWith("%")) {
                        string2 = "^\\Q";
                        this.businessName = this.businessName.replace("%", "");
                        string2 = string2.concat(this.businessName);
                        string2 = string2.concat("\\E");
                    } else {
                        string2 = "^\\Q";
                        this.businessName = this.businessName.replace("%", "");
                        string2 = string2.concat(this.businessName);
                        string2 = string2.concat("\\E$");
                    }
                    this.businessName = string2;
                }
                if (this.applicationName != "") {
                    this.applicationName = this.applicationName.replace("\\Q", "\\\\Q");
                    this.applicationName = this.applicationName.replace("\\E", "\\\\E");
                    if (this.applicationName.startsWith("%") && this.applicationName.endsWith("%")) {
                        string2 = ".*\\Q";
                        this.applicationName = this.applicationName.replace("%", "");
                        string2 = string2.concat(this.applicationName);
                        string2 = string2.concat("\\E.*");
                    } else if (this.applicationName.endsWith("%")) {
                        string2 = "^\\Q";
                        this.applicationName = this.applicationName.replace("%", "");
                        string2 = string2.concat(this.applicationName);
                        string2 = string2.concat("\\E");
                    } else {
                        string2 = "^\\Q";
                        this.applicationName = this.applicationName.replace("%", "");
                        string2 = string2.concat(this.applicationName);
                        string2 = string2.concat("\\E$");
                    }
                    this.applicationName = string2;
                }
                if (this.webService != "") {
                    this.webService = this.webService.replace("\\Q", "\\\\Q");
                    this.webService = this.webService.replace("\\E", "\\\\E");
                    if (this.webService.startsWith("%") && this.webService.endsWith("%")) {
                        string2 = ".*\\Q";
                        this.webService = this.webService.replace("%", "");
                        string2 = string2.concat(this.webService);
                        string2 = string2.concat("\\E.*");
                    } else if (this.webService.endsWith("%")) {
                        string2 = "^\\Q";
                        this.webService = this.webService.replace("%", "");
                        string2 = string2.concat(this.webService);
                        string2 = string2.concat("\\E");
                    } else {
                        string2 = "^\\Q";
                        this.webService = this.webService.replace("%", "");
                        string2 = string2.concat(this.webService);
                        string2 = string2.concat("\\E$");
                    }
                    this.webService = string2;
                }
                if (this.webServiceVersion != "") {
                    this.webServiceVersion = this.webServiceVersion.replace("\\Q", "\\\\Q");
                    this.webServiceVersion = this.webServiceVersion.replace("\\E", "\\\\E");
                    if (this.webServiceVersion.startsWith("%") && this.webServiceVersion.endsWith("%")) {
                        string2 = ".*\\Q";
                        this.webServiceVersion = this.webServiceVersion.replace("%", "");
                        string2 = string2.concat(this.webServiceVersion);
                        string2 = string2.concat("\\E.*");
                    } else if (this.webServiceVersion.endsWith("%")) {
                        string2 = "^\\Q";
                        this.webServiceVersion = this.webServiceVersion.replace("%", "");
                        string2 = string2.concat(this.webServiceVersion);
                        string2 = string2.concat("\\E");
                    } else {
                        string2 = "^\\Q";
                        this.webServiceVersion = this.webServiceVersion.replace("%", "");
                        string2 = string2.concat(this.webServiceVersion);
                        string2 = string2.concat("\\E$");
                    }
                    this.webServiceVersion = string2;
                }
                if (this.interfaceVersion != "") {
                    this.interfaceVersion = this.interfaceVersion.replace("\\Q", "\\\\Q");
                    this.interfaceVersion = this.interfaceVersion.replace("\\E", "\\\\E");
                    if (this.interfaceVersion.startsWith("%") && this.interfaceVersion.endsWith("%")) {
                        string2 = ".*\\Q";
                        this.interfaceVersion = this.interfaceVersion.replace("%", "");
                        string2 = string2.concat(this.interfaceVersion);
                        string2 = string2.concat("\\E.*");
                    } else if (this.interfaceVersion.endsWith("%")) {
                        string2 = "^\\Q";
                        this.interfaceVersion = this.interfaceVersion.replace("%", "");
                        string2 = string2.concat(this.interfaceVersion);
                        string2 = string2.concat("\\E");
                    } else {
                        string2 = "^\\Q";
                        this.interfaceVersion = this.interfaceVersion.replace("%", "");
                        string2 = string2.concat(this.interfaceVersion);
                        string2 = string2.concat("\\E$");
                    }
                    this.interfaceVersion = string2;
                }
                if (this.criteriaList != "") {
                    if (this.criteriaList.startsWith("%") && this.criteriaList.endsWith("%")) {
                        this.criteriaList = string2 = this.criteriaList.substring(1, this.criteriaList.length() - 1);
                    }
                    criteriaArrayList = new CriteriaArrayList();
                    String[] stringArray = this.criteriaList.split(";");
                    aRPluginContext.logMessage(this.pluginInfo, 0, "arrayCriteria.length=" + stringArray.length);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        if (n3 == 0 && this.criteriaList.startsWith(";")) continue;
                        String[] stringArray2 = stringArray[n3].split("=");
                        aRPluginContext.logMessage(this.pluginInfo, 0, "Before replace");
                        aRPluginContext.logMessage(this.pluginInfo, 0, "keyNameValue.length=" + stringArray2.length);
                        aRPluginContext.logMessage(this.pluginInfo, 0, "keyNameValue[0]=" + stringArray2[0] + ";keyNameValue[1]=" + stringArray2[1]);
                        if (stringArray2[0].contains("%")) {
                            stringArray2[0] = stringArray2[0].replace("%", "");
                        }
                        stringArray2[1] = stringArray2[1].replace("\\Q", "\\\\Q");
                        stringArray2[1] = stringArray2[1].replace("\\E", "\\\\E");
                        if (stringArray2[1].startsWith("%") && stringArray2[1].endsWith("%")) {
                            string2 = ".*\\Q";
                            stringArray2[1] = stringArray2[1].replace("%", "");
                            string2 = string2.concat(stringArray2[1]);
                            string2 = string2.concat("\\E.*");
                        } else if (stringArray2[1].endsWith("%")) {
                            string2 = "^\\Q";
                            stringArray2[1] = stringArray2[1].replace("%", "");
                            string2 = string2.concat(stringArray2[1]);
                            string2 = string2.concat("\\E");
                        } else {
                            string2 = "^\\Q";
                            stringArray2[1] = stringArray2[1].replace("%", "");
                            string2 = string2.concat(stringArray2[1]);
                            string2 = string2.concat("\\E$");
                        }
                        stringArray2[1] = string2;
                        aRPluginContext.logMessage(this.pluginInfo, 0, "After replace");
                        aRPluginContext.logMessage(this.pluginInfo, 0, "keyNameValue.length=" + stringArray2.length);
                        aRPluginContext.logMessage(this.pluginInfo, 0, "keyNameValue[0]=" + stringArray2[0] + ";keyNameValue[1]=" + stringArray2[1]);
                        CriteriaImpl criteriaImpl = new CriteriaImpl(stringArray2[0], stringArray2[1]);
                        criteriaArrayList.add((Object)criteriaImpl);
                    }
                }
                aRPluginContext.logMessage(this.pluginInfo, 0, "after replace");
                aRPluginContext.logMessage(this.pluginInfo, 0, "businessName=" + this.businessName);
                aRPluginContext.logMessage(this.pluginInfo, 0, "applicationName=" + this.applicationName);
                aRPluginContext.logMessage(this.pluginInfo, 0, "webService=" + this.webService);
                aRPluginContext.logMessage(this.pluginInfo, 0, "webServiceVersion=" + this.webServiceVersion);
                aRPluginContext.logMessage(this.pluginInfo, 0, "interfaceVersion=" + this.interfaceVersion);
                serviceArrayList = this.uddiRegistry.findServices(this.user, this.businessName, this.applicationName, this.webService, this.webServiceVersion, this.interfaceVersion, criteriaArrayList);
                this.businessName = "";
                this.applicationName = "";
                this.webService = "";
                this.webServiceVersion = "";
                this.criteriaList = "";
                this.interfaceVersion = "";
                criteriaArrayList = null;
                if (serviceArrayList == null) break block47;
                aRPluginContext.logMessage(this.pluginInfo, 0, "serviceList.size()=" + serviceArrayList.size());
                outputInteger.setValue(serviceArrayList.size());
                for (n3 = 0; n3 < serviceArrayList.size(); ++n3) {
                    this.businessName = ((Service)serviceArrayList.get(n3)).getBusinessName();
                    this.applicationName = ((Service)serviceArrayList.get(n3)).getApplicationName();
                    this.webService = ((Service)serviceArrayList.get(n3)).getName();
                    this.webServiceVersion = ((Service)serviceArrayList.get(n3)).getVersion();
                    this.interfaceVersion = ((Service)serviceArrayList.get(n3)).getInterfaceVersion() != null ? ((Service)serviceArrayList.get(n3)).getInterfaceVersion() : "";
                    aRPluginContext.logMessage(this.pluginInfo, 0, "i=" + n3);
                    aRPluginContext.logMessage(this.pluginInfo, 0, "businessName=" + this.businessName);
                    aRPluginContext.logMessage(this.pluginInfo, 0, "applicationName=" + this.applicationName);
                    aRPluginContext.logMessage(this.pluginInfo, 0, "webService=" + this.webService);
                    aRPluginContext.logMessage(this.pluginInfo, 0, "webServiceVersion=" + this.webServiceVersion);
                    aRPluginContext.logMessage(this.pluginInfo, 0, "interfaceVersion=" + this.interfaceVersion);
                    aRPluginContext.logMessage(this.pluginInfo, 0, "serviceList.get(i).getAccessPoints().size()" + ((Service)serviceArrayList.get(n3)).getAccessPoints().size());
                    if (((Service)serviceArrayList.get(n3)).getAccessPoints() != null && ((Service)serviceArrayList.get(n3)).getAccessPoints().size() > 0) {
                        for (int i = 0; i < ((Service)serviceArrayList.get(n3)).getAccessPoints().size(); ++i) {
                            this.urlWsdl = "";
                            this.urlEP = "";
                            aRPluginContext.logMessage(this.pluginInfo, 0, "j=" + i);
                            if (((ServiceAccessPoint)((Service)serviceArrayList.get(n3)).getAccessPoints().get(i)).getWsdlAccessPointUrl() != null) {
                                this.urlWsdl = ((ServiceAccessPoint)((Service)serviceArrayList.get(n3)).getAccessPoints().get(i)).getWsdlAccessPointUrl().toString();
                            }
                            if (((ServiceAccessPoint)((Service)serviceArrayList.get(n3)).getAccessPoints().get(i)).getAccessPointUrl() != null) {
                                this.urlEP = ((ServiceAccessPoint)((Service)serviceArrayList.get(n3)).getAccessPoints().get(i)).getAccessPointUrl().toString();
                            }
                            entry = new Entry();
                            entry.put(Integer.valueOf(8033), new Value(this.businessName));
                            entry.put(Integer.valueOf(8034), new Value(this.applicationName));
                            entry.put(Integer.valueOf(8037), new Value(this.webService));
                            entry.put(Integer.valueOf(8038), new Value(this.webServiceVersion));
                            entry.put(Integer.valueOf(8088), new Value(this.interfaceVersion));
                            entry.put(Integer.valueOf(8059), new Value(this.urlWsdl));
                            entry.put(Integer.valueOf(8061), new Value(this.urlEP));
                            if (((ServiceAccessPoint)((Service)serviceArrayList.get(n3)).getAccessPoints().get(i)).getCriteriaArrayList() != null && ((ServiceAccessPoint)((Service)serviceArrayList.get(n3)).getAccessPoints().get(i)).getCriteriaArrayList().size() > 0) {
                                this.criteriaList = "";
                                CriteriaArrayList criteriaArrayList2 = ((ServiceAccessPoint)((Service)serviceArrayList.get(n3)).getAccessPoints().get(i)).getCriteriaArrayList();
                                aRPluginContext.logMessage(this.pluginInfo, 0, "i=" + n3 + ";j=" + i);
                                aRPluginContext.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.size()=" + criteriaArrayList2.size());
                                for (int j = 0; j < criteriaArrayList2.size(); ++j) {
                                    if (((Criteria)criteriaArrayList2.get(j)).getKeyName() != null && ((Criteria)criteriaArrayList2.get(j)).getKeyValue() != null) {
                                        if (this.criteriaList == "") {
                                            this.criteriaList = ((Criteria)criteriaArrayList2.get(j)).getKeyName() + "=" + ((Criteria)criteriaArrayList2.get(j)).getKeyValue() + ";";
                                        } else {
                                            String string3 = ((Criteria)criteriaArrayList2.get(j)).getKeyName() + "=" + ((Criteria)criteriaArrayList2.get(j)).getKeyValue() + ";";
                                            this.criteriaList = this.criteriaList.concat(string3);
                                            string3 = null;
                                        }
                                    }
                                    aRPluginContext.logMessage(this.pluginInfo, 0, "k=" + j);
                                    aRPluginContext.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.get(k).getKeyName()=" + ((Criteria)criteriaArrayList2.get(j)).getKeyName());
                                    aRPluginContext.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.get(k).getKeyValue()=" + ((Criteria)criteriaArrayList2.get(j)).getKeyValue());
                                    aRPluginContext.logMessage(this.pluginInfo, 0, "criteriaList=" + this.criteriaList);
                                }
                                entry.put(Integer.valueOf(8086), new Value(this.criteriaList));
                                this.keyKey = "#8033#:" + this.businessName + ";" + "#" + 8034L + "#:" + this.applicationName + ";" + "#" + 8037L + "#:" + this.webService + ";" + "#" + 8038L + "#:" + this.webServiceVersion + ";" + "#" + 8086L + "#:" + this.criteriaList;
                            } else {
                                this.keyKey = "#8033#:" + this.businessName + ";" + "#" + 8034L + "#:" + this.applicationName + ";" + "#" + 8037L + "#:" + this.webService + ";" + "#" + 8038L + "#:" + this.webServiceVersion + ";";
                            }
                            entry.put(Integer.valueOf(1), new Value(this.keyKey));
                            arrayList.add(entry);
                            this.keyKey = "";
                            this.applicationName = "";
                            this.businessName = "";
                            this.webService = "";
                            this.webServiceVersion = "";
                            this.urlWsdl = "";
                            this.urlEP = "";
                            this.interfaceVersion = "";
                        }
                        continue;
                    }
                    entry = new Entry();
                    entry.put(Integer.valueOf(8033), new Value(this.businessName));
                    entry.put(Integer.valueOf(8034), new Value(this.applicationName));
                    entry.put(Integer.valueOf(8037), new Value(this.webService));
                    entry.put(Integer.valueOf(8038), new Value(this.webServiceVersion));
                    entry.put(Integer.valueOf(8088), new Value(this.interfaceVersion));
                    this.urlWsdl = ((Service)serviceArrayList.get(n3)).getWsdlURL() != null ? ((Service)serviceArrayList.get(n3)).getWsdlURL().toExternalForm() : "";
                    entry.put(Integer.valueOf(8059), new Value(this.urlWsdl));
                    this.urlEP = ((Service)serviceArrayList.get(n3)).getAccessPointURL() != null ? ((Service)serviceArrayList.get(n3)).getAccessPointURL().toExternalForm() : "";
                    entry.put(Integer.valueOf(8061), new Value(this.urlEP));
                    this.keyKey = "#8033#:" + this.businessName + ";" + "#" + 8034L + "#:" + this.applicationName + ";" + "#" + 8037L + "#:" + this.webService + ";" + "#" + 8038L + "#:" + this.webServiceVersion + ";";
                    entry.put(Integer.valueOf(1), new Value(this.keyKey));
                    arrayList.add(entry);
                    this.keyKey = "";
                    this.applicationName = "";
                    this.businessName = "";
                    this.webService = "";
                    this.webServiceVersion = "";
                    this.urlWsdl = "";
                    this.urlEP = "";
                    this.interfaceVersion = "";
                }
            }
            catch (Exception exception) {
                new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error fetching entries for given qualification from table " + string, exception.getMessage())));
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            new ARException(Arrays.asList(new StatusInfo(2, 1005L, "No entries for table " + string, "")));
        }
        return arrayList;
    }

    @Override
    public Entry getEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, int[] nArray) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getEntry()");
        Entry entry = null;
        Service service = null;
        String string3 = new String();
        CriteriaArrayList criteriaArrayList = null;
        String[] stringArray = new String[5];
        try {
            aRPluginContext.logMessage(this.pluginInfo, 0, "Get Entry: entryId" + string2);
            this.getKeyAttrValues(string2, stringArray);
            aRPluginContext.logMessage(this.pluginInfo, 0, "Business-keyAttr[0]:" + stringArray[0]);
            aRPluginContext.logMessage(this.pluginInfo, 0, "App-keyAttr[1]:" + stringArray[1]);
            aRPluginContext.logMessage(this.pluginInfo, 0, "WS-keyAttr[2]:" + stringArray[2]);
            aRPluginContext.logMessage(this.pluginInfo, 0, "WSV-keyAttr[3]:" + stringArray[3]);
            aRPluginContext.logMessage(this.pluginInfo, 0, "WSV-keyAttr[4]:" + stringArray[4]);
            if (stringArray[4] != "") {
                criteriaArrayList = new CriteriaArrayList();
                String[] stringArray2 = stringArray[4].split(";");
                aRPluginContext.logMessage(this.pluginInfo, 0, " Get Entry: arrayCriteria.length=" + stringArray2.length);
                for (int i = 0; i < stringArray2.length; ++i) {
                    String[] stringArray3 = stringArray2[i].split("=");
                    aRPluginContext.logMessage(this.pluginInfo, 0, "keyNameValue.length=" + stringArray3.length);
                    aRPluginContext.logMessage(this.pluginInfo, 0, "keyNameValue[0]=" + stringArray3[0] + ";keyNameValue[1]=" + stringArray3[1]);
                    CriteriaImpl criteriaImpl = new CriteriaImpl(stringArray3[0], stringArray3[1]);
                    criteriaArrayList.add((Object)criteriaImpl);
                }
            }
            if ((service = this.uddiRegistry.findService(this.user, stringArray[0], stringArray[1], stringArray[2], stringArray[3], criteriaArrayList)) != null) {
                entry = new Entry();
                entry.put(Integer.valueOf(1), new Value(service.getKey()));
                entry.put(Integer.valueOf(8033), new Value(service.getBusinessName()));
                entry.put(Integer.valueOf(8034), new Value(service.getApplicationName()));
                entry.put(Integer.valueOf(8037), new Value(service.getName()));
                entry.put(Integer.valueOf(8038), new Value(service.getVersion()));
                if (service.getInterfaceVersion() != null) {
                    entry.put(Integer.valueOf(8088), new Value(service.getInterfaceVersion()));
                } else {
                    entry.put(Integer.valueOf(8088), new Value(""));
                }
                if (service.getWsdlURL() != null) {
                    string3 = service.getWsdlURL().toString();
                    entry.put(Integer.valueOf(8059), new Value(string3));
                } else if (((ServiceAccessPoint)service.getAccessPoints().get(0)).getWsdlAccessPointUrl() != null) {
                    string3 = ((ServiceAccessPoint)service.getAccessPoints().get(0)).getWsdlAccessPointUrl().toString();
                    entry.put(Integer.valueOf(8059), new Value(string3));
                }
                if (service.getAccessPointURL() != null) {
                    string3 = service.getAccessPointURL().toString();
                    entry.put(Integer.valueOf(8061), new Value(string3));
                } else if (((ServiceAccessPoint)service.getAccessPoints().get(0)).getAccessPointUrl() != null) {
                    string3 = ((ServiceAccessPoint)service.getAccessPoints().get(0)).getAccessPointUrl().toString();
                    entry.put(Integer.valueOf(8061), new Value(string3));
                }
                if (((ServiceAccessPoint)service.getAccessPoints().get(0)).getCriteriaArrayList() != null) {
                    String string4 = new String();
                    String string5 = "";
                    CriteriaArrayList criteriaArrayList2 = null;
                    criteriaArrayList2 = ((ServiceAccessPoint)service.getAccessPoints().get(0)).getCriteriaArrayList();
                    aRPluginContext.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.size()=" + criteriaArrayList2.size());
                    for (int i = 0; i < criteriaArrayList2.size(); ++i) {
                        if (((Criteria)criteriaArrayList2.get(i)).getKeyName() != null && ((Criteria)criteriaArrayList2.get(i)).getKeyValue() != null) {
                            if (string5.equals("")) {
                                string5 = ((Criteria)criteriaArrayList2.get(i)).getKeyName() + "=" + ((Criteria)criteriaArrayList2.get(i)).getKeyValue() + ";";
                            } else {
                                string4 = ((Criteria)criteriaArrayList2.get(i)).getKeyName() + "=" + ((Criteria)criteriaArrayList2.get(i)).getKeyValue() + ";";
                                string5 = string5.concat(string4);
                            }
                        }
                        aRPluginContext.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.get(k).getKeyName()=" + ((Criteria)criteriaArrayList2.get(i)).getKeyName());
                        aRPluginContext.logMessage(this.pluginInfo, 0, "tmpCriteriaArrayList.get(k).getKeyValue()=" + ((Criteria)criteriaArrayList2.get(i)).getKeyValue());
                        aRPluginContext.logMessage(this.pluginInfo, 0, "criteriaList=" + string5);
                    }
                    entry.put(Integer.valueOf(8086), new Value(string5));
                }
            }
        }
        catch (Exception exception) {
            StatusInfo statusInfo = new StatusInfo(2, 1004L, "Error fetching entry " + string2 + " from table " + string, exception.getMessage());
            ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
            arrayList.add(statusInfo);
            throw new ARException(arrayList);
        }
        if (entry == null) {
            new ARException(Arrays.asList(new StatusInfo(2, 1006L, "No such entry " + string2 + " for table " + string, "")));
        }
        return entry;
    }

    private void getKeyAttrValues(String string, String[] stringArray) throws ARException {
        int n = 0;
        int n2 = 0;
        String string2 = "";
        try {
            if (string != null) {
                string2 = "#8033#";
                if (string.contains(string2)) {
                    n = string.indexOf(string2);
                    n2 = string.indexOf(";#", n = n + string2.length() + 1);
                    if (n2 == 0) {
                        n2 = string.length() - 1;
                    }
                    stringArray[0] = n2 <= n ? "" : string.substring(n, n2);
                }
                n = 0;
                n2 = 0;
                string2 = "#8034#";
                if (string.contains(string2)) {
                    n = string.indexOf(string2);
                    n2 = string.indexOf(";#", n = n + string2.length() + 1);
                    if (n2 == 0) {
                        n2 = string.length() - 1;
                    }
                    stringArray[1] = n2 <= n ? "" : string.substring(n, n2);
                }
                n = 0;
                n2 = 0;
                string2 = "#8037#";
                if (string.contains(string2)) {
                    n = string.indexOf(string2);
                    n2 = string.indexOf(";#", n = n + string2.length() + 1);
                    if (n2 == 0) {
                        n2 = string.length() - 1;
                    }
                    stringArray[2] = n2 <= n ? "" : string.substring(n, n2);
                }
                n = 0;
                n2 = 0;
                string2 = "#8038#";
                if (string.contains(string2)) {
                    n = string.indexOf(string2);
                    n2 = string.indexOf(";#", n = n + string2.length() + 1);
                    if (n2 == -1) {
                        n2 = string.length() - 1;
                    }
                    stringArray[3] = n2 <= n ? "" : string.substring(n, n2);
                }
                n = 0;
                n2 = 0;
                stringArray[4] = "";
                string2 = "#8086#";
                if (string.contains(string2)) {
                    n = string.indexOf(string2);
                    n2 = string.indexOf(";#", n = n + string2.length() + 1);
                    if (n2 == -1) {
                        n2 = string.length() - 1;
                    }
                    stringArray[4] = n2 <= n ? "" : string.substring(n, n2);
                }
            }
        }
        catch (Exception exception) {
            new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error parsing entry ID " + string, exception.getMessage())));
        }
    }

    @Override
    public void initialize(ARPluginContext aRPluginContext) throws ARException {
        try {
            this.tempRegLocation = aRPluginContext.getARConfigEntry("Registry-Location");
            aRPluginContext.logMessage(this.pluginInfo, 0, "tempRegLocation " + this.tempRegLocation);
            if (this.registryLocation == null && this.tempRegLocation == null || this.tempRegLocation != null && this.tempRegLocation.equals(this.registryLocation)) {
                this.checkLocation = false;
            } else {
                this.registryLocation = this.tempRegLocation;
                this.checkLocation = true;
            }
            if (this.onEventFlag == 1) {
                this.checkLocation = true;
            } else {
                this.onEventFlag = 0;
            }
            aRPluginContext.logMessage(this.pluginInfo, 0, "registry location " + this.registryLocation);
            if (this.registryLocation == null || this.registryLocation.length() == 0) {
                if (this.checkLocation) {
                    aRPluginContext.logMessage(this.pluginInfo, 1, "Null registry location");
                    return;
                }
                return;
            }
            this.registryAdminUser = aRPluginContext.getARConfigEntry("Registry-Admin-User");
            aRPluginContext.logMessage(this.pluginInfo, 0, "registry admin user " + this.registryAdminUser);
            this.registryAdminPassword = aRPluginContext.getARConfigEntry("Registry-Admin-Password");
            if (this.registryAdminPassword != null) {
                PasswordReserveFieldEncryption passwordReserveFieldEncryption = new PasswordReserveFieldEncryption(false);
                byte[] byArray = passwordReserveFieldEncryption.decryptPasswordEx(this.registryAdminPassword.getBytes());
                this.registryAdminPassword = new String(byArray);
            }
            if (this.registryLocation.contains("/uddi")) {
                this.securityServiceAccessPoint = new URL(this.registryLocation + "/services/security");
                this.inquiryAccessPoint = new URL(this.registryLocation + "/services/inquiry");
                this.publishingAccessPoint = new URL(this.registryLocation + "/services/publication");
                this.subscriptionAccessPoint = new URL(this.registryLocation + "/services/subscription");
            } else {
                this.securityServiceAccessPoint = new URL(this.registryLocation + "/uddi/services/security");
                this.inquiryAccessPoint = new URL(this.registryLocation + "/uddi/services/inquiry");
                this.publishingAccessPoint = new URL(this.registryLocation + "/uddi/services/publication");
                this.subscriptionAccessPoint = new URL(this.registryLocation + "/uddi/services/subscription");
            }
            this.serverInfo = RegistryServerInfoFactory.newInstance((URL)this.securityServiceAccessPoint, (URL)this.inquiryAccessPoint, (URL)this.publishingAccessPoint, (URL)this.subscriptionAccessPoint);
            this.uddiRegistry = UDDIRegistryFactory.newInstance((RegistryServerInfo)this.serverInfo);
            this.user = UserFactory.newInstance((String)this.registryAdminUser, (String)this.registryAdminPassword);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ARException(2, 9134, exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ARPluginContext aRPluginContext, int n) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "onEvent()");
        this.lock.lock();
        try {
            if (n == 10005) {
                this.onEventFlag = 1;
                this.initialize(aRPluginContext);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String createEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, Entry entry) throws ARException {
        new ARException(Arrays.asList(new StatusInfo(2, 8750L, "")));
        return null;
    }

    @Override
    public void deleteEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2) throws ARException {
        new ARException(Arrays.asList(new StatusInfo(2, 8752L, "")));
    }

    @Override
    public void setEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, Entry entry, Timestamp timestamp) throws ARException {
        new ARException(Arrays.asList(new StatusInfo(2, 8751L, "")));
    }
}

