/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.tartarus.snowball.SnowballProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSStemmingFilter
extends TokenFilter {
    private static final Logger LOGGER = Logger.getLogger(FTSStemmingFilter.class);
    private SnowballProgram stemmer;
    private Hashtable<String, String> rootTable;
    private boolean addStemmedTerm = false;
    private Token stemmedTerm = new Token();

    public FTSStemmingFilter(TokenStream tokenStream, SnowballProgram snowballProgram, Hashtable<String, String> hashtable) {
        super(tokenStream);
        this.stemmer = snowballProgram;
        this.rootTable = hashtable;
    }

    public FTSStemmingFilter(TokenStream tokenStream, String string) {
        super(tokenStream);
        try {
            Class<?> clazz = Class.forName("org.tartarus.snowball.ext." + string + "Stemmer");
            this.stemmer = (SnowballProgram)clazz.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " rewrite: Failed to get the " + string + " stemmer"), (Throwable)exception);
        }
    }

    public final Token next(Token token) throws IOException {
        assert (token != null);
        try {
            if (this.addStemmedTerm) {
                this.addStemmedTerm = false;
                return this.stemmedTerm;
            }
            Token token2 = this.input.next(token);
            if (token2 == null) {
                return null;
            }
            String string = token2.term();
            String string2 = null;
            if (this.rootTable.containsKey(string)) {
                string2 = this.rootTable.get(string);
            } else {
                this.stemmer.setCurrent(string);
                this.stemmer.stem();
                string2 = this.stemmer.getCurrent();
            }
            if (!string.equals(string2)) {
                token2.setTermBuffer(string2);
                Object object = token2.clone();
                this.stemmedTerm = (Token)object;
                this.stemmedTerm.setTermBuffer(string);
                this.stemmedTerm.setPositionIncrement(0);
                this.addStemmedTerm = true;
            }
            return token2;
        }
        catch (Exception exception) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSStemmingFilter: failed to get next term "), (Throwable)exception);
            }
            return null;
        }
    }
}

