/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework;

import com.bmc.thirdparty.org.aopalliance.intercept.Interceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.springframework.aop.Advisor;
import com.bmc.thirdparty.org.springframework.aop.IntroductionAdvisor;
import com.bmc.thirdparty.org.springframework.aop.IntroductionAwareMethodMatcher;
import com.bmc.thirdparty.org.springframework.aop.MethodMatcher;
import com.bmc.thirdparty.org.springframework.aop.PointcutAdvisor;
import com.bmc.thirdparty.org.springframework.aop.framework.Advised;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisedSupport;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisorChainFactory;
import com.bmc.thirdparty.org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;
import com.bmc.thirdparty.org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import com.bmc.thirdparty.org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AdvisorChainFactoryUtils {
    public static final AdvisorChainFactory SIMPLE_ADVISOR_CHAIN_FACTORY = new AdvisorChainFactory(){

        public List getInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
            return AdvisorChainFactoryUtils.calculateInterceptorsAndDynamicInterceptionAdvice(config, proxy, method, targetClass);
        }

        public void activated(AdvisedSupport advisedSupport) {
        }

        public void adviceChanged(AdvisedSupport advisedSupport) {
        }
    };

    public static List calculateInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
        ArrayList<Object> interceptorList = new ArrayList<Object>(config.getAdvisors().length);
        boolean hasIntroductions = AdvisorChainFactoryUtils.hasMatchingIntroductions(config, targetClass);
        AdvisorAdapterRegistry registry = GlobalAdvisorAdapterRegistry.getInstance();
        for (int i2 = 0; i2 < config.getAdvisors().length; ++i2) {
            IntroductionAdvisor ia;
            Interceptor[] interceptors;
            Advisor advisor = config.getAdvisors()[i2];
            if (advisor instanceof PointcutAdvisor) {
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                if (!pointcutAdvisor.getPointcut().getClassFilter().matches(targetClass)) continue;
                interceptors = registry.getInterceptors(advisor);
                MethodMatcher mm = pointcutAdvisor.getPointcut().getMethodMatcher();
                if (!AdvisorChainFactoryUtils.methodMatches(mm, method, targetClass, hasIntroductions)) continue;
                if (mm.isRuntime()) {
                    for (int j2 = 0; j2 < interceptors.length; ++j2) {
                        interceptorList.add(new InterceptorAndDynamicMethodMatcher((MethodInterceptor)interceptors[j2], mm));
                    }
                    continue;
                }
                interceptorList.addAll(Arrays.asList(interceptors));
                continue;
            }
            if (!(advisor instanceof IntroductionAdvisor) || !(ia = (IntroductionAdvisor)advisor).getClassFilter().matches(targetClass)) continue;
            interceptors = registry.getInterceptors(advisor);
            interceptorList.addAll(Arrays.asList(interceptors));
        }
        return interceptorList;
    }

    private static boolean hasMatchingIntroductions(Advised config, Class targetClass) {
        for (int i2 = 0; i2 < config.getAdvisors().length; ++i2) {
            IntroductionAdvisor ia;
            Advisor advisor = config.getAdvisors()[i2];
            if (!(advisor instanceof IntroductionAdvisor) || !(ia = (IntroductionAdvisor)advisor).getClassFilter().matches(targetClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean methodMatches(MethodMatcher matcher, Method method, Class targetClass, boolean hasIntroductions) {
        if (matcher instanceof IntroductionAwareMethodMatcher) {
            IntroductionAwareMethodMatcher introductionAwareMatcher = (IntroductionAwareMethodMatcher)matcher;
            return introductionAwareMatcher.matches(method, targetClass, hasIntroductions);
        }
        return matcher.matches(method, targetClass);
    }
}

