/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.sso;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.plugins.AREAPlugin;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.atrium.sso.common.AtriumSSOException;
import com.bmc.atrium.sso.sdk.Authentication;
import com.bmc.atrium.sso.sdk.Realms;
import com.bmc.atrium.sso.sdk.SSOPrincipal;
import com.bmc.atrium.sso.sdk.SSOServer;
import com.bmc.atrium.sso.sdk.SSOToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class AtriumSSOPlugin
extends AREAPlugin {
    private Authentication ssoContext;
    private Realms rootRealm;
    private int onEventFlag = 0;
    private boolean checkLocation = true;
    private String keyStorePasswordCopy = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.AREA.ATRIUMSSO", this);

    public void initialize(ARPluginContext aRPluginContext) throws ARException {
        Object object;
        SSOServer sSOServer;
        System.out.println("Intializing plug-in : " + aRPluginContext.getPluginInfo().getName());
        String string = aRPluginContext.getARConfigEntry("Atrium-SSO-Location");
        String string2 = aRPluginContext.getARConfigEntry("Atrium-SSO-Keystore-Path");
        String string3 = aRPluginContext.getARConfigEntry("Atrium-SSO-Keystore-Password");
        if (string == null || string.length() == 0) {
            aRPluginContext.logMessage(this.pluginInfo, 1, "Atrium SSO Server Location Is Null");
            return;
        }
        if (this.onEventFlag == 1) {
            this.checkLocation = true;
        } else {
            this.onEventFlag = 0;
        }
        try {
            if (string3 != null && (this.keyStorePasswordCopy == null || string3.compareTo(this.keyStorePasswordCopy) != 0)) {
                this.keyStorePasswordCopy = new String(string3);
                sSOServer = new PasswordReserveFieldEncryption(false);
                object = sSOServer.decryptPasswordEx(string3.getBytes());
                string3 = new String((byte[])object);
            }
        }
        catch (Exception exception) {
            aRPluginContext.logMessage(this.pluginInfo, 2, exception.toString());
            throw new ARException(2, 8753, exception.getMessage());
        }
        sSOServer = null;
        try {
            sSOServer = SSOServer.getInstance((String)string);
            this.rootRealm = sSOServer.getRealms();
            if (string2 != null) {
                try {
                    object = new FileInputStream(string2);
                    KeyStore keyStore = KeyStore.getInstance("jks");
                    char[] cArray = string3.toCharArray();
                    keyStore.load((InputStream)object, cArray);
                    sSOServer.setTrustStore(keyStore);
                }
                catch (Exception exception) {
                    aRPluginContext.logMessage(this.pluginInfo, 2, exception.toString());
                    throw new ARException(2, 8753, exception.getMessage());
                }
            } else {
                sSOServer.setAcceptAllServerCertificates(true);
            }
            aRPluginContext.logMessage(this.pluginInfo, 0, "Fetching Realms");
            this.ssoContext = sSOServer.getAuthentication();
        }
        catch (AtriumSSOException atriumSSOException) {
            aRPluginContext.logMessage(this.pluginInfo, 2, atriumSSOException.toString());
            throw new ARException(2, 8753, atriumSSOException.getMessage());
        }
        System.out.println("Intializing plugin " + aRPluginContext.getPluginInfo().getName());
    }

    public AREAResponse areaVerifyLogin(ARPluginContext aRPluginContext, String string, String string2, String string3, String string4) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "areaVerifyLogin()");
        AREAResponse aREAResponse = new AREAResponse();
        if (ARPluginSvrThreadLocalStorageBlock.getTLB().getAPIClientType() == 38) {
            aREAResponse.setLoginStatus(2);
            aRPluginContext.logMessage(this.pluginInfo, 0, "Not authenticating calls initiated by Atrium SSO Server..returning");
            return aREAResponse;
        }
        try {
            String string5;
            String string6 = null;
            if (string4 == null || string4.length() == 0) {
                aRPluginContext.logMessage(this.pluginInfo, 0, "authString is null ");
                aRPluginContext.logMessage(this.pluginInfo, 0, "User Name : " + string);
                if (string2 == null || string2.length() == 0) {
                    aRPluginContext.logMessage(this.pluginInfo, 0, "Password is null ");
                } else {
                    string6 = this.ssoContext.connect(this.rootRealm.getRootRealm(), (CallbackHandler)new SSOAuthCallbackHandler(string, string2));
                }
            } else {
                aRPluginContext.logMessage(this.pluginInfo, 0, string4);
                string6 = string4;
            }
            SSOToken sSOToken = null;
            if (string6 != null) {
                sSOToken = this.ssoContext.getToken(string6);
            }
            aREAResponse.setLoginStatus(1);
            if (sSOToken != null) {
                SSOPrincipal sSOPrincipal = sSOToken.getPrincipal();
                aREAResponse.setLoginStatus(0);
                aRPluginContext.logMessage(this.pluginInfo, 0, "Login Successful");
                aREAResponse.setLicenseWrite(1);
                string5 = null;
                for (String string7 : sSOPrincipal.getGroups()) {
                    string5 = string5 == null ? new String(string7) : string5.concat(string7);
                    string5 = string5.concat(";");
                }
            } else {
                aRPluginContext.logMessage(this.pluginInfo, 0, "Login Failed");
                StatusInfo statusInfo = null;
                statusInfo = string6 != null ? new StatusInfo(2, 1000L, "Invalid tokenId for ", string) : new StatusInfo(2, 1000L, "tokenId is null for ", string);
                ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
                arrayList.add(statusInfo);
                throw new ARException(arrayList);
            }
            aREAResponse.setGroups(string5);
            aRPluginContext.logMessage(this.pluginInfo, 0, "AREA Response Details : ");
            aRPluginContext.logMessage(this.pluginInfo, 0, "GroupList : " + aREAResponse.getGroups());
            return aREAResponse;
        }
        catch (AtriumSSOException atriumSSOException) {
            aRPluginContext.logMessage(this.pluginInfo, 2, atriumSSOException.toString());
            throw new ARException(2, 8753, atriumSSOException.getMessage());
        }
        catch (Exception exception) {
            aRPluginContext.logMessage(this.pluginInfo, 2, exception.toString());
            throw new ARException(2, 8753, exception.getMessage());
        }
    }

    public boolean areaNeedSync(ARPluginContext aRPluginContext) throws ARException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(ARPluginContext aRPluginContext, int n) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "on event called with event id " + String.valueOf(n));
        this.lock.lock();
        try {
            if (n == 10005) {
                this.onEventFlag = 1;
                this.initialize(aRPluginContext);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static class SSOAuthCallbackHandler
    implements CallbackHandler {
        private String user;
        private String password;

        public SSOAuthCallbackHandler(String string, String string2) {
            this.user = string;
            this.password = string2;
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Callback callback;
                if (callbackArray[i] instanceof NameCallback) {
                    callback = (NameCallback)callbackArray[i];
                    ((NameCallback)callback).setName(this.user);
                    continue;
                }
                if (callbackArray[i] instanceof PasswordCallback) {
                    callback = (PasswordCallback)callbackArray[i];
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
            }
        }
    }
}

