/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper.shared;

import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractConfigurationFile;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.CommentEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.ConfigurationFileListIterator;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.LineFeedEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.PropertyEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.UnicodeHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.WhitespaceEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesConfigurationFile
extends AbstractConfigurationFile {
    public static final String ISO_8859_1 = "ISO-8859-1";
    protected static final String DEFAULT_CHARSET_NAME = "ISO-8859-1";
    protected static final String DEFAULT_WHITESPACE_CHARACTERS = " \t\r\n\f";
    protected static final String DEFAULT_COMMENT_START_TOKEN = "#";
    protected static final String DEFAULT_KEY_VALUE_SEPARATORS = "=: \t\r\n\f";
    protected static final String DEFAULT_STRICT_KEY_VALUE_SEPARATORS = "=:";
    private String charsetName_ = "ISO-8859-1";
    private boolean encodeUnicode_ = false;
    private boolean allowMultipleValuesPerKey_ = false;
    private String whitespaceCharacters_ = " \t\r\n\f";
    private List<String> commentStartTokens_ = new ArrayList<String>();
    private String keyValueSeparators_;
    private String strictKeyValueSeparators_;
    private boolean useKeySeparatorSpacing_;
    private boolean useSeparatorValueSpacing_;

    public PropertiesConfigurationFile() {
        this.commentStartTokens_.add(DEFAULT_COMMENT_START_TOKEN);
        this.commentStartTokens_.add("!");
        this.keyValueSeparators_ = DEFAULT_KEY_VALUE_SEPARATORS;
        this.strictKeyValueSeparators_ = DEFAULT_STRICT_KEY_VALUE_SEPARATORS;
        this.useKeySeparatorSpacing_ = false;
        this.useSeparatorValueSpacing_ = false;
    }

    @Override
    public boolean allowsEntryType(AbstractEntry abstractEntry) {
        boolean bl = false;
        if (abstractEntry != null) {
            int n = abstractEntry.getType();
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = true;
            } else if (n == 7) {
                bl = true;
            } else if (n == 3) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void parse(File file) throws FileNotFoundException, IOException, ParseException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.parse(fileInputStream);
    }

    public void parse(InputStream inputStream) throws IOException, ParseException {
        String string;
        String string2 = this.getCharsetName();
        InputStreamReader inputStreamReader = string2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string2);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string3 = this.getWhitespaceCharacters();
        List<String> list = this.getCommentStartTokens();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() > 0) {
                int n;
                int n2 = string.length();
                for (n = 0; n < n2 && string3.indexOf(string.charAt(n)) != -1; ++n) {
                }
                if (n == n2) {
                    this.entries_.add(new WhitespaceEntry(string));
                } else {
                    Iterator<String> iterator = list.iterator();
                    String string4 = string.substring(n);
                    boolean bl = false;
                    while (!bl && iterator.hasNext()) {
                        String string5 = iterator.next();
                        if (!string4.startsWith(string5)) continue;
                        String string6 = string4.substring(string5.length());
                        this.entries_.add(new CommentEntry(string5, string6));
                        bl = true;
                    }
                    if (!bl) {
                        this.entries_.add(this.parseProperty(bufferedReader, string, n2, n));
                    }
                }
            }
            this.entries_.add(new LineFeedEntry());
        }
        bufferedReader.close();
        inputStreamReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(File file) throws FileNotFoundException, IOException {
        FTSConfFileHelper.createFile(file);
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            String string = this.getCharsetName();
            outputStreamWriter = string == null ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, string);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(this.toString());
            bufferedWriter.flush();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Throwable throwable) {}
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void addComment(String string) {
        this.addComment(null, string);
    }

    public void addComment(String string, String string2) {
        String string3 = string;
        if (string3 == null) {
            List<String> list = this.getCommentStartTokens();
            string3 = list != null && list.size() > 0 ? list.get(0) : DEFAULT_COMMENT_START_TOKEN;
        }
        this.entries_.add(new CommentEntry(string3, string2));
        this.entries_.add(new LineFeedEntry());
    }

    public void removeComment(String string) {
        if (string != null) {
            String string2 = string.trim();
            Iterator iterator = this.entries_.iterator();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                CommentEntry commentEntry;
                AbstractEntry abstractEntry = (AbstractEntry)iterator.next();
                if (abstractEntry.getType() != 1 || !(commentEntry = (CommentEntry)abstractEntry).getBody().trim().equals(string2)) continue;
                iterator.remove();
                bl = true;
                if (!iterator.hasNext() || (abstractEntry = (AbstractEntry)iterator.next()).getType() != 2) continue;
                iterator.remove();
            }
        }
    }

    public List<String> getProperties(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AbstractEntry abstractEntry : this) {
            PropertyEntry propertyEntry;
            if (abstractEntry.getType() != 3 || !(propertyEntry = (PropertyEntry)abstractEntry).getKey().equals(string)) continue;
            String string2 = propertyEntry.getValue();
            arrayList.add(string2);
        }
        return arrayList;
    }

    public String getProperty(String string) {
        String string2 = null;
        Iterator<AbstractEntry> iterator = this.iterator();
        while (iterator.hasNext() && string2 == null) {
            PropertyEntry propertyEntry;
            AbstractEntry abstractEntry = iterator.next();
            if (abstractEntry.getType() != 3 || !FTSConfFileHelper.nullableEquals((propertyEntry = (PropertyEntry)abstractEntry).getKey(), string)) continue;
            string2 = propertyEntry.getValue();
        }
        return string2;
    }

    public PropertyEntry getPropertyEntry(String string, String string2) {
        PropertyEntry propertyEntry = null;
        Iterator<AbstractEntry> iterator = this.iterator();
        while (iterator.hasNext() && propertyEntry == null) {
            PropertyEntry propertyEntry2;
            AbstractEntry abstractEntry = iterator.next();
            if (abstractEntry.getType() != 3 || !FTSConfFileHelper.nullableEquals((propertyEntry2 = (PropertyEntry)abstractEntry).getKey(), string) || !FTSConfFileHelper.nullableEquals(propertyEntry2.getValue(), string2)) continue;
            propertyEntry = propertyEntry2;
        }
        return propertyEntry;
    }

    public void addProperty(String string, String string2) {
        if (this.getAllowMultipleValuesPerKey()) {
            this.addProperty(new PropertyEntry(string, string2));
        } else {
            this.setProperty(string, string2);
        }
    }

    public void addProperty(PropertyEntry propertyEntry) {
        if (propertyEntry != null) {
            if (this.getAllowMultipleValuesPerKey()) {
                PropertyEntry propertyEntry2 = propertyEntry.clone();
                propertyEntry2.setUseKeySeparatorSpacing(this.getUseKeySeparatorSpacing());
                propertyEntry2.setUseSeparatorValueSpacing(this.getUseSeparatorValueSpacing());
                propertyEntry2.setEncodeUnicode(this.getEncodeUnicode());
                this.entries_.add(propertyEntry2);
                this.entries_.add(new LineFeedEntry());
            } else {
                this.setProperty(propertyEntry);
            }
        }
    }

    public void setProperty(String string, String string2) {
        this.setProperty(new PropertyEntry(string, string2));
    }

    public void setProperty(PropertyEntry propertyEntry) {
        if (propertyEntry != null) {
            boolean bl = false;
            String string = propertyEntry.getKey();
            String string2 = propertyEntry.getValue();
            Iterator<AbstractEntry> iterator = this.iterator();
            while (iterator.hasNext() && !bl) {
                PropertyEntry propertyEntry2;
                AbstractEntry abstractEntry = iterator.next();
                if (abstractEntry.getType() != 3 || !(propertyEntry2 = (PropertyEntry)abstractEntry).getKey().equals(string)) continue;
                propertyEntry2.setValue(string2);
                propertyEntry2.setSeparator(propertyEntry.getSeparator());
                propertyEntry2.setEncodeUnicode(this.getEncodeUnicode());
                propertyEntry2.setUseKeySeparatorSpacing(this.getUseKeySeparatorSpacing());
                propertyEntry2.setUseSeparatorValueSpacing(this.getUseSeparatorValueSpacing());
                bl = true;
            }
            if (!bl) {
                PropertyEntry propertyEntry3 = propertyEntry.clone();
                propertyEntry3.setUseKeySeparatorSpacing(this.getUseKeySeparatorSpacing());
                propertyEntry3.setUseSeparatorValueSpacing(this.getUseSeparatorValueSpacing());
                propertyEntry3.setEncodeUnicode(this.getEncodeUnicode());
                this.entries_.add(propertyEntry3);
                this.entries_.add(new LineFeedEntry());
            }
        }
    }

    public void setProperties(Properties properties) {
        String string = null;
        String string2 = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = properties.getProperty(string);
            this.setProperty(new PropertyEntry(string, string2));
        }
    }

    public void deleteProperty(PropertyEntry propertyEntry) {
        if (propertyEntry != null) {
            Iterator iterator = this.entries_.iterator();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                PropertyEntry propertyEntry2;
                AbstractEntry abstractEntry = (AbstractEntry)iterator.next();
                if (abstractEntry.getType() != 3 || !FTSConfFileHelper.nullableEquals(propertyEntry2 = (PropertyEntry)abstractEntry, propertyEntry)) continue;
                iterator.remove();
                bl = true;
                if (!iterator.hasNext() || (abstractEntry = (AbstractEntry)iterator.next()).getType() != 2) continue;
                iterator.remove();
            }
        }
    }

    public void deleteProperty(String string) {
        Iterator iterator = this.entries_.iterator();
        while (iterator.hasNext()) {
            PropertyEntry propertyEntry;
            AbstractEntry abstractEntry = (AbstractEntry)iterator.next();
            if (abstractEntry.getType() != 3 || !FTSConfFileHelper.nullableEquals((propertyEntry = (PropertyEntry)abstractEntry).getKey(), string)) continue;
            iterator.remove();
            if (!iterator.hasNext() || (abstractEntry = (AbstractEntry)iterator.next()).getType() != 2) continue;
            iterator.remove();
        }
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (AbstractEntry abstractEntry : this) {
            if (abstractEntry.getType() != 3) continue;
            PropertyEntry propertyEntry = (PropertyEntry)abstractEntry;
            properties.put(propertyEntry.getKey(), propertyEntry.getValue());
        }
        return properties;
    }

    public String getCharsetName() {
        return this.charsetName_;
    }

    public void setCharsetName(String string) {
        this.charsetName_ = string;
    }

    public boolean getEncodeUnicode() {
        return this.encodeUnicode_;
    }

    public void setEncodeUnicode(boolean bl) {
        this.encodeUnicode_ = bl;
    }

    public boolean getAllowMultipleValuesPerKey() {
        return this.allowMultipleValuesPerKey_;
    }

    public void setAllowMultipleValuesPerKey(boolean bl) {
        this.allowMultipleValuesPerKey_ = bl;
    }

    public String getWhitespaceCharacters() {
        return this.whitespaceCharacters_;
    }

    public void setWhitespaceCharacters(String string) {
        this.whitespaceCharacters_ = string;
    }

    public List<String> getCommentStartTokens() {
        if (this.commentStartTokens_ == null) {
            this.commentStartTokens_ = new ArrayList<String>();
        }
        return this.commentStartTokens_;
    }

    public void setCommentStartTokens(List<String> list) {
        this.commentStartTokens_ = list;
    }

    public void addCommentStartToken(String string) {
        this.getCommentStartTokens().add(string);
    }

    public void removeCommentStartToken(String string) {
        this.getCommentStartTokens().remove(string);
    }

    public String getStrictKeyValueSeparators() {
        return this.strictKeyValueSeparators_;
    }

    public void setStrictKeyValueSeparators(String string) {
        this.strictKeyValueSeparators_ = string;
    }

    public String getKeyValueSeparators() {
        return this.keyValueSeparators_;
    }

    public void setKeyValueSeparators(String string) {
        this.keyValueSeparators_ = string;
    }

    public boolean getUseKeySeparatorSpacing() {
        return this.useKeySeparatorSpacing_;
    }

    public void setUseKeySeparatorSpacing(boolean bl) {
        this.useKeySeparatorSpacing_ = bl;
        for (AbstractEntry abstractEntry : this) {
            if (abstractEntry.getType() != 3) continue;
            PropertyEntry propertyEntry = (PropertyEntry)abstractEntry;
            propertyEntry.setUseKeySeparatorSpacing(bl);
        }
    }

    public boolean getUseSeparatorValueSpacing() {
        return this.useSeparatorValueSpacing_;
    }

    public void setUseSeparatorValueSpacing(boolean bl) {
        this.useSeparatorValueSpacing_ = bl;
        for (AbstractEntry abstractEntry : this) {
            if (abstractEntry.getType() != 3) continue;
            PropertyEntry propertyEntry = (PropertyEntry)abstractEntry;
            propertyEntry.setUseSeparatorValueSpacing(bl);
        }
    }

    public void commentProperty(String string, String string2) {
        String string3;
        if (string2 != null && (string3 = this.getProperty(string2)) != null) {
            this.commentProperty(string, this.getPropertyEntry(string2, string3));
        }
    }

    public void commentProperty(String string, PropertyEntry propertyEntry) {
        if (propertyEntry != null) {
            List<String> list;
            String string2 = string;
            if (string2 == null) {
                list = this.getCommentStartTokens();
                string2 = list != null && list.size() > 0 ? (String)list.get(0) : DEFAULT_COMMENT_START_TOKEN;
            }
            list = this.getConfigurationFileListIterator();
            boolean bl = false;
            while (((ConfigurationFileListIterator)((Object)list)).hasNext() && !bl) {
                PropertyEntry propertyEntry2;
                AbstractEntry abstractEntry = ((ConfigurationFileListIterator)((Object)list)).next();
                if (abstractEntry.getType() != 3 || !FTSConfFileHelper.nullableEquals((propertyEntry2 = (PropertyEntry)abstractEntry).getKey(), propertyEntry.getKey()) || !FTSConfFileHelper.nullableEquals(propertyEntry2.getValue(), propertyEntry.getValue())) continue;
                ((ConfigurationFileListIterator)((Object)list)).set(new CommentEntry(string2, propertyEntry2.toString()));
                bl = true;
            }
        }
    }

    protected PropertyEntry parseProperty(BufferedReader bufferedReader, String string, int n, int n2) throws IOException {
        int n3;
        char c;
        int n4;
        String string2 = string;
        int n5 = n;
        String string3 = this.getWhitespaceCharacters();
        char c2 = '=';
        String string4 = this.getStrictKeyValueSeparators();
        while (this.continueLine(string2)) {
            String string5 = null;
            if (bufferedReader != null) {
                string5 = bufferedReader.readLine();
            }
            if (string5 == null) {
                string5 = "";
            }
            String string6 = string2.substring(0, n5 - 1);
            for (n4 = 0; n4 < string5.length() && string3.indexOf(string5.charAt(n4)) != -1; ++n4) {
            }
            string5 = string5.substring(n4, string5.length());
            string2 = new String(string6 + string5);
            n5 = string2.length();
        }
        int n6 = -1;
        int n7 = n2;
        n4 = 0;
        String string7 = this.getKeyValueSeparators();
        while (n7 < n5 && n4 == 0) {
            c = string2.charAt(n7);
            if (c == '\\') {
                ++n7;
                ++n7;
                continue;
            }
            if (string7.indexOf(c) != -1) {
                c2 = c;
                n6 = n7;
                n4 = 1;
                continue;
            }
            ++n7;
        }
        while (n7 > n2 && n7 > 0 && string3.indexOf(string2.charAt(n7 - 1)) != -1) {
            --n7;
        }
        for (n3 = n7; n3 < n5 && string3.indexOf(string2.charAt(n3)) != -1; ++n3) {
        }
        if (n3 < n5 && string4.indexOf(c = string2.charAt(n3)) != -1) {
            c2 = c;
            n6 = n3++;
        }
        while (n3 < n5 && string3.indexOf(string2.charAt(n3)) != -1) {
            ++n3;
        }
        String string8 = string2.substring(n2, n7);
        String string9 = "";
        String string10 = null;
        String string11 = null;
        if (n7 < n5) {
            string9 = string2.substring(n3, n5);
            string10 = string2.substring(n7, n6);
            string11 = string2.substring(n6 + 1, n3);
        }
        if (this.getEncodeUnicode()) {
            string8 = UnicodeHelper.decodeString(string8);
            string9 = UnicodeHelper.decodeString(string9);
        }
        return new PropertyEntry(string8, string9, c2, this.getEncodeUnicode(), this.getUseKeySeparatorSpacing(), string10, this.getUseSeparatorValueSpacing(), string11);
    }
}

