/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.serversession;

import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.serversession.ListenerSessionManager;
import org.springframework.jms.listener.serversession.ServerSessionFactory;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SimpleServerSessionFactory
implements ServerSessionFactory {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(class$org$springframework$jms$listener$serversession$SimpleServerSessionFactory == null ? (class$org$springframework$jms$listener$serversession$SimpleServerSessionFactory = SimpleServerSessionFactory.class$("org.springframework.jms.listener.serversession.SimpleServerSessionFactory")) : class$org$springframework$jms$listener$serversession$SimpleServerSessionFactory) + "-";
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor(DEFAULT_THREAD_NAME_PREFIX);
    static /* synthetic */ Class class$org$springframework$jms$listener$serversession$SimpleServerSessionFactory;

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull(taskExecutor, "taskExecutor is required");
        this.taskExecutor = taskExecutor;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public ServerSession getServerSession(ListenerSessionManager sessionManager) throws JMSException {
        return new SimpleServerSession(sessionManager);
    }

    public void close(ListenerSessionManager sessionManager) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SimpleServerSession
    implements ServerSession {
        private final ListenerSessionManager sessionManager;
        private final Session session;

        public SimpleServerSession(ListenerSessionManager sessionManager) throws JMSException {
            this.sessionManager = sessionManager;
            this.session = sessionManager.createListenerSession();
        }

        public Session getSession() {
            return this.session;
        }

        public void start() {
            SimpleServerSessionFactory.this.getTaskExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        SimpleServerSession.this.sessionManager.executeListenerSession(SimpleServerSession.this.session);
                    }
                    finally {
                        JmsUtils.closeSession(SimpleServerSession.this.session);
                    }
                }
            });
        }
    }
}

