/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StringByteUtil {
    private static Logger if = Logger.getLogger(StringByteUtil.class);
    private static Base64 a = new Base64();

    private StringByteUtil() {
    }

    public static byte[] concatenateByteArrays(byte[] byArray, byte[] byArray2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        return byteBuffer.array();
    }

    public static byte[] concatenateByteArrays(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length + byArray3.length);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        return byteBuffer.array();
    }

    public static byte[] concatenateByteArrays(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length + byArray3.length + byArray4.length);
        byteBuffer.put(byArray);
        byteBuffer.put(byArray2);
        byteBuffer.put(byArray3);
        byteBuffer.put(byArray4);
        return byteBuffer.array();
    }

    public static byte[] getByteArrays(byte[] byArray, int n, int n2) {
        int n3;
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        int n4 = n3 = byArray.length > n + n2 ? byArray.length : n + n2;
        if (if.isDebugEnabled() && n3 > 500000) {
            if.debug((Object)("getByteArrays needs capacity: " + n2));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.put(byArray);
        if (if.isDebugEnabled() && n2 > 500000) {
            if.debug((Object)("getByteArrays needs: " + n2));
        }
        byte[] byArray2 = new byte[n2];
        byteBuffer.position(n);
        byteBuffer.get(byArray2);
        byteBuffer.clear();
        byteBuffer = null;
        return byArray2;
    }

    public static byte[] getOctetKey(byte[] byArray) {
        int n = 8;
        int n2 = byArray.length > n << 1 ? byArray.length : n << 1;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.put(byArray);
        byteBuffer.position(n);
        byte[] byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        byteBuffer.clear();
        byteBuffer = null;
        return byArray2;
    }

    public static byte[] resizeByteArray(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        return StringByteUtil.getByteArrays(byArray, 0, n);
    }

    public static byte[] resizeStringToByteArray(String string, String string2, int n) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        return StringByteUtil.resizeByteArray(byArray, n);
    }

    public static byte[] stringToMaxByteArray(String string, String string2, int n) throws IllegalArgumentException, UnsupportedEncodingException {
        byte[] byArray;
        if (string == null) {
            return new byte[n];
        }
        if (string2 == null) {
            string2 = "utf-8";
        }
        if (string2.equals("EUC_JP")) {
            string = new String(string.getBytes("windows-31j"), "SJIS");
        }
        if ((byArray = string.getBytes(string2)).length > n) {
            throw new IllegalArgumentException("String is longer than the maximum allowed length, which is " + n + " bytes");
        }
        return StringByteUtil.resizeByteArray(byArray, n);
    }

    public static String createNullTerminatedString(byte[] byArray, String string) throws UnsupportedEncodingException {
        String string2 = null;
        if (string == null) {
            string = "utf-8";
        }
        int n = 0;
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        string2 = byArray.length == 0 || n < byArray.length ? new String(byArray, 0, n, string) : new String(byArray, string);
        if (string.equals("EUC_JP")) {
            string2 = new String(string2.getBytes("SJIS"), "windows-31j");
        }
        return string2;
    }

    public static byte[] generateRandomBytes(int n) {
        if (n < 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        Random random = new Random();
        random.nextBytes(byArray);
        return byArray;
    }

    public static long uLongToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int longToULong(long l) {
        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte[] hexStrToBytes(String string) throws DecoderException {
        char[] cArray = string.toCharArray();
        return StringByteUtil.hexCharToBytes(cArray);
    }

    public static byte[] hexCharToBytes(char[] cArray) throws DecoderException {
        return Hex.decodeHex((char[])cArray);
    }

    public static String bytesToHexString(byte[] byArray) {
        return StringByteUtil.bytesToHexCharArray(byArray).toString();
    }

    public static char[] bytesToHexCharArray(byte[] byArray) {
        return Hex.encodeHex((byte[])byArray);
    }

    public static byte[] base64Encode(byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        if (byArray != null) {
            byArray2 = a.encode(byArray);
        }
        return byArray2;
    }

    public static byte[] base64Decode(byte[] byArray) {
        byte[] byArray2 = new byte[]{};
        if (byArray != null) {
            byArray2 = a.decode(byArray);
        }
        return byArray2;
    }

    public static ByteBuffer expandDirectByteBufferCapacity(ByteBuffer byteBuffer, int n) {
        if (n <= byteBuffer.capacity()) {
            return byteBuffer;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
        int n2 = byteBuffer.position();
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        byteBuffer2.position(n2);
        return byteBuffer2;
    }

    public static ByteBuffer expandByteBufferCapacity(ByteBuffer byteBuffer, int n) {
        if (n <= byteBuffer.capacity()) {
            return byteBuffer;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
        int n2 = byteBuffer.position();
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        byteBuffer2.position(n2);
        return byteBuffer2;
    }

    public static ByteBuffer checkAndExpandDirectByteBufferCapacity(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.remaining() >= n) {
            return byteBuffer;
        }
        int n2 = StringByteUtil.getNewBufferCapacityForExpanding(byteBuffer.capacity(), n);
        return StringByteUtil.expandDirectByteBufferCapacity(byteBuffer, n2);
    }

    public static ByteBuffer checkAndExpandByteBufferCapacity(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.remaining() >= n) {
            return byteBuffer;
        }
        int n2 = StringByteUtil.getNewBufferCapacityForExpanding(byteBuffer.capacity(), n);
        return StringByteUtil.expandByteBufferCapacity(byteBuffer, n2);
    }

    public static int getNewBufferCapacityForExpanding(int n, int n2) {
        int n3 = n;
        if (n > 0x7FFFFF7F || n2 > 0 && 0x7FFFFF7F - Math.max(n2, 4096) < n || n2 == 0 && 2137483519 < n) {
            return n;
        }
        n3 = n2 > 0 ? (n3 += Math.max(n2, 4096)) : (n < 500000 && n < 0x3FFFFFFF ? n * 2 : (n3 += 500000));
        return n3;
    }

    public static byte[] stringToByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[string.length()] = 0;
        return byArray;
    }

    public static String[] splitString(String string, int n, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() > 0) {
            int n2 = string.length();
            if (n2 > n) {
                n2 = StringByteUtil.a(string, n - 1);
            }
            if (StringByteUtil.a(string, 0, n2)) {
                arrayList.add(string.substring(0, n2));
            } else {
                while (n2 > 0) {
                    String string3 = string.substring(0, n2);
                    byte[] byArray = null;
                    try {
                        byArray = string3.getBytes(string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
                    }
                    if (byArray != null && byArray.length <= n) {
                        arrayList.add(string3);
                        break;
                    }
                    n2 = StringByteUtil.if(string, n2);
                }
            }
            string = string.substring(n2);
        }
        return arrayList.toArray(new String[0]);
    }

    private static boolean a(String string, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if ('\u007f' >= string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static int a(String string, int n) {
        if (65535 < string.codePointAt(n)) {
            return n + 2;
        }
        return n + 1;
    }

    private static int if(String string, int n) {
        if (n < 2) {
            return n == 1 ? 0 : -1;
        }
        if (65535 < string.codePointAt(n - 2)) {
            return n - 2;
        }
        return n - 1;
    }
}

