/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.arreporting.Aggregation;
import com.bmc.arsys.arreporting.ChartType;
import com.bmc.arsys.arreporting.FieldInfo;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.ReportDelegator;
import com.bmc.arsys.arreporting.ReportParameters;
import com.bmc.arsys.arreporting.ReportStyle;
import com.bmc.arsys.arreporting.ReportType;
import com.bmc.arsys.plugins.report.FormMetadata;
import com.bmc.arsys.plugins.report.IReportForm;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDesigner
implements IReportForm {
    private String tempDir = null;
    private final ReportDelegator delegator;
    private final HashMap<String, DataType> datatypes = new HashMap();

    public ReportDesigner(ReportDelegator reportDelegator) {
        this.delegator = reportDelegator;
        this.tempDir = System.getenv("BIRT_TEMP");
        if (this.tempDir == null || this.tempDir.length() <= 0) {
            this.tempDir = System.getProperty("java.io.tmpdir");
        }
        if (!this.tempDir.endsWith(System.getProperty("file.separator"))) {
            this.tempDir = this.tempDir + System.getProperty("file.separator");
        }
        this.datatypes.put("0", DataType.NULL);
        this.datatypes.put("1", DataType.KEYWORD);
        this.datatypes.put("2", DataType.INTEGER);
        this.datatypes.put("3", DataType.REAL);
        this.datatypes.put("4", DataType.CHAR);
        this.datatypes.put("5", DataType.DIARY);
        this.datatypes.put("6", DataType.ENUM);
        this.datatypes.put("7", DataType.TIME);
        this.datatypes.put("10", DataType.DECIMAL);
        this.datatypes.put("11", DataType.ATTACHMENT);
        this.datatypes.put("12", DataType.CURRENCY);
        this.datatypes.put("13", DataType.DATE);
        this.datatypes.put("14", DataType.TIME_OF_DAY);
    }

    @Override
    public List<Entry> getListEntryWithFields(ARPluginContext aRPluginContext, ARServerUser aRServerUser, String string, List<ARVendorField> list, long l, QualifierInfo qualifierInfo, List<SortInfo> list2, List<EntryListFieldInfo> list3, int n, int n2, OutputInteger outputInteger) throws ARException {
        String string2 = null;
        String string3 = null;
        if (qualifierInfo == null) {
            throw new ARException(2, -1, "Qualification is null");
        }
        if (qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals("Report Name") || qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()).toString())) {
            string2 = qualifierInfo.getRelationalOperationInfo().getRightOperand().getValue().toString();
            if (string2 == null || string2.length() == 0) {
                throw new ARException(2, -1, "Report Name cannot be null");
            }
        } else if ((qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals("Request ID") || qualifierInfo.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(CoreFieldId.EntryId.getFieldId()).toString())) && ((string3 = qualifierInfo.getRelationalOperationInfo().getRightOperand().getValue().toString()) == null || string3.length() == 0)) {
            throw new ARException(2, -1, "Entry ID is null");
        }
        if (!(string3 != null && string3.length() != 0 || string2 != null && string2.length() != 0)) {
            throw new ARException(2, -1, "Query parameters do not have either entry id or report name ");
        }
        Entry entry = null;
        if (string3 != null) {
            aRPluginContext.logMessage(0, "getListEntryWithFields() - Qual Entry ID = " + string3);
            entry = this.delegator.getReportEntryByEntryID(aRServerUser, string3);
        } else if (string2 != null) {
            aRPluginContext.logMessage(0, "getListEntryWithFields() - Qual report name = " + string2);
            aRPluginContext.logMessage(0, "getListEntryWithFields() - after replace, report name = " + string2);
            entry = this.delegator.getReportEntry(aRServerUser, string2);
        }
        if (entry == null) {
            return null;
        }
        string3 = entry.getEntryId();
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Entry entry2 = new Entry();
        entry2.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()), new Value(this.delegator.getReportName(entry)));
        entry2.put(Integer.valueOf(1), new Value(string3));
        entry.setEntryId(string3);
        arrayList.add(entry);
        outputInteger.setValue(arrayList.size());
        aRPluginContext.logMessage(0, "nummatches  = " + outputInteger.intValue());
        return arrayList;
    }

    @Override
    public Entry getEntry(ARPluginContext aRPluginContext, ARServerUser aRServerUser, String string, List<ARVendorField> list, long l, String string2, int[] nArray) throws ARException {
        String string3;
        String string4;
        aRPluginContext.logMessage(0, "Get Entry: entryId" + string2);
        if (string2 == null || string2.length() == 0) {
            throw new ARException(2, -1, "Entry ID is null");
        }
        ReportParameters reportParameters = this.delegator.getParametersByEntryID(aRServerUser, string2);
        if (reportParameters == null) {
            throw new ARException(2, -1, "Report does not exist");
        }
        String string5 = reportParameters.getName();
        Entry entry = new Entry();
        entry.put(Integer.valueOf(1), new Value(string2));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()), new Value(string5));
        ReportStyle reportStyle = reportParameters.getStyle();
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()), new Value((Object)reportStyle.getEnumValue(), DataType.ENUM));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_FORM_NAME_ID.toInt()), new Value(reportParameters.getForm()));
        String string6 = reportParameters.getEncodedPrimaryQual();
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt()), new Value(string6.equals("1=1") ? "" : string6));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()), new Value(reportParameters.getEncodedSecondaryQual()));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()), new Value(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()))));
        String string7 = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt()));
        if (reportParameters.isIncludeList() && string7 != null && string7.length() > 0) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt()), new Value(string7));
        } else {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt()), new Value(""));
        }
        String string8 = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_SORTINFO_ID.toInt()));
        if (reportParameters.isIncludeList() && string8 != null && string8.length() > 0) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_SORTINFO_ID.toInt()), new Value(string8));
        } else {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_SORTINFO_ID.toInt()), new Value(""));
        }
        ChartType chartType = reportParameters.getChartType();
        if (reportParameters.isIncludeChart() && chartType != null) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()), new Value((Object)chartType.getEnumValue(), DataType.ENUM));
        } else {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()), new Value());
        }
        Aggregation aggregation = reportParameters.getAggregation();
        if (reportParameters.isIncludeChart() && aggregation != null) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()), new Value((Object)aggregation.getEnumValue(), DataType.ENUM));
        }
        if ((string4 = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()))) != null && string4.length() > 0 && !string4.equals("0")) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()), new Value(string4));
        }
        if ((string3 = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()))) != null && string3.length() > 0 && !string3.equals("0")) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()), new Value(string3));
        }
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()), new Value(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_TITLE_ID.toInt()), new Value(reportParameters.getTitle()));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()), new Value(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_FORM_METADATA_ID.toInt()), new Value(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_FORM_METADATA_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_FORM_VUI_ID.toInt()), new Value(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORM_VUI_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()), new Value(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()))));
        entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_DESC_ID.toInt()), new Value(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_DESC_ID.toInt()))));
        if (reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt())) != null) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()), new Value((Object)Integer.parseInt(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()))), DataType.ENUM));
        }
        if (reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt())) != null) {
            entry.put(Integer.valueOf(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt()), new Value((Object)Integer.parseInt(reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt()))), DataType.ENUM));
        }
        entry.put(Integer.valueOf(2), new Value(reportParameters.getProperties().getProperty(Integer.toString(2))));
        return entry;
    }

    private ArrayList<ARVendorField> getFormFieldInfo(VendorForm vendorForm) {
        ArrayList<ARVendorField> arrayList = new ArrayList<ARVendorField>();
        ARVendorField aRVendorField = null;
        CharacterFieldLimit characterFieldLimit = null;
        try {
            characterFieldLimit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            aRVendorField = new ARVendorField("Report Name", ReportConstants.DESIGNER_REPORT_NAME_ID.toInt(), 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("Form Name", ReportConstants.DESIGNER_FORM_NAME_ID.toInt(), 4, (FieldLimit)characterFieldLimit);
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("Report Fields", ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("Query", ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("Secondary Query", ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("SortInfo", ReportConstants.DESIGNER_SORTINFO_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            arrayList.add(aRVendorField);
            aRVendorField = new ARVendorField("FormMetadata", ReportConstants.DESIGNER_FORM_METADATA_ID.toInt(), 4, (FieldLimit)new CharacterFieldLimit(0, 2, 1, null, null, 0));
            arrayList.add(aRVendorField);
            arrayList.add(aRVendorField);
        }
        catch (Exception exception) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error fetching Columnnames for the table " + vendorForm.getTableName(), exception.getMessage())));
        }
        return arrayList;
    }

    @Override
    public List<ARVendorField> getMultipleFields(ARPluginContext aRPluginContext, ARServerUser aRServerUser, VendorForm vendorForm) throws ARException {
        return this.getFormFieldInfo(vendorForm);
    }

    private void extractFieldInfo(ARPluginContext aRPluginContext, String string, FormMetadata formMetadata, ReportParameters reportParameters) {
        ArrayList<String> arrayList;
        if (string != null && string.length() > 0) {
            reportParameters.clearFields();
        }
        if ((arrayList = ARDataStructure.processAsList(string)).size() > 1) {
            for (int i = 1; i < arrayList.size(); ++i) {
                FormMetadata.FieldData fieldData;
                int n = 0;
                String string2 = null;
                String string3 = null;
                String string4 = (String)arrayList.get(i);
                if (string4 == null || string4.length() <= 0) continue;
                HashMap<String, String> hashMap = ARDataStructure.processAsMap(string4);
                if (hashMap.size() > 0) {
                    string3 = (String)hashMap.get("id");
                    if (string3 != null && string3.length() > 0) {
                        n = Integer.parseInt(string3);
                    }
                    string2 = (String)hashMap.get("header");
                }
                if (n <= 0) continue;
                if (string2 == null) {
                    string2 = "";
                }
                String string5 = "4";
                if (formMetadata != null && (fieldData = formMetadata.getFieldData("" + n)) != null) {
                    string5 = "" + fieldData.getDataType();
                }
                aRPluginContext.logMessage(0, "ID = " + n + " Datatype = " + string5 + " Header = " + string2);
                reportParameters.addField(new FieldInfo(n, this.datatypes.get(string5), string2));
            }
        }
    }

    private void extractGroupnSortInfo(ARPluginContext aRPluginContext, String string, ReportParameters reportParameters) {
        ArrayList<String> arrayList;
        if (string != null && string.length() > 0) {
            reportParameters.clearGroups();
        }
        if ((arrayList = ARDataStructure.processAsList(string)).size() > 1) {
            for (int i = 1; i < arrayList.size(); ++i) {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = (String)arrayList.get(i);
                if (string5 == null || string5.length() <= 0) continue;
                HashMap<String, String> hashMap = ARDataStructure.processAsMap(string5);
                if (hashMap.size() > 0) {
                    string2 = (String)hashMap.get("id");
                    string3 = (String)hashMap.get("dir");
                    string4 = (String)hashMap.get("group");
                }
                if (string2 == null || string2.length() <= 0) continue;
                reportParameters.addGroup(new FieldInfo(Integer.parseInt(string2), null, string3 != null && string3.length() > 0 ? Integer.parseInt(string3) : 0, string4 != null && string4.length() > 0 ? Integer.parseInt(string4) : 0));
            }
        }
    }

    private void createOrUpdateReportParameters(ARPluginContext aRPluginContext, ARServerUser aRServerUser, List<ARVendorField> list, Entry entry, ReportParameters reportParameters, boolean bl) throws ARException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = 0;
        String string8 = null;
        int n2 = 0;
        int n3 = 0;
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "1";
        if (bl) {
            reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt()), "1=1");
            reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()), "");
        }
        block23: for (int i = 0; i < list.size(); ++i) {
            object4 = list.get(i);
            if (object4 == null || ((ARVendorField)object4).getFieldId() == 1) continue;
            object3 = ReportConstants.fromFieldId(((ARVendorField)object4).getFieldId());
            if (!entry.containsKey((Object)((ARVendorField)object4).getFieldId())) continue;
            object2 = (Value)entry.get((Object)((ARVendorField)object4).getFieldId());
            if (object3 != ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID && object3 != ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID && (object2 == null || object2.getValue() == null)) {
                aRPluginContext.logMessage(0, "Null Value for field id " + ((ARVendorField)object4).getFieldId());
                reportParameters.getProperties().setProperty(Integer.toString(((ReportConstants)((Object)object3)).toInt()), "");
                if (object3 == ReportConstants.DESIGNER_REPORT_NAME_ID || object3 == ReportConstants.DESIGNER_FORM_NAME_ID || object3 == ReportConstants.DESIGNER_REPORT_DESC_ID) continue;
            }
            if (object3 == null) continue;
            switch (1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[((Enum)object3).ordinal()]) {
                case 1: {
                    string = object2.getValue().toString();
                    reportParameters.setReportSet(string);
                    aRPluginContext.logMessage(0, "Report Name =" + string);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()), string);
                    continue block23;
                }
                case 2: {
                    string2 = object2.getValue().toString();
                    aRPluginContext.logMessage(0, "Form Name =" + string2);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_FORM_NAME_ID.toInt()), string2);
                    continue block23;
                }
                case 3: {
                    object = object2.getValue().toString();
                    aRPluginContext.logMessage(0, "Report Description =" + (String)object);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_DESC_ID.toInt()), (String)object);
                    continue block23;
                }
                case 4: {
                    if (object2 == null || object2.getValue() == null) {
                        reportParameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_REPORT_TITLE_ID.toInt()));
                        continue block23;
                    }
                    string7 = object2.getValue().toString();
                    aRPluginContext.logMessage(0, "Report Title =" + string7);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TITLE_ID.toInt()), string7);
                    continue block23;
                }
                case 5: {
                    n = object2 != null && object2.getValue() != null ? (Integer)object2.getValue() : 0;
                    aRPluginContext.logMessage(0, "Report Format =" + n);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORMAT_ID.toInt()), Integer.toString(n));
                    continue block23;
                }
                case 6: {
                    int n4;
                    int n5 = n4 = object2 != null && object2.getValue() != null ? (Integer)object2.getValue() : 0;
                    if (n4 >= 0 && n4 <= 2) {
                        reportParameters.setStyle(ReportStyle.fromInt(n4));
                    } else {
                        reportParameters.setStyle(ReportStyle.LIST);
                    }
                    aRPluginContext.logMessage(0, "Template Value =" + n4);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()), Integer.toString(n4));
                    continue block23;
                }
                case 7: {
                    int n6;
                    if (object2 != null && object2.getDataType() != DataType.NULL && object2.getValue() != null) {
                        n6 = (Integer)object2.getValue();
                        aRPluginContext.logMessage(0, "Chart Style =" + n6);
                        reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()), Integer.toString(n6));
                        continue block23;
                    }
                    reportParameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()));
                    continue block23;
                }
                case 8: {
                    int n6;
                    if (object2 != null && object2.getDataType() != DataType.NULL && object2.getValue() != null) {
                        n6 = (Integer)object2.getValue();
                        aRPluginContext.logMessage(0, "Aggregate by =" + n6);
                        reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()), Integer.toString(n6));
                        continue block23;
                    }
                    reportParameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()));
                    continue block23;
                }
                case 9: {
                    if (object2 != null && object2.getValue() != null) {
                        string3 = object2.getValue().toString();
                        if (string3 != null && string3.length() > 0) {
                            aRPluginContext.logMessage(0, "Fields =" + string3);
                            reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FIELDS_ID.toInt()), string3);
                            continue block23;
                        }
                        reportParameters.clearFields();
                        continue block23;
                    }
                    reportParameters.clearFields();
                    continue block23;
                }
                case 10: {
                    string6 = object2.getValue().toString();
                    aRPluginContext.logMessage(0, "FormMetaData =" + string6);
                    bl2 = true;
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_FORM_METADATA_ID.toInt()), string6);
                    continue block23;
                }
                case 11: {
                    String string14 = string4 = object2 != null && object2.getValue() != null ? object2.getValue().toString() : "";
                    if (string4.length() == 0) {
                        string4 = "1=1";
                    }
                    aRPluginContext.logMessage(0, "Query =" + string4);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.toInt()), string4);
                    continue block23;
                }
                case 12: {
                    string5 = object2 != null && object2.getValue() != null ? object2.getValue().toString() : "";
                    aRPluginContext.logMessage(0, "Sec Query =" + string5);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.toInt()), string5);
                    continue block23;
                }
                case 13: {
                    if (object2 != null && object2.getValue() != null) {
                        string8 = object2.getValue() != null ? object2.getValue().toString() : "";
                        aRPluginContext.logMessage(0, "Sort Info =" + string8);
                        reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_SORTINFO_ID.toInt()), string8);
                        continue block23;
                    }
                    reportParameters.clearGroups();
                    continue block23;
                }
                case 14: {
                    n2 = Integer.parseInt(object2.getValue() != null ? object2.getValue().toString() : "0");
                    aRPluginContext.logMessage(0, "Chart Series ID =" + n2);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()), Integer.toString(n2));
                    continue block23;
                }
                case 15: {
                    n3 = Integer.parseInt(object2.getValue() != null ? object2.getValue().toString() : "0");
                    aRPluginContext.logMessage(0, "Chart Series ID =" + n3);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()), Integer.toString(n3));
                    continue block23;
                }
                case 16: {
                    string9 = object2.getValue() != null ? object2.getValue().toString() : "";
                    aRPluginContext.logMessage(0, "Chart Series Label =" + string9);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()), string9);
                    continue block23;
                }
                case 17: {
                    string10 = object2.getValue() != null ? object2.getValue().toString() : "";
                    aRPluginContext.logMessage(0, "Chart Category Label =" + string10);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()), string10);
                    continue block23;
                }
                case 18: {
                    string11 = object2.getValue() != null ? object2.getValue().toString() : "";
                    aRPluginContext.logMessage(0, "VUID =" + string11);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_FORM_VUI_ID.toInt()), string11);
                    continue block23;
                }
                case 19: {
                    string12 = object2.getValue() != null ? object2.getValue().toString() : "";
                    aRPluginContext.logMessage(0, "Locale =" + string12);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()), string12);
                    continue block23;
                }
                case 20: {
                    if (object2 == null || object2.getDataType() == DataType.NULL || object2.getValue() == null) continue block23;
                    int n6 = (Integer)object2.getValue();
                    aRPluginContext.logMessage(0, "Privacy =" + n6);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt()), Integer.toString(n6));
                    continue block23;
                }
                case 21: {
                    if (object2 == null || object2.getDataType() == DataType.NULL || object2.getValue() == null) continue block23;
                    string13 = object2.getValue().toString();
                    aRPluginContext.logMessage(0, "Visible In Console =" + string13);
                    reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_VISIBLE_IN_CONSOLE.toInt()), string13);
                    continue block23;
                }
            }
        }
        FormMetadata formMetadata = null;
        if (bl2) {
            formMetadata = new FormMetadata(string6);
        } else {
            string6 = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_FORM_METADATA_ID.toInt()));
            if (string6 != null && string6.length() > 0) {
                formMetadata = new FormMetadata(string6);
            }
        }
        if (string3 != null && string3.length() > 0) {
            this.extractFieldInfo(aRPluginContext, string3, formMetadata, reportParameters);
        }
        if (formMetadata != null && string8 != null && string8.length() > 0) {
            this.extractGroupnSortInfo(aRPluginContext, string8, reportParameters);
            object4 = reportParameters.getGroups();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (FieldInfo)object3.next();
                object = formMetadata.getFieldData("" + ((FieldInfo)object2).getFieldId());
                if (object == null) continue;
                ((FieldInfo)object2).setDataType(this.datatypes.get(((FormMetadata.FieldData)object).getDataType()));
            }
        }
        if (reportParameters.getStyle() == ReportStyle.LIST) {
            this.cleanUpChartProps(reportParameters);
        }
        if (!reportParameters.isIncludeList()) {
            reportParameters.getProperties().remove((Object)ReportConstants.DESIGNER_REPORT_FIELDS_ID);
            reportParameters.getProperties().remove((Object)ReportConstants.DESIGNER_SORTINFO_ID);
            reportParameters.clearFields();
            reportParameters.clearGroups();
        }
    }

    private void cleanUpChartProps(ReportParameters reportParameters) {
        reportParameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_ID.toInt()));
        reportParameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_ID.toInt()));
        reportParameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.toInt()));
        reportParameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.toInt()));
        reportParameters.getProperties().remove(Integer.toString(ReportConstants.DESIGNER_CHART_AGGREGATE_BY.toInt()));
    }

    @Override
    public String createEntry(ARPluginContext aRPluginContext, ARServerUser aRServerUser, String string, List<ARVendorField> list, long l, Entry entry) throws ARException {
        if (this.delegator == null) {
            throw new ARException(2, -1, "Report delegator is null");
        }
        ReportParameters reportParameters = new ReportParameters();
        reportParameters.setType(ReportType.BIRT);
        String string2 = null;
        this.createOrUpdateReportParameters(aRPluginContext, aRServerUser, list, entry, reportParameters, true);
        String string3 = this.validateReportFields(reportParameters);
        if (string3 != null) {
            throw new ARException(2, -1, string3);
        }
        String string4 = this.makeValidFileName(reportParameters.getName());
        String string5 = this.tempDir + string4 + ".rptdesign";
        string2 = this.delegator.createReport(aRServerUser, ReportType.BIRT, reportParameters, string5, true);
        return string2;
    }

    @Override
    public void setEntry(ARPluginContext aRPluginContext, ARServerUser aRServerUser, String string, List<ARVendorField> list, long l, String string2, Entry entry, Timestamp timestamp) throws ARException {
        aRPluginContext.logMessage(0, "Set Entry: entryId" + string2);
        if (string2 == null || string2.length() == 0) {
            throw new ARException(2, -1, "Entry ID is null");
        }
        ReportParameters reportParameters = this.delegator.getParametersByEntryID(aRServerUser, string2);
        if (reportParameters == null) {
            throw new ARException(2, -1, "Report does not exist");
        }
        this.createOrUpdateReportParameters(aRPluginContext, aRServerUser, list, entry, reportParameters, false);
        String string3 = this.validateReportFields(reportParameters);
        if (string3 != null) {
            throw new ARException(2, -1, string3);
        }
        this.delegator.updateReport(aRServerUser, reportParameters.getName(), reportParameters);
    }

    public String makeValidFileName(String string) {
        if (string == null) {
            return "";
        }
        return string.replaceAll("(\\[|#|/|\\\\|\\:|\\*|\\?|\"|<|>|\\||\\]|\\s)+", "_");
    }

    private String validateReportFields(ReportParameters reportParameters) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = reportParameters.getName();
        if (string2 == null) {
            stringBuffer.append("Report name is required.\n");
        }
        if ((string = reportParameters.getForm()) == null) {
            stringBuffer.append("Form is required.\n");
        }
        if (reportParameters.isIncludeChart()) {
            boolean bl;
            boolean bl2 = reportParameters.getChartType() != null;
            boolean bl3 = reportParameters.getAggregation() != null;
            boolean bl4 = reportParameters.getSeriesField() > 0;
            boolean bl5 = bl = reportParameters.getCategoryField() > 0;
            if (!(bl2 && bl4 && bl && bl3)) {
                stringBuffer.append("Required chart fields are not set.\n");
            }
        }
        if (reportParameters.isIncludeList() && (reportParameters.getFields() == null || reportParameters.getFields().size() == 0)) {
            stringBuffer.append("Fields needed for table are not set.\n");
        }
        if (stringBuffer.length() != 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$bmc$arsys$arreporting$ReportConstants;

        static {
            $SwitchMap$com$bmc$arsys$arreporting$ReportConstants = new int[ReportConstants.values().length];
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_NAME_ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_FORM_NAME_ID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_DESC_ID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_TITLE_ID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_FORMAT_ID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_CHART_ID.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_CHART_AGGREGATE_BY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_FIELDS_ID.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_FORM_METADATA_ID.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_MAIN_QUERY_ID.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_SECONDARY_QUERY_ID.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_SORTINFO_ID.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_CHART_SERIES_ID.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_CHART_CATEGORY_ID.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_CHART_SERIES_LABEL_ID.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_CHART_CATEGORY_LABEL_ID.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_FORM_VUI_ID.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_LOCALE_ID.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_REPORT_PRIVACY_ID.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$bmc$arsys$arreporting$ReportConstants[ReportConstants.DESIGNER_VISIBLE_IN_CONSOLE.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

