/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.registry;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.webservices.uddiapi.Criteria;
import com.bmc.webservices.uddiapi.CriteriaArrayList;
import com.bmc.webservices.uddiapi.CriteriaFactory;
import com.bmc.webservices.uddiapi.RegistryServerInfo;
import com.bmc.webservices.uddiapi.RegistryServerInfoFactory;
import com.bmc.webservices.uddiapi.Service;
import com.bmc.webservices.uddiapi.ServiceFactory;
import com.bmc.webservices.uddiapi.UDDIRegistry;
import com.bmc.webservices.uddiapi.UDDIRegistryFactory;
import com.bmc.webservices.uddiapi.User;
import com.bmc.webservices.uddiapi.UserFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARRegistryPlugin
extends ARFilterAPIPlugin {
    private String applicationName = null;
    private String businessName = null;
    private String webService = null;
    private String description = null;
    private String webServiceVersion = null;
    private URL wsdlUrl = null;
    private URL endPointUrl = null;
    private Value publish = null;
    private String outStr = null;
    private CriteriaArrayList criteriaArrayList = new CriteriaArrayList();
    private ArrayList<Value> outValues = new ArrayList();
    private RegistryServerInfo serverInfo;
    private UDDIRegistry uddiRegistry;
    private User user;
    private ARServerUser Server;
    private String categoryName = null;
    private String categoryValue = null;
    private String registryGUID = null;
    private String catGUID = null;
    private String interfaceVersion = null;
    private String operation = null;
    private String registryLocation = null;
    private String tempRegLocation = null;
    private String registryAdminUser;
    private String registryAdminPassword;
    private String registryAdminPasswordCopy = null;
    private URL securityServiceAccessPoint;
    private URL inquiryAccessPoint;
    private URL publishingAccessPoint;
    private URL subscriptionAccessPoint;
    private int onEventFlag = 0;
    private boolean checkLocation = true;
    private ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.REGISTRY", this);
    private final ReentrantLock lock = new ReentrantLock();
    public static final int CATEGORY_NAME_FIELD_ID = 8073;
    public static final int CATEGORY_VALUE_FIELD_ID = 8074;

    public static void init(ARPluginContext aRPluginContext) {
        System.out.println("Static initialize method invoked");
        System.out.println("UserDefined value for ARRegistry " + aRPluginContext.getConfigItem("ARRegistry"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Value> filterAPICall(ARPluginContext aRPluginContext, List<Value> list) throws ARException {
        this.lock.lock();
        try {
            aRPluginContext.logMessage(this.pluginInfo, 0, "filterapiCall()");
            if (this.registryLocation == null || this.registryLocation.length() == 0) {
                aRPluginContext.logMessage(this.pluginInfo, 2, "Web Service Registry Location cannot be empty");
                throw new ARException(2, 9133, "");
            }
            if (list.size() == 0) {
                aRPluginContext.logMessage(this.pluginInfo, 2, "Incorrect number of inputs. Got " + Integer.toString(list.size()) + ". Expected 7 or 8");
                throw new ARException(2, 9134, "");
            }
            if (list.size() > 14) {
                aRPluginContext.logMessage(this.pluginInfo, 2, "Incorrect number of inputs. Got " + Integer.toString(list.size()) + ". Expected 7 or 8");
                throw new ARException(2, 9134, "");
            }
            aRPluginContext.logMessage(this.pluginInfo, 0, "applicationName : " + list.get(0).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "businessName : " + list.get(1).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "webService : " + list.get(2).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "webServiceVersion : " + list.get(3).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "description : " + list.get(4).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "wsdlUrl : " + list.get(5).toString());
            aRPluginContext.logMessage(this.pluginInfo, 0, "endPointUrl : " + list.get(6).toString());
            this.applicationName = list.get(0).toString();
            this.businessName = list.get(1).toString();
            this.webService = list.get(2).toString();
            this.webServiceVersion = list.get(3).toString();
            this.description = list.get(4).toString();
            try {
                this.wsdlUrl = new URL(list.get(5).toString());
                aRPluginContext.logMessage(this.pluginInfo, 0, "wsdlUrl : " + this.wsdlUrl.toString());
                this.endPointUrl = new URL(list.get(6).toString());
                aRPluginContext.logMessage(this.pluginInfo, 0, "endPointUrl : " + this.endPointUrl.toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new ARException(2, 9135, ": " + malformedURLException.toString());
            }
            if (list.size() >= 10) {
                this.registryGUID = list.get(8).toString();
                this.interfaceVersion = list.get(9).toString();
            } else {
                this.registryGUID = null;
            }
            if (list.size() > 11) {
                aRPluginContext.logMessage(this.pluginInfo, 0, "categoryName : " + list.get(10).toString());
                aRPluginContext.logMessage(this.pluginInfo, 0, "categoryValue : " + list.get(11).toString());
                this.operation = list.get(10).toString();
                this.categoryName = list.get(11).toString();
                this.categoryValue = list.get(12).toString();
                this.catGUID = list.get(13).toString();
            } else {
                this.operation = null;
                this.categoryName = null;
                this.categoryValue = null;
                this.catGUID = null;
            }
            if (list.size() > 7) {
                this.getMergedCriteriaList(aRPluginContext, this.registryGUID, this.categoryName, this.categoryValue, this.operation, this.catGUID);
                this.publish = list.get(7);
                Integer n = (Integer)this.publish.getValue();
                aRPluginContext.logMessage(this.pluginInfo, 0, "publish : " + n.toString());
                if (n == 0) {
                    if (this.catGUID != null || this.registryGUID != null) {
                        this.outStr = this.deregisterService(aRPluginContext);
                    }
                    this.outStr = this.registerService(aRPluginContext);
                }
                if (n == 1) {
                    this.outStr = this.deregisterService(aRPluginContext);
                }
            } else {
                aRPluginContext.logMessage(this.pluginInfo, 0, "publish : null");
                this.outStr = this.deregisterService(aRPluginContext);
            }
            this.outValues.add(0, new Value(this.outStr));
        }
        finally {
            this.lock.unlock();
        }
        return this.outValues;
    }

    @Override
    public void initialize(ARPluginContext aRPluginContext) throws ARException {
        try {
            this.tempRegLocation = aRPluginContext.getARConfigEntry("Registry-Location");
            aRPluginContext.logMessage(this.pluginInfo, 0, "tempRegLocation " + this.tempRegLocation);
            if (this.registryLocation == null && this.tempRegLocation == null || this.tempRegLocation != null && this.tempRegLocation.equals(this.registryLocation)) {
                this.checkLocation = false;
            } else {
                this.registryLocation = this.tempRegLocation;
                this.checkLocation = true;
            }
            if (this.onEventFlag == 1) {
                this.checkLocation = true;
            } else {
                this.onEventFlag = 0;
            }
            aRPluginContext.logMessage(this.pluginInfo, 0, "registry location " + this.registryLocation);
            if (this.registryLocation == null || this.registryLocation.length() == 0) {
                if (this.checkLocation) {
                    aRPluginContext.logMessage(this.pluginInfo, 1, "Null registry location");
                    return;
                }
                return;
            }
            this.registryAdminUser = aRPluginContext.getARConfigEntry("Registry-Admin-User");
            aRPluginContext.logMessage(this.pluginInfo, 0, "registry admin user " + this.registryAdminUser);
            this.registryAdminPassword = aRPluginContext.getARConfigEntry("Registry-Admin-Password");
            if (this.registryAdminPassword != null && (this.registryAdminPasswordCopy == null || this.registryAdminPassword.compareTo(this.registryAdminPasswordCopy) != 0)) {
                this.registryAdminPasswordCopy = new String(this.registryAdminPassword);
                PasswordReserveFieldEncryption passwordReserveFieldEncryption = new PasswordReserveFieldEncryption(false);
                byte[] byArray = passwordReserveFieldEncryption.decryptPasswordEx(this.registryAdminPassword.getBytes());
                this.registryAdminPassword = new String(byArray);
            }
            if (this.registryLocation.contains("/uddi")) {
                this.securityServiceAccessPoint = new URL(this.registryLocation + "/services/security");
                this.inquiryAccessPoint = new URL(this.registryLocation + "/services/inquiry");
                this.publishingAccessPoint = new URL(this.registryLocation + "/services/publication");
                this.subscriptionAccessPoint = new URL(this.registryLocation + "/services/subscription");
            } else {
                this.securityServiceAccessPoint = new URL(this.registryLocation + "/uddi/services/security");
                this.inquiryAccessPoint = new URL(this.registryLocation + "/uddi/services/inquiry");
                this.publishingAccessPoint = new URL(this.registryLocation + "/uddi/services/publication");
                this.subscriptionAccessPoint = new URL(this.registryLocation + "/uddi/services/subscription");
            }
            this.serverInfo = RegistryServerInfoFactory.newInstance((URL)this.securityServiceAccessPoint, (URL)this.inquiryAccessPoint, (URL)this.publishingAccessPoint, (URL)this.subscriptionAccessPoint);
            this.uddiRegistry = UDDIRegistryFactory.newInstance((RegistryServerInfo)this.serverInfo);
            this.user = UserFactory.newInstance((String)this.registryAdminUser, (String)this.registryAdminPassword);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ARException(2, 9134, exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ARPluginContext aRPluginContext, int n) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "on event called with event id " + String.valueOf(n));
        this.lock.lock();
        try {
            if (n == 10005) {
                this.onEventFlag = 1;
                this.initialize(aRPluginContext);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private String registerService(ARPluginContext aRPluginContext) {
        Service service = null;
        try {
            Service service2 = ServiceFactory.newInstance((String)this.webService, (String)this.businessName, (String)this.applicationName, (String)this.webServiceVersion, (String)this.interfaceVersion, (String)this.description, (URL)this.endPointUrl, (URL)this.wsdlUrl, (CriteriaArrayList)(this.criteriaArrayList.size() == 0 ? null : this.criteriaArrayList));
            service = this.uddiRegistry.publishService(this.user, service2);
            aRPluginContext.logMessage(this.pluginInfo, 0, "registerService returned " + service);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (service != null) {
            return "Registered";
        }
        return "Not Registered";
    }

    private String deregisterService(ARPluginContext aRPluginContext) {
        boolean bl = false;
        try {
            Service service = ServiceFactory.newInstance((String)this.webService, (String)this.businessName, (String)this.applicationName, (String)this.webServiceVersion);
            bl = this.uddiRegistry.deleteService(this.user, service);
            aRPluginContext.logMessage(this.pluginInfo, 0, "deregisterService returned " + bl);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (bl) {
            return "Not Registered";
        }
        return "Registered";
    }

    private List<Entry> getCategoryInfoFromServer(ARPluginContext aRPluginContext, String string) throws ARException {
        List list = null;
        List list2 = null;
        int[] nArray = new int[3];
        int n = 0;
        OutputInteger outputInteger = null;
        RelationalOperationInfo relationalOperationInfo = new RelationalOperationInfo();
        QualifierInfo qualifierInfo = new QualifierInfo(relationalOperationInfo);
        relationalOperationInfo.setOperation(1);
        relationalOperationInfo.setLeftOperand(new ArithmeticOrRelationalOperand(8082));
        relationalOperationInfo.setRightOperand(new ArithmeticOrRelationalOperand(new Value(string)));
        nArray[0] = 8073;
        nArray[1] = 8074;
        nArray[2] = 179;
        String string2 = aRPluginContext.getARConfigEntry("Server-Name");
        String string3 = aRPluginContext.getARConfigEntry("TCD-Specific-Port");
        this.Server = new ARServerUser((ARNativeAuthenticationInfo)aRPluginContext, null, string2);
        if (string3 != null) {
            n = Integer.valueOf(string3);
            this.Server.setPort(n);
        }
        list = this.Server.getListEntryObjects("AR System Web Services Category", qualifierInfo, 0, 100, list2, nArray, false, outputInteger);
        return list;
    }

    private void getMergedCriteriaList(ARPluginContext aRPluginContext, String string, String string2, String string3, String string4, String string5) throws ARException {
        Criteria criteria;
        List<Entry> list = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        String string6 = null;
        String string7 = null;
        list = this.getCategoryInfoFromServer(aRPluginContext, string);
        this.criteriaArrayList.clear();
        for (n = 0; n < list.size(); ++n) {
            string6 = ((Value)list.get(n).get((Object)8073)).getValue().toString();
            string7 = ((Value)list.get(n).get((Object)8074)).getValue().toString();
            arrayList.add(((Value)list.get(n).get((Object)179)).getValue().toString());
            criteria = CriteriaFactory.newInstance((String)string6, (String)string7);
            this.criteriaArrayList.add((Object)criteria);
        }
        if (string4 == null) {
            return;
        }
        if (string4.equalsIgnoreCase("Add")) {
            criteria = CriteriaFactory.newInstance((String)string2, (String)string3);
            this.criteriaArrayList.add((Object)criteria);
        }
        if (string4.equalsIgnoreCase("Modify")) {
            for (n = 0; n < this.criteriaArrayList.size(); ++n) {
                if (!((String)arrayList.get(n)).equals(string5)) continue;
                this.criteriaArrayList.remove(n);
                criteria = CriteriaFactory.newInstance((String)string2, (String)string3);
                this.criteriaArrayList.add((Object)criteria);
            }
        }
        if (string4.equalsIgnoreCase("Delete")) {
            for (n = 0; n < this.criteriaArrayList.size(); ++n) {
                if (!((String)arrayList.get(n)).equals(string5)) continue;
                this.criteriaArrayList.remove(n);
            }
        }
    }
}

