/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper.shared;

import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractEntryContainer;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.ConfigurationFileListIterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationFile
implements AbstractEntryContainer {
    protected List<AbstractEntry> entries_ = new ArrayList<AbstractEntry>();

    public abstract void parse(File var1) throws FileNotFoundException, IOException, ParseException;

    public void save(File file) throws FileNotFoundException, IOException {
        FTSConfFileHelper.writeStringToFile(this.toString(), file);
    }

    @Override
    public Iterator<AbstractEntry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    public List<AbstractEntry> getEntries() {
        return Collections.unmodifiableList(this.entries_);
    }

    @Override
    public void addEntry(AbstractEntry abstractEntry) {
        if (!this.allowsEntryType(abstractEntry)) {
            throw new IllegalArgumentException("Entry type not allowed");
        }
        this.entries_.add(abstractEntry);
    }

    @Override
    public void addEntry(int n, AbstractEntry abstractEntry) {
        if (!this.allowsEntryType(abstractEntry)) {
            throw new IllegalArgumentException("Entry type not allowed");
        }
        this.entries_.add(n, abstractEntry);
    }

    @Override
    public AbstractEntry getEntry(int n) {
        return this.entries_.get(n);
    }

    @Override
    public int indexOfEntry(AbstractEntry abstractEntry) {
        return this.entries_.indexOf(abstractEntry);
    }

    @Override
    public void removeEntry(AbstractEntry abstractEntry) {
        this.entries_.remove(abstractEntry);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof AbstractConfigurationFile) {
            List<AbstractEntry> list;
            AbstractConfigurationFile abstractConfigurationFile = (AbstractConfigurationFile)object;
            List<AbstractEntry> list2 = this.getEntries();
            if (FTSConfFileHelper.nullableEquals(list2, list = abstractConfigurationFile.getEntries())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (AbstractEntry abstractEntry : this) {
            stringBuffer.append(abstractEntry);
        }
        return stringBuffer.toString();
    }

    protected boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    public ConfigurationFileListIterator getConfigurationFileListIterator() {
        return new ConfigurationFileListIterator(this, this.entries_.listIterator());
    }
}

