/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.arealdap;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.plugins.arealdap.LDAPConstants;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;

public class LDAPProps
implements LDAPConstants {
    private String authHost;
    private String authPort;
    private String bindUser;
    private String bindPasswd;
    private String URL;
    private int timeout = 40;
    private String userBase;
    private String userFilter;
    private String chaseReferral;
    private boolean useSSL = false;
    private String emailAttribName;
    private String defaultEmail;
    private int useGroups;
    private String rolesAttribName;
    private String defaultRoles;
    private String notifyMechAttribName;
    private int defaultNotifyMech;
    private String licenseMaskAttribName;
    private String licenseTypeAttribName;
    private String licenseFTSAttribName;
    private String licenseRes1AttribName;
    private String licenseAppAttribName;
    private String groupBase;
    private String groupFilter;
    private String defaultGroups;

    public void init(ARPluginContext aRPluginContext) {
        this.setAuthHost(aRPluginContext.getARConfigEntry("AREA-LDAP-Hostname"));
        this.setAuthPort(aRPluginContext.getARConfigEntry("AREA-LDAP-Port"));
        this.setBindUser(aRPluginContext.getARConfigEntry("AREA-LDAP-Bind-User"));
        this.setBindPasswd(aRPluginContext.getARConfigEntry("AREA-LDAP-Bind-Password"));
        this.setTimeout(aRPluginContext.getARConfigEntry("AREA-LDAP-Connect-Timeout"));
        this.setURL("ldap://" + this.getAuthHost() + ":" + this.getAuthPort() + "/");
        this.setUserBase(aRPluginContext.getARConfigEntry("AREA-LDAP-User-Base"));
        this.setUserFilter(aRPluginContext.getARConfigEntry("AREA-LDAP-User-Filter"));
        this.setChaseReferral(aRPluginContext.getARConfigEntry("AREA-LDAP-Chase-Referral"));
        this.setUseSSL(aRPluginContext.getARConfigEntry("AREA-LDAP-UseSSL"));
        this.setEmailAttribName(aRPluginContext.getARConfigEntry("AREA-LDAP-Email"));
        this.setDefaultEmail(aRPluginContext.getARConfigEntry("AREA-LDAP-Email-Default"));
        this.setUseGroups(aRPluginContext.getARConfigEntry("AREA-LDAP-Use-Groups"));
        this.setRolesAttribName(aRPluginContext.getARConfigEntry("AREA-LDAP-Roles"));
        this.setDefaultRoles(aRPluginContext.getARConfigEntry("AREA-LDAP-Roles-Default"));
        this.setNotifyMeth(aRPluginContext.getARConfigEntry("AREA-LDAP-Notify-Meth"));
        this.setDefaultNotifyMech(aRPluginContext.getARConfigEntry("AREA-LDAP-Notify-Meth-Default"));
        this.setLicenseMaskAttribName(aRPluginContext.getARConfigEntry("AREA-LDAP-LicMask"));
        this.setLicenseTypeAttribName(aRPluginContext.getARConfigEntry("AREA-LDAP-Lic"));
        this.setLicenseFTSAttribName(aRPluginContext.getARConfigEntry("AREA-LDAP-LicFTS"));
        this.setLicenseRes1AttribName(aRPluginContext.getARConfigEntry("AREA-LDAP-LicRes1"));
        this.setLicenseAppAttribName(aRPluginContext.getARConfigEntry("AREA-LDAP-LicAPP"));
        this.setGroupBase(aRPluginContext.getARConfigEntry("AREA-LDAP-Group-Base"));
        this.setGroupFilter(aRPluginContext.getARConfigEntry("AREA-LDAP-Group-Filter"));
        this.setDefaultGroups(aRPluginContext.getARConfigEntry("AREA-LDAP-Group-Default"));
    }

    public void setAuthHost(String string) {
        this.authHost = string;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    public void setAuthPort(String string) {
        this.authPort = string;
    }

    public String getAuthPort() {
        return this.authPort;
    }

    public void setBindUser(String string) {
        this.bindUser = string;
    }

    public String getBindUser() {
        return this.bindUser;
    }

    public void setBindPasswd(String string) {
        PasswordReserveFieldEncryption passwordReserveFieldEncryption = new PasswordReserveFieldEncryption(false);
        byte[] byArray = null;
        try {
            byArray = passwordReserveFieldEncryption.decryptPasswordEx(string.getBytes());
        }
        catch (AREncryptionException aREncryptionException) {
            aREncryptionException.printStackTrace();
        }
        this.bindPasswd = new String(byArray);
    }

    public String getBindPasswd() {
        return this.bindPasswd;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public String getURL() {
        return this.URL;
    }

    public void setTimeout(String string) {
        try {
            this.timeout = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setUserBase(String string) {
        this.userBase = string;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserFilter(String string) {
        this.userFilter = string;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setChaseReferral(String string) {
        this.chaseReferral = string;
    }

    public String getChaseReferral() {
        return this.chaseReferral;
    }

    public void setUseSSL(String string) {
        if ("T".equalsIgnoreCase(string)) {
            this.useSSL = true;
        }
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setEmailAttribName(String string) {
        this.emailAttribName = string;
    }

    public String getEmailAttribName() {
        return this.emailAttribName;
    }

    public void setUseGroups(String string) {
        try {
            this.useGroups = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getUseGroups() {
        return this.useGroups;
    }

    public void setRolesAttribName(String string) {
        this.rolesAttribName = string;
    }

    public String getRolesAttribName() {
        return this.rolesAttribName;
    }

    public void setNotifyMeth(String string) {
        this.notifyMechAttribName = string;
    }

    public String getNotifyMeth() {
        return this.notifyMechAttribName;
    }

    public void setLicenseMaskAttribName(String string) {
        this.licenseMaskAttribName = string;
    }

    public String getLicenseMaskAttribName() {
        return this.licenseMaskAttribName;
    }

    public void setLicenseTypeAttribName(String string) {
        this.licenseTypeAttribName = string;
    }

    public String getLicenseTypeAttribName() {
        return this.licenseTypeAttribName;
    }

    public void setDefaultEmail(String string) {
        this.defaultEmail = string;
    }

    public String getDefaultEmail() {
        return this.defaultEmail;
    }

    public void setDefaultNotifyMech(String string) {
        try {
            this.defaultNotifyMech = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.defaultNotifyMech = 0;
        }
    }

    public int getDefaultNotifyMech() {
        return this.defaultNotifyMech;
    }

    public void setDefaultRoles(String string) {
        this.defaultRoles = string;
    }

    public String getDefaultRoles() {
        return this.defaultRoles;
    }

    public void setLicenseFTSAttribName(String string) {
        this.licenseFTSAttribName = string;
    }

    public String getLicenseFTSAttribName() {
        return this.licenseFTSAttribName;
    }

    public void setLicenseRes1AttribName(String string) {
        this.licenseRes1AttribName = string;
    }

    public String getLicenseRes1AttribName() {
        return this.licenseRes1AttribName;
    }

    public void setLicenseAppAttribName(String string) {
        this.licenseAppAttribName = string;
    }

    public String getLicenseAppAttribName() {
        return this.licenseAppAttribName;
    }

    public void setGroupBase(String string) {
        this.groupBase = string;
    }

    public String getGroupBase() {
        return this.groupBase;
    }

    public void setGroupFilter(String string) {
        this.groupFilter = string;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public void setDefaultGroups(String string) {
        this.defaultGroups = string;
    }

    public String getDefaultGroups() {
        return this.defaultGroups;
    }
}

