/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.ejb.access;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.ejb.access.AbstractSlsbInvokerInterceptor;
import com.bmc.thirdparty.org.springframework.remoting.RemoteConnectFailureException;
import com.bmc.thirdparty.org.springframework.remoting.RemoteLookupFailureException;
import com.bmc.thirdparty.org.springframework.remoting.rmi.RmiClientInterceptorUtils;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public abstract class AbstractRemoteSlsbInvokerInterceptor
extends AbstractSlsbInvokerInterceptor {
    private Class homeInterface;
    private boolean refreshHomeOnConnectFailure = false;

    public void setHomeInterface(Class homeInterface) {
        if (homeInterface != null && !homeInterface.isInterface()) {
            throw new IllegalArgumentException("Home interface class [" + homeInterface.getClass() + "] is not an interface");
        }
        this.homeInterface = homeInterface;
    }

    public void setRefreshHomeOnConnectFailure(boolean refreshHomeOnConnectFailure) {
        this.refreshHomeOnConnectFailure = refreshHomeOnConnectFailure;
    }

    protected boolean isHomeRefreshable() {
        return this.refreshHomeOnConnectFailure;
    }

    protected Object lookup() throws NamingException {
        Object homeObject = super.lookup();
        if (this.homeInterface != null) {
            try {
                homeObject = PortableRemoteObject.narrow((Object)homeObject, (Class)this.homeInterface);
            }
            catch (ClassCastException ex) {
                throw new RemoteLookupFailureException("Could not narrow EJB home stub to home interface [" + this.homeInterface.getName() + "]", ex);
            }
        }
        return homeObject;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.doInvoke(invocation);
        }
        catch (RemoteConnectFailureException ex) {
            return this.handleRemoteConnectFailure(invocation, ex);
        }
        catch (RemoteException ex) {
            if (this.isConnectFailure(ex)) {
                return this.handleRemoteConnectFailure(invocation, ex);
            }
            throw ex;
        }
    }

    protected boolean isConnectFailure(RemoteException ex) {
        return RmiClientInterceptorUtils.isConnectFailure(ex);
    }

    private Object handleRemoteConnectFailure(MethodInvocation invocation, Exception ex) throws Throwable {
        if (this.refreshHomeOnConnectFailure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not connect to remote EJB [" + this.getJndiName() + "] - retrying", ex);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not connect to remote EJB [" + this.getJndiName() + "] - retrying");
            }
            return this.refreshAndRetry(invocation);
        }
        throw ex;
    }

    protected Object refreshAndRetry(MethodInvocation invocation) throws Throwable {
        try {
            this.refreshHome();
        }
        catch (NamingException ex) {
            throw new RemoteLookupFailureException("Failed to locate remote EJB [" + this.getJndiName() + "]", ex);
        }
        return this.doInvoke(invocation);
    }

    protected abstract Object doInvoke(MethodInvocation var1) throws Throwable;

    protected EJBObject newSessionBeanInstance() throws NamingException, InvocationTargetException {
        Object ejbInstance;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Trying to create reference to remote EJB");
        }
        if (!((ejbInstance = this.create()) instanceof EJBObject)) {
            throw new RemoteLookupFailureException("EJB instance [" + ejbInstance + "] is not a Remote Stateless Session Bean");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Obtained reference to remote EJB: " + ejbInstance);
        }
        return (EJBObject)ejbInstance;
    }

    protected void removeSessionBeanInstance(EJBObject ejb) {
        if (ejb != null) {
            try {
                ejb.remove();
            }
            catch (Throwable ex) {
                this.logger.warn("Could not invoke 'remove' on remote EJB proxy", ex);
            }
        }
    }
}

