/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.view.freemarker;

import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.context.ResourceLoaderAware;
import com.bmc.thirdparty.org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import com.bmc.thirdparty.org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import freemarker.cache.ClassTemplateLoader;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;

public class FreeMarkerConfigurer
extends FreeMarkerConfigurationFactory
implements FreeMarkerConfig,
InitializingBean,
ResourceLoaderAware,
ServletContextAware {
    private Configuration configuration;
    private TaglibFactory taglibFactory;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setServletContext(ServletContext servletContext) {
        this.taglibFactory = new TaglibFactory(servletContext);
    }

    public void afterPropertiesSet() throws IOException, TemplateException {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
    }

    protected void postProcessTemplateLoaders(List templateLoaders) {
        templateLoaders.add(new ClassTemplateLoader(this.getClass()));
        this.logger.info("ClassTemplateLoader for Spring macros added to FreeMarker configuration");
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TaglibFactory getTaglibFactory() {
        return this.taglibFactory;
    }
}

