/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scheduling.timer;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.scheduling.timer.ScheduledTimerTask;
import java.util.Timer;

public class TimerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ScheduledTimerTask[] scheduledTimerTasks;
    private boolean daemon = false;
    private Timer timer;
    static /* synthetic */ Class class$java$util$Timer;

    public void setScheduledTimerTasks(ScheduledTimerTask[] scheduledTimerTasks) {
        this.scheduledTimerTasks = scheduledTimerTasks;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void afterPropertiesSet() {
        this.logger.info("Initializing Timer");
        this.timer = this.createTimer(this.daemon);
        if (this.scheduledTimerTasks != null) {
            for (int i2 = 0; i2 < this.scheduledTimerTasks.length; ++i2) {
                ScheduledTimerTask scheduledTask = this.scheduledTimerTasks[i2];
                if (scheduledTask.getPeriod() > 0L) {
                    if (scheduledTask.isFixedRate()) {
                        this.timer.scheduleAtFixedRate(scheduledTask.getTimerTask(), scheduledTask.getDelay(), scheduledTask.getPeriod());
                        continue;
                    }
                    this.timer.schedule(scheduledTask.getTimerTask(), scheduledTask.getDelay(), scheduledTask.getPeriod());
                    continue;
                }
                this.timer.schedule(scheduledTask.getTimerTask(), scheduledTask.getDelay());
            }
        }
    }

    protected Timer createTimer(boolean daemon) {
        return new Timer(daemon);
    }

    public Object getObject() {
        return this.timer;
    }

    public Class getObjectType() {
        return class$java$util$Timer == null ? (class$java$util$Timer = TimerFactoryBean.class$("java.util.Timer")) : class$java$util$Timer;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info("Cancelling Timer");
        this.timer.cancel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

