/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.beanutils.converters;

import com.bmc.thirdparty.org.apache.commons.beanutils.ConversionException;
import com.bmc.thirdparty.org.apache.commons.beanutils.Converter;

public final class ByteConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public ByteConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public ByteConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Byte) {
            return value;
        }
        if (value instanceof Number) {
            return new Byte(((Number)value).byteValue());
        }
        try {
            return new Byte(value.toString());
        }
        catch (Exception e2) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e2);
        }
    }
}

