/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.arrpc.nio.ArEncryptionInfoI;
import com.bmc.arsys.arrpc.nio.ArNioXdrTcpEncodingStream;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.arthreadlocal.ARThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.apache.log4j.Logger;

public class ARPluginSvrXdrTcpEncodingStream
extends ArNioXdrTcpEncodingStream {
    private static Logger log = Logger.getLogger(ARPluginSvrXdrTcpEncodingStream.class);
    private ArEncryptionContext mConnection;
    private ArEncryptionInfoI mEncryptionInfo;

    public ARPluginSvrXdrTcpEncodingStream(ArEncryptionContext arEncryptionContext, SocketChannel socketChannel, int n) throws IOException {
        super(socketChannel, n);
        this.mConnection = arEncryptionContext;
        try {
            this.mEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
        }
        catch (ARException aRException) {
            this.mEncryptionInfo = null;
        }
    }

    public byte[] arEncAfterXdrEncoding(byte[] byArray) throws OncRpcException, IOException {
        byte[] byArray2 = null;
        if (this.isDataEncrypted()) {
            this.setArEncryptionOn(true);
            this.setArProcessOn(true);
            try {
                int n = this.mConnection.getCurrentSessionId();
                XdrAble xdrAble = this.mEncryptionInfo.encryptAndXdrData(n, byArray);
                this.arEncodeEncryptedData(xdrAble, (ArXdrTcpEncodingStream)this);
            }
            catch (OncRpcException oncRpcException) {
                log.error((Object)"Encryption of output failed", (Throwable)oncRpcException);
                throw oncRpcException;
            }
        } else {
            this.setArEncryptionOn(false);
            this.setArProcessOn(false);
            byArray2 = byArray;
        }
        return byArray2;
    }

    protected boolean isDataEncrypted() {
        boolean bl = false;
        if (this.mConnection != null && this.mConnection.isCurrentCallEncrypted()) {
            bl = true;
        }
        return bl;
    }

    protected void holdStreamFlush() {
        super.holdStreamFlush();
    }

    public void beginEncoding(InetAddress inetAddress, int n) throws OncRpcException, IOException {
        String string = ARThreadLocalStorageBlock.getTLB().getRemoteHostCharSet();
        this.setCharacterEncoding(string);
        if (log.isTraceEnabled()) {
            String string2 = ARThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
            log.trace((Object)("+++++++++++++++++ set " + string2 + " encoding " + string));
        }
        super.beginEncoding(inetAddress, n);
    }
}

