/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import java.text.BreakIterator;
import java.util.Iterator;

public class WordIterator
implements Iterator {
    private BreakIterator iter = BreakIterator.getWordInstance();
    private String text;
    private int start;
    private int end;
    private int nextStart;
    private int nextEnd;
    private boolean hasNext = false;

    public WordIterator(String string) {
        this.iter.setText(string);
        this.text = string;
        this.nextStart = this.iter.first();
        this.nextEnd = this.iter.next();
        boolean bl = false;
        while (this.nextEnd != -1) {
            for (int i = this.nextStart; i < this.nextEnd; ++i) {
                char c = string.charAt(i);
                if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
                bl = true;
                break;
            }
            if (bl) break;
            this.nextStart = this.nextEnd;
            this.nextEnd = this.iter.next();
        }
        this.hasNext = this.nextEnd != -1;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() {
        this.start = this.nextStart;
        this.end = this.nextEnd;
        this.nextStart = this.nextEnd;
        this.nextEnd = this.iter.next();
        boolean bl = false;
        while (this.nextEnd != -1) {
            for (int i = this.nextStart; i < this.nextEnd; ++i) {
                char c = this.text.charAt(i);
                if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
                bl = true;
                break;
            }
            if (bl) break;
            this.nextStart = this.nextEnd;
            this.nextEnd = this.iter.next();
        }
        this.hasNext = this.nextEnd != -1;
        return null;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getWord() {
        return this.text.substring(this.start, this.end);
    }
}

