/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.springframework.scheduling.SchedulingTaskExecutor;

public class ConcurrentTaskExecutor
implements SchedulingTaskExecutor,
Executor {
    private Executor concurrentExecutor;

    public ConcurrentTaskExecutor() {
        this.setConcurrentExecutor(null);
    }

    public ConcurrentTaskExecutor(Executor concurrentExecutor) {
        this.setConcurrentExecutor(concurrentExecutor);
    }

    public void setConcurrentExecutor(Executor concurrentExecutor) {
        this.concurrentExecutor = concurrentExecutor != null ? concurrentExecutor : Executors.newSingleThreadExecutor();
    }

    public void execute(Runnable task) {
        this.concurrentExecutor.execute(task);
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }
}

