/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.core.support;

import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.dao.EmptyResultDataAccessException;
import com.bmc.thirdparty.org.springframework.dao.IncorrectResultSizeDataAccessException;
import com.bmc.thirdparty.org.springframework.jdbc.LobRetrievalFailureException;
import com.bmc.thirdparty.org.springframework.jdbc.core.ResultSetExtractor;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractLobStreamingResultSetExtractor
implements ResultSetExtractor {
    public final Object extractData(ResultSet rs) throws SQLException, DataAccessException {
        if (!rs.next()) {
            this.handleNoRowFound();
        } else {
            try {
                this.streamData(rs);
                if (rs.next()) {
                    this.handleMultipleRowsFound();
                }
            }
            catch (IOException ex) {
                throw new LobRetrievalFailureException("Couldn't stream LOB content", ex);
            }
        }
        return null;
    }

    protected void handleNoRowFound() throws DataAccessException {
        throw new EmptyResultDataAccessException("LobStreamingResultSetExtractor did not find row in database", 1);
    }

    protected void handleMultipleRowsFound() throws DataAccessException {
        throw new IncorrectResultSizeDataAccessException("LobStreamingResultSetExtractor found multiple rows in database", 1);
    }

    protected abstract void streamData(ResultSet var1) throws SQLException, IOException, DataAccessException;
}

