/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.style;

import com.bmc.thirdparty.org.springframework.core.ReflectiveVisitorHelper;
import com.bmc.thirdparty.org.springframework.core.style.ValueStyler;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[empty]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String ARRAY = "array";
    private final ReflectiveVisitorHelper reflectiveVisitorHelper = new ReflectiveVisitorHelper();

    public String style(Object value) {
        return (String)this.reflectiveVisitorHelper.invokeVisit(this, value);
    }

    String visit(String value) {
        return '\'' + value + '\'';
    }

    String visit(Number value) {
        return String.valueOf(value);
    }

    String visit(Class clazz) {
        return ClassUtils.getShortName(clazz);
    }

    String visit(Method method) {
        return method.getName() + "@" + ClassUtils.getShortName(method.getDeclaringClass());
    }

    String visit(Map value) {
        StringBuffer buffer = new StringBuffer(value.size() * 8 + 16);
        buffer.append("map[");
        Iterator i2 = value.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry = i2.next();
            buffer.append(this.style(entry));
            if (!i2.hasNext()) continue;
            buffer.append(',').append(' ');
        }
        if (value.isEmpty()) {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }

    String visit(Map.Entry value) {
        return this.style(value.getKey()) + " -> " + this.style(value.getValue());
    }

    String visit(Collection value) {
        StringBuffer buffer = new StringBuffer(value.size() * 8 + 16);
        buffer.append(this.getCollectionTypeString(value) + "[");
        Iterator i2 = value.iterator();
        while (i2.hasNext()) {
            buffer.append(this.style(i2.next()));
            if (!i2.hasNext()) continue;
            buffer.append(',').append(' ');
        }
        if (value.isEmpty()) {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String getCollectionTypeString(Collection value) {
        if (value instanceof List) {
            return LIST;
        }
        if (value instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }

    String visit(Object value) {
        if (value.getClass().isArray()) {
            return this.styleArray(this.getObjectArray(value));
        }
        return String.valueOf(value);
    }

    String visitNull() {
        return NULL;
    }

    private String styleArray(Object[] array) {
        StringBuffer buffer = new StringBuffer(array.length * 8 + 16);
        buffer.append("array<" + ClassUtils.getShortName(array.getClass().getComponentType()) + ">[");
        for (int i2 = 0; i2 < array.length - 1; ++i2) {
            buffer.append(this.style(array[i2]));
            buffer.append(',').append(' ');
        }
        if (array.length > 0) {
            buffer.append(this.style(array[array.length - 1]));
        } else {
            buffer.append(EMPTY);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private Object[] getObjectArray(Object value) {
        if (value.getClass().getComponentType().isPrimitive()) {
            return ObjectUtils.toObjectArray(value);
        }
        return (Object[])value;
    }
}

