/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.support;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.factory.support.RootBeanDefinition;
import com.bmc.thirdparty.org.springframework.context.ApplicationContext;
import com.bmc.thirdparty.org.springframework.context.support.GenericApplicationContext;
import com.bmc.thirdparty.org.springframework.context.support.StaticMessageSource;
import java.util.Locale;

public class StaticApplicationContext
extends GenericApplicationContext {
    private final StaticMessageSource staticMessageSource = new StaticMessageSource();

    public StaticApplicationContext() throws BeansException {
        this((ApplicationContext)null);
    }

    public StaticApplicationContext(ApplicationContext parent) throws BeansException {
        super(parent);
        this.getBeanFactory().registerSingleton("messageSource", this.staticMessageSource);
    }

    public StaticMessageSource getStaticMessageSource() {
        return this.staticMessageSource;
    }

    public void registerSingleton(String name, Class clazz) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, new RootBeanDefinition(clazz));
    }

    public void registerSingleton(String name, Class clazz, MutablePropertyValues pvs) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, new RootBeanDefinition(clazz, pvs));
    }

    public void registerPrototype(String name, Class clazz) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, new RootBeanDefinition(clazz, false));
    }

    public void registerPrototype(String name, Class clazz, MutablePropertyValues pvs) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, new RootBeanDefinition(clazz, pvs, false));
    }

    public void addMessage(String code, Locale locale, String defaultMessage) {
        this.getStaticMessageSource().addMessage(code, locale, defaultMessage);
    }
}

