/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.RunProcessAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DSOAction
extends RunProcessAction {
    public static final int DSOACTION_TYPE_TRANSFER = 0;
    public static final int DSOACTION_TYPE_RETURN = 1;
    public static final int DSOACTION_TYPE_DELETE = 2;
    public static final String DSOACTION_CMD_TRANSFER = "Distributed-Transfer";
    public static final String DSOACTION_CMD_RETURN = "Distributed-Return";
    public static final String DSOACTION_CMD_DELETE = "Distributed-Delete";
    private static final long serialVersionUID = 26429601219023574L;
    private int type;
    private String server;
    private String form;
    private String dsoMapping;
    private String dsoPool;
    private boolean overrideLoopDetection;
    private String field;

    public DSOAction() {
        this.type = 0;
        this.dsoMapping = "";
        this.dsoPool = "";
        this.server = "";
        this.form = "";
        this.overrideLoopDetection = false;
    }

    public DSOAction(String string) {
        super(string);
        this.setCommandLine(string);
    }

    private String[] a(String[] stringArray, String string) {
        Pattern pattern = Pattern.compile("[-][a-z]([ ]*(\"[^\"]+\"))?");
        Matcher matcher = pattern.matcher(string);
        String[] stringArray2 = new String[stringArray.length];
        block0: while (matcher.find()) {
            String string2 = matcher.group().trim();
            int n2 = 0;
            for (String string3 : stringArray) {
                if (string2.indexOf(string3) == 0) {
                    String string4 = string2.substring(string3.length()).trim();
                    if (string4.length() > 0 && string4.charAt(0) == '\"') {
                        string4 = string4.substring(1);
                    }
                    if (string4.length() > 0 && string4.charAt(string4.length() - 1) == '\"') {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    stringArray2[n2] = string4;
                    continue block0;
                }
                ++n2;
            }
        }
        return stringArray2;
    }

    public void setCommandLine(String string) {
        super.setCommandLine(string);
        String[] stringArray = null;
        if (string.indexOf(DSOACTION_CMD_TRANSFER) == 0) {
            this.type = 0;
            stringArray = this.a(new String[]{"-m", "-s", "-x", "-p", "-o"}, string);
            this.dsoMapping = stringArray[0] == null ? "" : stringArray[0];
            this.form = stringArray[1] == null ? "" : stringArray[1];
            this.server = stringArray[2] == null ? "" : stringArray[2];
            this.dsoPool = stringArray[3] == null ? "" : stringArray[3];
            this.overrideLoopDetection = stringArray[4] != null;
        } else if (string.indexOf(DSOACTION_CMD_DELETE) == 0) {
            this.type = 2;
            stringArray = this.a(new String[]{"-e", "-s", "-x", "-p"}, string);
            this.field = stringArray[0] == null ? "" : stringArray[0];
            this.form = stringArray[1] == null ? "" : stringArray[1];
            this.server = stringArray[2] == null ? "" : stringArray[2];
            this.dsoPool = stringArray[3] == null ? "" : stringArray[3];
        } else if (string.indexOf(DSOACTION_CMD_RETURN) == 0) {
            this.type = 1;
            stringArray = this.a(new String[]{"-p", "-o"}, string);
            this.dsoPool = stringArray[0] == null ? "" : stringArray[0];
            this.overrideLoopDetection = stringArray[1] != null;
        } else {
            throw new IllegalArgumentException("Specified command is not associated with a valid DSO action process.");
        }
    }

    protected void updateCommandLine() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case 0: {
                stringBuilder.append(DSOACTION_CMD_TRANSFER);
                if (this.dsoMapping != null && !"".equals(this.dsoMapping)) {
                    stringBuilder.append(" -m \"");
                    stringBuilder.append(this.dsoMapping);
                    stringBuilder.append("\"");
                }
                if (this.form != null && !"".equals(this.form)) {
                    stringBuilder.append(" -s \"");
                    stringBuilder.append(this.form);
                    stringBuilder.append("\"");
                }
                if (this.server != null && !"".equals(this.server)) {
                    stringBuilder.append(" -x \"");
                    stringBuilder.append(this.server);
                    stringBuilder.append("\"");
                }
                if (this.dsoPool != null && !"".equals(this.dsoPool)) {
                    stringBuilder.append(" -p \"");
                    stringBuilder.append(this.dsoPool);
                    stringBuilder.append("\"");
                }
                if (!this.overrideLoopDetection) break;
                stringBuilder.append(" -o");
                break;
            }
            case 2: {
                stringBuilder.append(DSOACTION_CMD_DELETE);
                if (this.field != null && !"".equals(this.field)) {
                    stringBuilder.append(" -e \"");
                    stringBuilder.append(this.field);
                    stringBuilder.append("\"");
                }
                if (this.form != null && !"".equals(this.form)) {
                    stringBuilder.append(" -s \"");
                    stringBuilder.append(this.form);
                    stringBuilder.append("\"");
                }
                if (this.server != null && !"".equals(this.server)) {
                    stringBuilder.append(" -x \"");
                    stringBuilder.append(this.server);
                    stringBuilder.append("\"");
                }
                if (this.dsoPool == null || "".equals(this.dsoPool)) break;
                stringBuilder.append(" -p \"");
                stringBuilder.append(this.dsoPool);
                stringBuilder.append("\"");
                break;
            }
            case 1: {
                stringBuilder.append(DSOACTION_CMD_RETURN);
                if (this.dsoPool != null && !"".equals(this.dsoPool)) {
                    stringBuilder.append(" -p \"");
                    stringBuilder.append(this.dsoPool);
                    stringBuilder.append("\"");
                }
                if (!this.overrideLoopDetection) break;
                stringBuilder.append(" -o");
            }
        }
        super.setCommandLine(stringBuilder.toString());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n2) {
        this.type = n2;
        this.updateCommandLine();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
        this.updateCommandLine();
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String string) {
        this.form = string;
        this.updateCommandLine();
    }

    public String getDSOMapping() {
        return this.dsoMapping;
    }

    public void setDSOMapping(String string) {
        this.dsoMapping = string;
        this.updateCommandLine();
    }

    public boolean isOverrideLoopDetection() {
        return this.overrideLoopDetection;
    }

    public void setOverrideLoopDetection(boolean bl) {
        this.overrideLoopDetection = bl;
        this.updateCommandLine();
    }

    public String getDSOPool() {
        return this.dsoPool;
    }

    public void setDSOPool(String string) {
        this.dsoPool = string;
        this.updateCommandLine();
    }

    public String getField() {
        return this.field;
    }

    public void setField(String string) {
        this.field = string;
        this.updateCommandLine();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSOAction)) {
            return false;
        }
        return super.equals(object);
    }
}

