/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemData;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.RelatedType;
import com.bmc.arsys.apiext.definition.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefinitionOptions {
    private static Logger h = Logger.getLogger((String)"com.bmc.arsys.api.definition");
    private ARServerUser w;
    private String g = "";
    private String k = "";
    private String o = "";
    private String c = "";
    private int new = 0;
    private final Map<DefinitionItemType, Boolean> q = new HashMap<DefinitionItemType, Boolean>();
    private final Map<DefinitionItemType, List<BaseItemData>> long = new HashMap<DefinitionItemType, List<BaseItemData>>();
    private final Map<String, List<String>> for = new HashMap<String, List<String>>();
    private Operation n = Operation.NONE;
    private String b = "";
    private String if = null;
    private boolean r = false;
    int exportOption = 0;
    private boolean char = false;
    private boolean u = false;
    private int goto = 0;
    private boolean d = true;
    private boolean a = false;
    private String void = "";
    private int try = 16;
    private boolean m = false;
    private boolean j = false;
    private boolean v = false;
    private boolean e = false;
    private boolean case = false;
    private String l = null;
    private boolean else = false;
    private String p = null;
    private String do = null;
    private int t = 36;
    private String f;
    private String i;
    private String byte;
    private String s;
    private String int;

    public String getLabelName() {
        return this.i;
    }

    public void setLabelName(String string) {
        this.i = string;
    }

    public String getTaskName() {
        return this.f;
    }

    public void setTaskName(String string) {
        this.f = string;
    }

    public String getLabelDescription() {
        return this.s;
    }

    public void setLabelDescription(String string) {
        this.s = string;
    }

    public String getTaskDescription() {
        return this.byte;
    }

    public void setTaskDescription(String string) {
        this.byte = string;
    }

    public String getCharset() {
        return this.p;
    }

    public void setCharset(String string) {
        this.p = string;
    }

    public String getServerLanguage() {
        return this.do;
    }

    public void setServerLanguage(String string) {
        this.do = string;
    }

    public boolean isDsoLicensed() {
        return this.else;
    }

    public void setDsoLicensed(boolean bl) {
        this.else = bl;
    }

    public String getLockKey() {
        return this.void;
    }

    public void setLockKey(String string) {
        this.void = string;
    }

    public int getLockType() {
        return this.goto;
    }

    public void setLockType(int n) {
        this.goto = n;
    }

    public String getFileName() {
        return this.b;
    }

    public void setFileName(String string) {
        this.b = string;
    }

    public Operation getOperation() {
        return this.n;
    }

    public void setOperation(Operation operation) {
        this.n = operation;
    }

    public boolean isAll(DefinitionItemType definitionItemType) {
        if (this.q.get((Object)definitionItemType) != null) {
            return this.q.get((Object)definitionItemType);
        }
        return false;
    }

    public void setAll(DefinitionItemType definitionItemType, boolean bl) {
        this.q.put(definitionItemType, bl);
    }

    public String getAuthentication() {
        return this.c;
    }

    public void setAuthentication(String string) {
        this.c = string;
    }

    public String getPassword() {
        return this.k;
    }

    public void setPassword(String string) {
        this.k = string;
    }

    public int getPortNumber() {
        return this.new;
    }

    public void setPortNumber(int n) {
        this.new = n;
    }

    public String getServer() {
        return this.o;
    }

    public void setServer(String string) {
        this.o = string;
    }

    public String getUser() {
        return this.g;
    }

    public void setUser(String string) {
        this.g = string;
    }

    public String getOverlayGroup() {
        return this.int;
    }

    public void setOverlayGroup(String string) {
        this.int = string;
    }

    public void add(DefinitionItemType definitionItemType, String string, RelatedType relatedType) {
        if (string != null && string.length() > 0) {
            if (this.long.get((Object)definitionItemType) == null) {
                this.long.put(definitionItemType, new ArrayList());
            }
            this.long.get((Object)definitionItemType).add(new DefinitionItemData(definitionItemType, string, relatedType));
        }
    }

    public void addElement(String string, String string2) {
        if (string != null && string.length() > 0) {
            if (this.for.get(string2) == null) {
                this.for.put(string2, new ArrayList());
            }
            this.for.get(string2).add(string);
        }
    }

    public void add(BaseItemData baseItemData) {
        if (baseItemData != null) {
            if (this.long.get((Object)baseItemData.getType()) == null) {
                this.long.put(baseItemData.getType(), new ArrayList());
            }
            this.long.get((Object)baseItemData.getType()).add(baseItemData);
        }
    }

    public boolean isOverwrite() {
        return this.r;
    }

    public void setOverwrite(boolean bl) {
        this.r = bl;
    }

    public int getExportOption() {
        return this.exportOption;
    }

    public void setExportOption(int n) {
        this.exportOption = n;
    }

    public String getCommandSetFile() {
        return this.if;
    }

    public void setCommandSetFile(String string) {
        this.if = string;
    }

    public void validate() throws DefinitionException {
        if (this.getUser() == null || this.getUser() != null && this.getUser().length() == 0) {
            throw new DefinitionException("User Name must be provided");
        }
        if (this.getServer() == null || this.getServer() != null && this.getServer().length() == 0) {
            throw new DefinitionException("Server Name must be provided");
        }
        if (this.getFileName() == null || this.getFileName() != null && this.getFileName().length() == 0) {
            throw new DefinitionException("File Name must be provided");
        }
        int n = Util.validateFileName(this.getFileName());
        switch (n) {
            case 1: {
                throw new DefinitionException("File name validation failed. The directory is not valid.");
            }
            case 2: {
                throw new DefinitionException("File name validation failed. The file name is invalid.");
            }
            case 3: {
                throw new DefinitionException("File name validation failed. No file name was supplied.");
            }
            case 4: {
                throw new DefinitionException("File name validation failed. The supplied file name is a directory.");
            }
            case 5: {
                throw new DefinitionException("File name validation failed. The directory does not exist.");
            }
            case 6: {
                throw new DefinitionException("File name validation failed. The file name must have a .def or .xml extension.");
            }
        }
        if (n != 0) {
            // empty if block
        }
    }

    public boolean requiresExpansion() {
        for (DefinitionItemType definitionItemType : this.q.keySet()) {
            if (this.q.get((Object)definitionItemType) == null || !this.q.get((Object)definitionItemType).booleanValue()) continue;
            return true;
        }
        for (DefinitionItemType definitionItemType : this.long.keySet()) {
            List<BaseItemData> list = this.long.get((Object)definitionItemType);
            if (list == null) continue;
            for (BaseItemData baseItemData : list) {
                if (!(baseItemData instanceof DefinitionItemData) || ((DefinitionItemData)baseItemData).getRelated() == RelatedType.NONE || ((DefinitionItemData)baseItemData).getRelated() == RelatedType.FULL) continue;
                return true;
            }
        }
        return false;
    }

    public void connect() throws ARException {
        try {
            this.w = new ARServerUser();
            this.w.setUser(this.getUser());
            this.w.setPassword(this.getPassword());
            this.w.setServer(this.getServer());
            this.w.setPort(this.getPortNumber());
            this.w.setAuthentication(this.getAuthentication());
            this.w.setClientType(this.t);
            this.w.useAdminRpcQueue();
            this.w.setOverlayGroup(this.getOverlayGroup());
            this.w.login();
        }
        catch (ARException aRException) {
            if (h.isEnabledFor((Priority)Level.ERROR)) {
                h.error((Object)MessageFormat.format("Unable to connect to server {0} : {1}", this.getServer(), aRException.getMessage()));
            }
            throw aRException;
        }
    }

    public ARServerUser getContext() {
        return this.w;
    }

    public boolean isXML() {
        return this.b != null && this.b.length() > 0 && this.b.toUpperCase().endsWith(".XML");
    }

    public int getObjectCount() {
        int n = 0;
        for (DefinitionItemType definitionItemType : this.long.keySet()) {
            if (this.long.get((Object)definitionItemType) == null) continue;
            n += this.long.get((Object)definitionItemType).size();
        }
        return n;
    }

    public List<BaseItemData> getItems(DefinitionItemType definitionItemType) {
        return this.long.get((Object)definitionItemType);
    }

    public List<String> getElements(String string) {
        return this.for.get(string);
    }

    public boolean hasElements(String string) {
        return this.for.get(string) != null;
    }

    public String getLastName(DefinitionItemType definitionItemType) {
        if (this.long.get((Object)definitionItemType).size() == 0) {
            return new String();
        }
        return this.long.get((Object)definitionItemType).get(this.long.get((Object)definitionItemType).size() - 1).getName();
    }

    public void addAll(Map<DefinitionItemType, List<BaseItemData>> map) {
        for (DefinitionItemType definitionItemType : map.keySet()) {
            List<BaseItemData> list = map.get((Object)definitionItemType);
            if (list == null) continue;
            if (this.long.get((Object)definitionItemType) == null) {
                this.long.put(definitionItemType, list);
                continue;
            }
            for (BaseItemData baseItemData : list) {
                this.long.get((Object)definitionItemType).add(baseItemData);
            }
        }
    }

    public Map<DefinitionItemType, Boolean> getAllFlags() {
        return this.q;
    }

    public boolean isServerIndependent() {
        return this.d;
    }

    public void setServerIndependent(boolean bl) {
        this.d = bl;
    }

    public Map<DefinitionItemType, List<BaseItemData>> getItems() {
        return this.long;
    }

    public boolean isDeleteExcessFields() {
        return this.char;
    }

    public void setDeleteExcessFields(boolean bl) {
        this.char = bl;
    }

    public boolean isDeleteExcessViews() {
        return this.u;
    }

    public void setDeleteExcessViews(boolean bl) {
        this.u = bl;
    }

    public int getConflictHandling() {
        return this.try;
    }

    public void setConflictHandling(int n) {
        this.try = n;
    }

    public boolean isImportCompleteFile() {
        return this.a;
    }

    public void setImportCompleteFile(boolean bl) {
        this.a = bl;
    }

    public boolean isPreserveVUINamespace() {
        return this.j;
    }

    public void setPreserveVUINamespace(boolean bl) {
        this.j = bl;
    }

    public boolean isPreserveIndex() {
        return this.m;
    }

    public void setPreserveIndex(boolean bl) {
        this.m = bl;
    }

    public boolean isPreserveAppForms() {
        return this.v;
    }

    public void setPreserveAppForms(boolean bl) {
        this.v = bl;
    }

    public boolean isImportWithAppOwner() {
        return this.e;
    }

    public void setImportWithAppOwner(boolean bl) {
        this.e = bl;
    }

    public String getLogFile() {
        return this.l;
    }

    public void setLogFile(String string) {
        this.l = string;
    }

    public void setClientType(int n) {
        this.t = n;
    }

    public boolean isOverwriteFullTextOptions() {
        return this.case;
    }

    public void setOverwriteFullTextOptions(boolean bl) {
        this.case = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        NONE,
        IMPORT,
        EXPORT;

    }
}

