/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class XMLSchemaParser
implements DOMErrorHandler {
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    public static final int BIG_PRIME = 2039;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected XMLGrammarPoolImpl grammarPool;
    protected XMLParserConfiguration parserConfiguration = null;
    protected Document mapDom = null;
    protected String currentTargetNamespace = null;
    protected XSModel model;
    protected XSNamedMap elementMap;
    protected XSNamedMap attributeMap;
    protected XSNamedMap typeDefMap;
    protected XSNamedMap notationMap;
    protected String tempDir = null;
    protected HashMap schemaLocationMap = new HashMap();
    protected StringBuffer warnings = new StringBuffer();
    public static final int SEVERITY_NONE = -1;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_ERROR = 2;
    public static final int SEVERITY_FATAL_ERROR = 3;
    private Stack<String> complexNameStack;
    private HashMap<String, String> attrFormDefaultMap;
    private HashMap<String, String> eleFormDefaultMap;
    public String baseUri = null;
    protected Grammar g = null;

    public XMLSchemaParser(String string, StringBuffer stringBuffer) {
        this.warnings = stringBuffer;
        this.complexNameStack = new Stack();
        this.attrFormDefaultMap = new HashMap();
        this.eleFormDefaultMap = new HashMap();
        this.parseXMLSchema(string);
    }

    public XMLSchemaParser(String string, String string2, StringBuffer stringBuffer) {
        this.warnings = stringBuffer;
        this.complexNameStack = new Stack();
        this.attrFormDefaultMap = new HashMap();
        this.eleFormDefaultMap = new HashMap();
        this.setBaseUri(string);
        this.parseXMLSchema(string2);
    }

    public XMLSchemaParser(String string, String string2, String string3, StringBuffer stringBuffer) {
        this.warnings = stringBuffer;
        this.complexNameStack = new Stack();
        this.attrFormDefaultMap = new HashMap();
        this.eleFormDefaultMap = new HashMap();
        this.tempDir = string2 + System.getProperty("file.separator");
        this.setBaseUri(string);
        this.parseXMLSchema(string3);
    }

    public void setBaseUri(String string) {
        this.baseUri = string;
    }

    public void setTempDir(String string) {
        this.tempDir = string;
    }

    public String getElementFormDefault(String string) {
        String string2 = this.eleFormDefaultMap.get(string);
        if (string2 == null || string2.equals("")) {
            string2 = "unqualified";
        }
        return string2;
    }

    public String getAttributeFormDefault(String string) {
        String string2 = this.attrFormDefaultMap.get(string);
        if (string2 == null || string2.equals("")) {
            string2 = "unqualified";
        }
        return string2;
    }

    public boolean handleError(DOMError dOMError) {
        if (dOMError.getSeverity() >= 3 && dOMError.getRelatedException() instanceof RuntimeException) {
            throw (RuntimeException)dOMError.getRelatedException();
        }
        this.warnings.append("WARNING:");
        if (dOMError.getRelatedException() instanceof XMLParseException) {
            XMLParseException xMLParseException = (XMLParseException)dOMError.getRelatedException();
            String string = xMLParseException.getExpandedSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                this.warnings.append(string);
            }
            this.warnings.append(":" + xMLParseException.getLineNumber() + ":" + xMLParseException.getColumnNumber() + ": " + xMLParseException.getMessage());
        } else {
            this.warnings.append(dOMError.getMessage());
        }
        this.warnings.append(System.getProperty("line.separator"));
        return true;
    }

    private boolean checkIfFilename(String string) {
        int n = 0;
        int n2 = 0;
        try {
            String[] stringArray = string.split("http:");
            String[] stringArray2 = string.split("\\\\");
            n = stringArray.length;
            n2 = stringArray2.length;
        }
        catch (Exception exception) {
            throw new ARWSException("OTHER_ERROR", "Error in checking for filename " + exception);
        }
        return n <= 1 && n2 <= 1;
    }

    private void extractFormDefaultValues(String string) {
        if (string != null) {
            NodeList nodeList;
            if (string.equals(Constants.URI_DEFAULT_SOAP_ENC)) {
                return;
            }
            this.schemaLocationMap.put(string, string);
            Document document = WsdlUtil.newDocument(string, false);
            Element element = document.getDocumentElement();
            String string2 = "unqualified";
            String string3 = "unqualified";
            if (!element.getLocalName().equals("schema")) {
                throw new ARWSException("INVALID_XSD", "Schema " + string + " does not have root element as schema");
            }
            String string4 = element.getAttribute("elementFormDefault");
            string2 = string4 != null && string4.equals("qualified") ? "qualified" : "unqualified";
            string4 = element.getAttribute("attributeFormDefault");
            string3 = string4 != null && string4.equals("qualified") ? "qualified" : "unqualified";
            string4 = element.getAttribute("targetNamespace");
            if (string4 != null) {
                this.attrFormDefaultMap.put(string4, string3);
                this.eleFormDefaultMap.put(string4, string2);
            }
            if ((nodeList = element.getChildNodes()) != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object v;
                    String string5;
                    Element element2;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || !(element2 = (Element)node).getLocalName().equals("import") || (string5 = element2.getAttribute("schemaLocation")) == null || string5.length() <= 0) continue;
                    if (this.checkIfFilename(string5)) {
                        string5 = this.tempDir + string5;
                    }
                    if ((v = this.schemaLocationMap.get(string5)) != null) continue;
                    this.extractFormDefaultValues(string5);
                }
            }
        }
    }

    private static XMLInputSource stringToXIS(String string) {
        return new XMLInputSource(null, string, null);
    }

    protected void buildGrammarForValidation(String string) {
        SymbolTable symbolTable = new SymbolTable(2039);
        XMLGrammarPreparser xMLGrammarPreparser = new XMLGrammarPreparser(symbolTable);
        this.grammarPool = new XMLGrammarPoolImpl();
        xMLGrammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        xMLGrammarPreparser.setProperty(GRAMMAR_POOL, (Object)this.grammarPool);
        xMLGrammarPreparser.setFeature(NAMESPACES_FEATURE_ID, true);
        xMLGrammarPreparser.setFeature(VALIDATION_FEATURE_ID, true);
        xMLGrammarPreparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        boolean bl = false;
        boolean bl2 = false;
        xMLGrammarPreparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
        xMLGrammarPreparser.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
        try {
            this.g = xMLGrammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", XMLSchemaParser.stringToXIS(string));
        }
        catch (Exception exception) {
            throw new ARWSException("INVALID_XSD", "Could not load schema " + exception.toString() + " " + string);
        }
        if (this.parserConfiguration == null) {
            this.parserConfiguration = new XIncludeAwareParserConfiguration(symbolTable, (XMLGrammarPool)this.grammarPool);
        } else {
            this.parserConfiguration.setProperty(SYMBOL_TABLE, (Object)symbolTable);
            this.parserConfiguration.setProperty(GRAMMAR_POOL, (Object)this.grammarPool);
        }
        this.parserConfiguration.setFeature(NAMESPACES_FEATURE_ID, true);
        this.parserConfiguration.setFeature(VALIDATION_FEATURE_ID, true);
        this.parserConfiguration.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        this.parserConfiguration.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
        this.parserConfiguration.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
    }

    protected void validateInputDoc(String string) {
        try {
            if (this.parserConfiguration != null) {
                this.parserConfiguration.parse(XMLSchemaParser.stringToXIS(string));
            }
        }
        catch (Exception exception) {
            throw new ARWSException("OTHER_ERROR", "Input doc not found " + exception.toString());
        }
    }

    protected void parseXMLSchema(String string) {
        DOMImplementationRegistry dOMImplementationRegistry;
        this.extractFormDefaultValues(string);
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        try {
            dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception exception) {
            throw new ARWSException("OTHER_ERROR", "Error trying to get Registry: " + exception.toString());
        }
        XSImplementation xSImplementation = (XSImplementation)dOMImplementationRegistry.getDOMImplementation("XS-Loader");
        XSLoader xSLoader = xSImplementation.createXSLoader(null);
        DOMConfiguration dOMConfiguration = xSLoader.getConfig();
        dOMConfiguration.setParameter("error-handler", this);
        dOMConfiguration.setParameter("validate", Boolean.TRUE);
        System.out.println("Parsing " + string + "...");
        this.model = xSLoader.loadURI(string);
        if (this.model != null) {
            this.elementMap = this.model.getComponents((short)2);
            this.attributeMap = this.model.getComponents((short)1);
            this.typeDefMap = this.model.getComponents((short)3);
            this.notationMap = this.model.getComponents((short)11);
        }
    }

    public Element parseSchemaForElement(Document document, QName qName) {
        XSElementDecl xSElementDecl = (XSElementDecl)this.elementMap.itemByName(qName.getNamespaceURI(), qName.getLocalPart());
        if (xSElementDecl == null) {
            throw new ARWSException("INVALID_XSD", "Cannot find element " + qName.getLocalPart());
        }
        this.currentTargetNamespace = qName.getNamespaceURI();
        this.mapDom = document;
        DocumentFragment documentFragment = this.mapDom.createDocumentFragment();
        this.parseElement(documentFragment, xSElementDecl);
        return (Element)documentFragment.getFirstChild();
    }

    public void parseSchemaForType(Element element, QName qName) {
        XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.typeDefMap.itemByName(qName.getNamespaceURI(), qName.getLocalPart());
        if (xSTypeDefinition == null) {
            throw new ARWSException("INVALID_XSD", "Cannot find type " + qName.getLocalPart());
        }
        this.currentTargetNamespace = qName.getNamespaceURI();
        this.mapDom = element.getOwnerDocument();
        if (xSTypeDefinition.getTypeCategory() == 16) {
            this.parseSimpleType(element, (XSSimpleType)xSTypeDefinition);
        } else if (xSTypeDefinition.getTypeCategory() == 15) {
            this.parseComplexType(element, (XSComplexTypeDecl)xSTypeDefinition);
        }
    }

    public Element parseElement(Node node, XSElementDecl xSElementDecl) {
        Element element = this.mapDom.createElementNS(null, "element");
        element.setAttributeNS(null, "name", xSElementDecl.fName);
        String string = xSElementDecl.fTargetNamespace;
        if (string != null) {
            this.currentTargetNamespace = string;
        }
        element.setAttributeNS(null, "targetNamespace", this.currentTargetNamespace);
        element.setAttributeNS(null, "form", this.getElementFormDefault(string));
        node.appendChild(element);
        XSTypeDefinition xSTypeDefinition = xSElementDecl.fType;
        if (xSTypeDefinition != null) {
            short s = xSTypeDefinition.getTypeCategory();
            String string2 = xSTypeDefinition.getName();
            String string3 = xSTypeDefinition.getNamespace();
            if (string2 != null && string2.equals("anyType") && string3 != null && string3.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA)) {
                this.parseAnyType(element, xSTypeDefinition);
            } else if (s == 15) {
                this.parseComplexType(element, (XSComplexTypeDecl)xSTypeDefinition);
            } else if (s == 16) {
                this.parseSimpleType(element, (XSSimpleType)xSTypeDefinition);
                if (xSElementDecl.getConstraintType() == 1) {
                    element.setAttributeNS(null, "default", xSElementDecl.fDefault.normalizedValue);
                }
            } else {
                element.setAttributeNS(null, "xmlType", "true");
                element.setAttributeNS(null, "dataType", "string");
                this.warnings.append("WARNING: Unsupported type in parseElement, treating as xmlType" + xSElementDecl + System.getProperty("line.separator"));
            }
        }
        return element;
    }

    public Element parseAttribute(Element element, XSComplexTypeDecl xSComplexTypeDecl) {
        Element element2 = null;
        XSAttributeGroupDecl xSAttributeGroupDecl = xSComplexTypeDecl.getAttrGrp();
        if (xSAttributeGroupDecl != null) {
            XSObjectList xSObjectList = xSAttributeGroupDecl.getAttributeUses();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                String string;
                XSAttributeDecl xSAttributeDecl;
                XSAttributeUse xSAttributeUse = (XSAttributeUse)xSObjectList.item(i);
                if (xSAttributeUse == null || (xSAttributeDecl = (XSAttributeDecl)xSAttributeUse.getAttrDeclaration()) == null || (string = xSAttributeDecl.getName()) == null) continue;
                element2 = this.mapDom.createElementNS(null, "attribute");
                element2.setAttributeNS(null, "name", string);
                if (xSAttributeDecl.getNamespace() != null) {
                    this.currentTargetNamespace = xSAttributeDecl.getNamespace();
                }
                element2.setAttributeNS(null, "targetNamespace", this.currentTargetNamespace);
                if (xSAttributeDecl.getNamespace() != null) {
                    element2.setAttributeNS(null, "form", "qualified");
                } else {
                    element2.setAttributeNS(null, "form", this.getAttributeFormDefault(this.currentTargetNamespace));
                }
                if (xSAttributeDecl.getConstraintType() == 1) {
                    element2.setAttributeNS(null, "default", xSAttributeDecl.getConstraintValue());
                }
                XSSimpleType xSSimpleType = (XSSimpleType)xSAttributeDecl.getTypeDefinition();
                this.parseSimpleType(element2, xSSimpleType);
                boolean bl = xSAttributeUse.getRequired();
                if (bl) {
                    element2.setAttributeNS(null, "use", "required");
                } else {
                    element2.setAttributeNS(null, "use", "optional");
                }
                element.appendChild(element2);
            }
        }
        return element2;
    }

    public void parseChoice(Element element, XSParticle xSParticle) {
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticle.getTerm();
        if (xSModelGroupImpl.getCompositor() == 2) {
            XSObjectList xSObjectList = xSModelGroupImpl.getParticles();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                this.parseParticle(element, (XSParticleDecl)xSObjectList.item(i));
            }
        } else {
            this.parseParticle(element, (XSParticleDecl)xSParticle);
        }
    }

    public void parseAll(Element element, XSParticle xSParticle) {
        element.setAttributeNS(null, "all", "true");
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticle.getTerm();
        if (xSModelGroupImpl.getCompositor() == 3) {
            XSObjectList xSObjectList = xSModelGroupImpl.getParticles();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                this.parseParticle(element, (XSParticleDecl)xSObjectList.item(i));
            }
        } else {
            this.parseParticle(element, (XSParticleDecl)xSParticle);
        }
    }

    public void parseAnyType(Element element, XSTypeDefinition xSTypeDefinition) {
        element.setAttributeNS(null, "dataType", "string");
    }

    public void parseSimpleType(Element element, XSSimpleType xSSimpleType) {
        if (xSSimpleType == null) {
            return;
        }
        if (xSSimpleType.getVariety() == 1) {
            Object object;
            XSSimpleType xSSimpleType2 = xSSimpleType;
            while (!xSSimpleType2.getNamespace().equals(SchemaSymbols.URI_SCHEMAFORSCHEMA) && (object = xSSimpleType.getBaseType()) != xSSimpleType2) {
                xSSimpleType2 = object;
            }
            object = xSSimpleType2.getName();
            if (xSSimpleType.getPrimitiveKind() == 2 && ((String)object).equals("string")) {
                object = "boolean";
            }
            element.setAttributeNS(null, "dataType", (String)object);
        } else {
            element.setAttributeNS(null, "xmlType", "true");
            element.setAttributeNS(null, "dataType", "string");
            this.warnings.append("WARNING: Unsupported simple element variety in parseSimpleType. Treating as xmlType" + xSSimpleType + System.getProperty("line.separator"));
        }
    }

    public void parseComplexType(Element element, XSComplexTypeDecl xSComplexTypeDecl) {
        if (xSComplexTypeDecl != null && xSComplexTypeDecl.getContentType() != 0) {
            String string = xSComplexTypeDecl.getTargetNamespace() + ":" + xSComplexTypeDecl.getTypeName();
            try {
                if (this.complexNameStack.search(string) != -1) {
                    element.setAttributeNS(null, "xmlType", "true");
                    this.warnings.append("WARNING: Unsupported recursive reference in parseComplexType. Treating as xmlType" + System.getProperty("line.separator"));
                    return;
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            this.complexNameStack.push(string);
            if (xSComplexTypeDecl.getContentType() == 3) {
                element.setAttributeNS(null, "xmlType", "true");
                element.setAttributeNS(null, "dataType", "string");
                this.warnings.append("WARNING: Unsupported Mixed content type in parseComplexType. Treating as xmlType" + System.getProperty("line.separator"));
            } else if (xSComplexTypeDecl.getContentType() == 1) {
                this.parseSimpleType(element, (XSSimpleType)xSComplexTypeDecl.getSimpleType());
            } else if (xSComplexTypeDecl.getContentType() == 2) {
                if (xSComplexTypeDecl.getTypeName().indexOf("#Anon") == -1) {
                    element.setAttributeNS(null, "complexType", xSComplexTypeDecl.getTypeName());
                }
                this.parseParticle(element, (XSParticleDecl)xSComplexTypeDecl.getParticle());
            }
            this.complexNameStack.pop();
        }
        this.parseAttribute(element, xSComplexTypeDecl);
    }

    public void parseParticle(Element element, XSParticleDecl xSParticleDecl) {
        XSModelGroupImpl xSModelGroupImpl = null;
        if (xSParticleDecl == null) {
            return;
        }
        int n = xSParticleDecl.getMinOccurs();
        int n2 = xSParticleDecl.getMaxOccurs();
        short s = xSParticleDecl.fType;
        if (s == 3) {
            xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.getTerm();
        }
        if (s == 3 && xSModelGroupImpl != null && xSModelGroupImpl.getCompositor() == 1) {
            XSObjectList xSObjectList = xSModelGroupImpl.getParticles();
            for (int i = 0; i < xSObjectList.getLength(); ++i) {
                this.parseParticle(element, (XSParticleDecl)xSObjectList.item(i));
            }
        } else if (s == 1) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            Element element2 = this.parseElement(element, xSElementDecl);
            if (xSElementDecl.getNillable()) {
                element2.setAttributeNS(null, "nillable", "true");
            }
            if (n > 0) {
                element2.setAttributeNS(null, "minOccurs", Integer.toString(n));
            } else {
                element2.setAttributeNS(null, "minOccurs", Integer.toString(0));
            }
            if (n2 == -1) {
                element2.setAttributeNS(null, "maxOccurs", "unbounded");
            } else if (n2 > 1) {
                element2.setAttributeNS(null, "maxOccurs", Integer.toString(n2));
            } else {
                element2.setAttributeNS(null, "maxOccurs", Integer.toString(1));
            }
        } else if (s == 3 && xSModelGroupImpl != null && xSModelGroupImpl.getCompositor() == 2) {
            Element element3 = this.mapDom.createElementNS(null, "choice");
            element3.setAttributeNS(null, "name", "choiceNode");
            element3.setAttributeNS(null, "form", this.getElementFormDefault(this.currentTargetNamespace));
            element.appendChild(element3);
            this.parseChoice(element3, (XSParticle)xSParticleDecl);
        } else if (s == 3 && xSModelGroupImpl != null && xSModelGroupImpl.getCompositor() == 3) {
            this.parseAll(element, (XSParticle)xSParticleDecl);
        } else {
            element.setAttributeNS(null, "xmlType", "true");
            element.setAttributeNS(null, "dataType", "string");
            this.warnings.append("WARNING: Unsupported Particle type in parseParticle. Treating as xmlType" + xSParticleDecl + System.getProperty("line.separator"));
        }
    }

    public static String expandSystemId(String string, String string2) {
        String string3;
        try {
            string3 = XMLEntityManager.expandSystemId((String)string, (String)string2, (boolean)false);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new ARWSException("OTHER_ERROR", "SystemID: " + string + " Exception: " + malformedURIException.toString());
        }
        return string3;
    }
}

