/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.util;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.mapping.ARSWebService;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.BasicHTTPAuthenticator;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.CustomXmlSchemaParser;
import com.bmc.arsys.ws.wsdl.WsdlParser;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import com.bmc.arsys.ws.wsdlgen.WsdlGenerator;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis.utils.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WsdlAdminInterface {
    protected String tempDir = "C:\\temp";
    protected int rc = 0;
    protected String errorString = "";
    protected Document outputDocument = null;
    protected boolean outputDocumentIsUTF8 = false;
    protected StringBuffer warnings = new StringBuffer();

    public void setTempDir(String string) {
        this.tempDir = string;
    }

    public int getErrorCode() {
        return this.rc;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public String getOutputAsXMLString() {
        StringWriter stringWriter = new StringWriter();
        this.getOutputInWriter(stringWriter);
        return stringWriter.toString();
    }

    protected void exceptionToErrorCode(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        String string = "";
        if (exception instanceof ARWSException && ((ARWSException)exception).getTargetException() != null) {
            string = ((ARWSException)exception).getTargetException().getMessage() + System.getProperty("line.separator");
        }
        this.errorString = "ERROR: " + exception.getMessage() + System.getProperty("line.separator") + System.getProperty("line.separator") + "Additional Details:" + System.getProperty("line.separator") + string + stringWriter.getBuffer().toString();
        WsdlUtil.trace(this.errorString);
        this.rc = -1;
    }

    public void getOutputAsXMLFile(String string) {
        this.errorString = "";
        this.rc = 0;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (this.outputDocumentIsUTF8) {
                this.getOutputInWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8"));
            } else {
                this.getOutputInWriter(new OutputStreamWriter(fileOutputStream));
            }
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
    }

    public void getOutputInWriter(Writer writer) {
        this.errorString = "";
        this.rc = 0;
        if (this.outputDocument == null) {
            this.rc = -1;
            return;
        }
        try {
            if (this.outputDocumentIsUTF8) {
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            } else {
                writer.write("<?xml version=\"1.0\" encoding=\"" + WsdlUtil.getAdminToolEncoding() + "\"?>");
            }
            writer.write(System.getProperty("line.separator"));
            DOM2Writer.serializeAsXML((Node)this.outputDocument.getDocumentElement(), (Writer)writer, (boolean)true, (boolean)true);
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
    }

    public void generateWsdlFromMappingString(String string) {
        this.generateWsdlFromMappingString(string, null);
    }

    public void generateWsdlFromMappings(String string, String string2) {
        this.generateWsdlFromMappingString(string, string2);
    }

    public void generateWsdlFromMappingString(String string, String string2) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            this.outputDocument = this.generateWsdl(WsdlUtil.newDocument(inputSource), string2);
            this.outputDocumentIsUTF8 = true;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void generateWsdlFromMappingUri(String string) {
        this.generateWsdlFromMappingUri(string, null);
    }

    public void generateWsdlFromMappingUri(String string, String string2) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.generateWsdl(WsdlUtil.newDocument(string, false), string2);
            this.outputDocumentIsUTF8 = true;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseWSDLIntoMappingString(String string) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.parseWsdl(string);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseWSDLIntoMappingString(String string, String string2, String string3) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.parseWsdl(string, string2, string3);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseWSDLIntoMappingString(String string, Authenticator authenticator) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.parseWsdl(string, authenticator);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void getTopLevelElementsFromSchemaInfo(String string) {
        this.getSchemaTopLevelElementsAsXmlString(string);
    }

    public void getSchemaTopLevelElementsAsXmlString(String string) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.getSchemaTopLevelElements(string);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseXMLSchemaIntoMappingString(String string) {
        this.parseXMLSchemaIntoMappingString(string, null, null);
    }

    public void parseXMLSchemaIntoMappingString(String string, String string2, String string3) {
        this.parseXMLSchemaIntoMappingString(string, string2, string3, "element");
    }

    public void parseXMLSchemaIntoMappingString(String string, String string2, String string3, String string4) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.parseXMLSchema(string, string2, string3, string4);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseSchemaInfoIntoMappingString(String string, String string2, String string3, String string4) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            CustomXmlSchemaParser customXmlSchemaParser = new CustomXmlSchemaParser(this.warnings);
            customXmlSchemaParser.parseSchema(null, string);
            String string5 = null;
            string5 = customXmlSchemaParser.getIsLinked() ? string : customXmlSchemaParser.writeSchemasToTempDir(this.tempDir, null, null);
            this.outputDocument = this.parseXMLSchema(string5, string2, string3, string4);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseXSDIntoSchemaInfo(String string, String string2) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            CustomXmlSchemaParser customXmlSchemaParser = new CustomXmlSchemaParser(this.warnings);
            customXmlSchemaParser.parseSchema(null, string2);
            customXmlSchemaParser.parseSchema(null, string);
            this.outputDocument = customXmlSchemaParser.getSchemaInfo();
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseXSDNResolveMappings(String string, String string2) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            NodeList nodeList;
            Element element;
            InputSource inputSource = new InputSource(new StringReader(string2));
            Document document = WsdlUtil.newDocument(inputSource);
            if (document != null && (element = document.getDocumentElement()) != null && (nodeList = element.getElementsByTagName("webservice")) != null) {
                this.outputDocument = WsdlUtil.newDocument();
                Element element2 = this.outputDocument.createElementNS(null, "webservices");
                this.outputDocument.appendChild(element2);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element3 = (Element)nodeList.item(i);
                    if (element3 == null) continue;
                    ARSWebService aRSWebService = new ARSWebService(element3);
                    ARSWebService aRSWebService2 = new ARSWebService(aRSWebService, string, this.warnings);
                    this.outputDocument.getDocumentElement().appendChild(this.outputDocument.importNode(aRSWebService2.getElement(), true));
                }
            }
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception exception) {
            this.exceptionToErrorCode(exception);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public Document generateWsdl(Document document, String string) {
        NodeList nodeList;
        Object object;
        ArrayList<ARSWebService> arrayList = new ArrayList<ARSWebService>();
        if (document != null && (object = document.getDocumentElement()) != null && (nodeList = object.getElementsByTagName("webservice")) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element == null) continue;
                ARSWebService aRSWebService = new ARSWebService(element);
                arrayList.add(aRSWebService);
            }
        }
        object = new WsdlGenerator(arrayList, string, this.warnings);
        return ((WsdlGenerator)object).generateWsdl();
    }

    public Document parseWsdl(String string) {
        WsdlParser wsdlParser = new WsdlParser(string, this.tempDir, this.warnings);
        return wsdlParser.parseWsdl();
    }

    public Document parseWsdl(String string, String string2, String string3) {
        return this.parseWsdl(string, new BasicHTTPAuthenticator(string2, string3));
    }

    public Document parseWsdl(String string, Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
        WsdlParser wsdlParser = new WsdlParser(string, this.tempDir, this.warnings);
        return wsdlParser.parseWsdl();
    }

    public Document parseXMLSchema(String string, String string2, String string3, String string4) {
        Object object;
        QName qName;
        XMLSchemaParser xMLSchemaParser = new XMLSchemaParser(string, this.warnings);
        Document document = WsdlUtil.newDocument();
        if (string3 != null && !string3.equals("")) {
            qName = new QName(string2, string3);
        } else {
            object = new CustomXmlSchemaParser(this.warnings);
            ((CustomXmlSchemaParser)object).parseSchema(null, string);
            qName = ((CustomXmlSchemaParser)object).getFirstGlobalElement();
        }
        if (string4 == null || !string4.equals("complexType")) {
            string4 = "element";
        }
        object = new ARSMapping(xMLSchemaParser, qName, string4, document);
        document.appendChild(((ARSMapping)object).getMappingElement());
        return document;
    }

    public Document getSchemaTopLevelElements(String string) {
        CustomXmlSchemaParser customXmlSchemaParser = new CustomXmlSchemaParser(this.warnings);
        customXmlSchemaParser.parseSchema(null, string);
        if (customXmlSchemaParser.getFirstGlobalElement() == null && customXmlSchemaParser.getFirstGlobalComplexType() == null) {
            throw new ARWSException("INVALID_WSDL", "ERROR: no top level elements/complexTypes in this file");
        }
        return customXmlSchemaParser.getGlobalElementsAndComplexTypes();
    }

    public static void printUsage() {
        System.out.println("Usage");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface generateWSDL <mappingUri>");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface generateWSDLSchemaInfo <mappingUri> <schemaInfoUri>");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface generateWSDLSchemaURI <mappingUri> <schemaUri>");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface parseWsdl <wsdlUri> [<authUser> <authPass>]");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface getGlobals <xsdUri>");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface parseXMLSchema <xsdUri> [<namespace> <name> [<type>]]");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface resolveMappings <schemaUri> <mappingUri>");
    }

    public static String readFile(String string) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = fileReader.read();
        while (n != -1) {
            stringBuffer.append((char)n);
            n = fileReader.read();
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException {
        if (stringArray.length == 0) {
            WsdlAdminInterface.printUsage();
            return;
        }
        WsdlAdminInterface wsdlAdminInterface = new WsdlAdminInterface();
        wsdlAdminInterface.setTempDir("C:\\temp");
        if (stringArray[0].equals("generateWSDL") && stringArray.length == 2) {
            wsdlAdminInterface.generateWsdlFromMappingUri(stringArray[1]);
        } else if (stringArray[0].equals("generateWSDLSchemaURI") && stringArray.length == 3) {
            wsdlAdminInterface.generateWsdlFromMappingUri(stringArray[1], stringArray[2]);
        } else if (stringArray[0].equals("generateWSDLSchemaInfo") && stringArray.length == 3) {
            wsdlAdminInterface.generateWsdlFromMappingUri(stringArray[1], WsdlAdminInterface.readFile(stringArray[2]));
        } else if (stringArray[0].equals("parseWsdl") && stringArray.length == 2) {
            wsdlAdminInterface.parseWSDLIntoMappingString(stringArray[1]);
        } else if (stringArray[0].equals("parseWsdl") && stringArray.length == 4) {
            wsdlAdminInterface.parseWSDLIntoMappingString(stringArray[1], stringArray[2], stringArray[3]);
        } else if (stringArray[0].equals("getGlobals") && stringArray.length == 2) {
            wsdlAdminInterface.getSchemaTopLevelElementsAsXmlString(stringArray[1]);
        } else if (stringArray[0].equals("parseXMLSchema") && stringArray.length == 2) {
            wsdlAdminInterface.parseXMLSchemaIntoMappingString(stringArray[1]);
        } else if (stringArray[0].equals("parseXMLSchema") && stringArray.length == 4) {
            wsdlAdminInterface.parseXMLSchemaIntoMappingString(stringArray[1], stringArray[2], stringArray[3]);
        } else if (stringArray[0].equals("parseXMLSchema") && stringArray.length == 5) {
            wsdlAdminInterface.parseXMLSchemaIntoMappingString(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
        } else if (stringArray[0].equals("resolveMappings") && stringArray.length == 3) {
            wsdlAdminInterface.parseXSDNResolveMappings(stringArray[1], WsdlAdminInterface.readFile(stringArray[2]));
        } else {
            WsdlAdminInterface.printUsage();
            return;
        }
        if (wsdlAdminInterface.getErrorCode() != 0) {
            System.out.println("ERROR: " + wsdlAdminInterface.getErrorCode() + " " + wsdlAdminInterface.getErrorString());
        } else {
            if (!wsdlAdminInterface.getErrorString().equals("")) {
                System.out.println("WARNINGS :" + wsdlAdminInterface.getErrorString());
            }
            System.out.println(wsdlAdminInterface.getOutputAsXMLString());
            wsdlAdminInterface.getOutputAsXMLFile("C:\\temp\\" + stringArray[0] + ".xml");
        }
    }
}

