/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARQualifierHelper;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.CoreFieldId;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.ProcessResult;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import java.util.ArrayList;
import java.util.List;

public class Utilities {
    private static final int AR_RESERV_PREFERENCE_ARS_SCHEMA_USER = 30002;
    private static final int[] PREF_SCHEMA_KEY = new int[]{30002};
    private static final int[] USER_PREFERENCE_FIELD_IDS = new int[]{24003, 24015};
    private static String userPrefForm = null;

    public static int getIntegerValue(String string) {
        int n;
        block6: {
            n = 0;
            try {
                if (string != null && string.length() > 0) {
                    n = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                int n2 = string.indexOf(";");
                if (n2 == -1) break block6;
                string = string.substring(0, n2);
                try {
                    if (string != null && string.length() > 0) {
                        n = Integer.parseInt(string);
                    }
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    public static int getVuiId(ARServerUser aRServerUser, String string, String string2) {
        try {
            ArrayList<Value> arrayList = new ArrayList<Value>();
            arrayList.add(new Value(36));
            arrayList.add(new Value("\"" + string + "\""));
            arrayList.add(new Value("3"));
            arrayList.add(new Value(string2));
            ProcessResult processResult = aRServerUser.executeProcessForActiveLink("*RemedyApplicationCommand", 9999, 0, 0, new Timestamp(0L), null, arrayList);
            return new Integer(processResult.getOutput());
        }
        catch (ARException aRException) {
            return -9999;
        }
    }

    public static QualifierInfo parseQualification(ARServerUser aRServerUser, String string, String string2, String string3) throws ARException {
        int n = Utilities.getVuiId(aRServerUser, string2, string3);
        List list = aRServerUser.getListFieldObjects(string2);
        ARQualifierHelper aRQualifierHelper = new ARQualifierHelper();
        aRQualifierHelper.generateFieldMaps(list, n, null, null);
        Utilities.loadUserPreference(aRServerUser);
        return aRQualifierHelper.parseQualification(string3, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessResult getLocalizedQual(ARServerUser aRServerUser, String string, int n, String string2, String string3) throws ARException {
        String string4 = aRServerUser.getLocale();
        if (string3 != null && string3.length() > 0) {
            aRServerUser.setLocale(string3);
        }
        try {
            ArrayList<Value> arrayList = new ArrayList<Value>();
            arrayList.add(new Value(20));
            arrayList.add(new Value("\"" + string + "\""));
            arrayList.add(new Value("\"" + (n != 0 ? Integer.valueOf(n) : "") + "\""));
            arrayList.add(new Value(string2));
            ProcessResult processResult = aRServerUser.executeProcessForActiveLink("*RemedyApplicationCommand", 9999, 0, 0, new Timestamp(0L), null, arrayList);
            return processResult;
        }
        finally {
            aRServerUser.setLocale(string4);
        }
    }

    private static QualifierInfo buildUserPrefQualifier(ARServerUser aRServerUser) {
        return new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(OperandType.FIELDID, CoreFieldId.Submitter.getFieldId()), new ArithmeticOrRelationalOperand(new Value(aRServerUser.getUser()))));
    }

    public static void loadUserPreference(ARServerUser aRServerUser) throws ARException {
        List list;
        aRServerUser.setCustomDateFormat(null);
        aRServerUser.setCustomTimeFormat(null);
        if (userPrefForm == null) {
            list = aRServerUser.getListForm(0L, FormType.ALL.toInt() | 0x400, null, PREF_SCHEMA_KEY);
            if (list == null) {
                return;
            }
            userPrefForm = (String)list.get(0);
        }
        if ((list = aRServerUser.getListEntryObjects(userPrefForm, Utilities.buildUserPrefQualifier(aRServerUser), 0, 1, new ArrayList(), USER_PREFERENCE_FIELD_IDS, false, null)) == null) {
            return;
        }
        Entry[] entryArray = list.toArray(new Entry[0]);
        if (entryArray != null && entryArray.length > 0) {
            String string;
            Value value = (Value)entryArray[0].get((Object)USER_PREFERENCE_FIELD_IDS[0]);
            Value value2 = (Value)entryArray[0].get((Object)USER_PREFERENCE_FIELD_IDS[1]);
            if (value != null && value.getValue() != null && (string = value.toString()).length() > 0) {
                aRServerUser.setCustomDateFormat(string);
            }
            if (value2 != null && value2.getValue() != null && (string = value2.getValue().toString()).length() > 0) {
                aRServerUser.setCustomTimeFormat(string);
            }
        }
    }
}

