/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.instrument.classloading.oc4j;

import com.bmc.thirdparty.org.springframework.util.Assert;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import oracle.classloader.util.ClassPreprocessor;

class OC4JClassPreprocessorAdapter
implements ClassPreprocessor {
    private final ClassFileTransformer transformer;

    public OC4JClassPreprocessorAdapter(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        this.transformer = transformer;
    }

    public ClassPreprocessor initialize(ClassLoader loader) {
        return this;
    }

    public byte[] processClass(String className, byte[] origClassBytes, int offset, int length, ProtectionDomain pd, ClassLoader loader) {
        try {
            byte[] tempArray = new byte[length];
            System.arraycopy(origClassBytes, offset, tempArray, 0, length);
            byte[] result = this.transformer.transform(loader, className.replace('.', '/'), null, pd, tempArray);
            return result != null ? result : origClassBytes;
        }
        catch (IllegalClassFormatException ex) {
            throw new IllegalStateException("Cannot transform because of illegal class format", ex);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" for transformer: ");
        builder.append(this.transformer);
        return builder.toString();
    }
}

