/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.client;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PaddedPasswordEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.ws.client.PolicyDetails;
import java.util.List;
import java.util.StringTokenizer;

class ARPolicyLoader {
    static final int FIELD_POLICY_ID = 179;
    static final int FIELD_REQ_SEC_ACTION = 9003;
    static final int FIELD_RES_SEC_ACTION = 9004;
    static final int FIELD_SEC_TOK_REF = 9000;
    static final int FIELD_SIGN_ALIAS = 9005;
    static final int FIELD_SIGN_ALIAS_PASS = 9011;
    static final int FIELD_ENC_ALIAS = 9006;
    static final int FIELD_ENC_ALIAS_PASS = 9009;
    static final int FIELD_PROP_FILE = 9008;
    static final int FIELD_KEYSTORE_FILE = 9007;
    static final int FIELD_HEADER_ENC_FLG = 9019;
    static final int FIELD_ENC_SYM_ALG = 9024;
    static final int FIELD_DISABLE_SIGN_CONFIRM = 9023;
    private ARServerUser arSvrUsr = null;
    private ARPluginContext pluginContext = null;
    private ARPluginInfo pluginInfo = null;
    private String ENC_PASS_KEY = "arwebservicepluginkey";
    static final int[] fieldIds = new int[]{179, 9003, 9004, 9000, 9005, 9011, 9006, 9009, 9008, 9007, 9019, 9024, 9024, 9023};

    ARPolicyLoader(ARPluginContext aRPluginContext, ARPluginInfo aRPluginInfo) {
        this.pluginContext = aRPluginContext;
        this.pluginInfo = aRPluginInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolicyDetails loadPolicyDetails(String string) throws ARException, AREncryptionException {
        PolicyDetails policyDetails = null;
        ARServerUser aRServerUser = null;
        try {
            aRServerUser = this.getARSvrUsr();
            aRServerUser.login();
            policyDetails = this.loadPolicyDetails(aRServerUser, string);
        }
        finally {
            if (aRServerUser != null) {
                aRServerUser.logout();
            }
        }
        return policyDetails;
    }

    private PolicyDetails loadPolicyDetails(ARServerUser aRServerUser, String string) throws ARException, AREncryptionException {
        byte[] byArray;
        Object object;
        String string2;
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand;
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2;
        RelationalOperationInfo relationalOperationInfo;
        QualifierInfo qualifierInfo;
        List list = aRServerUser.getListForm(0L, FormType.REGULAR.toInt(), null, fieldIds);
        if (list == null || list.isEmpty()) {
            throw new ARException(2, 9130, "Web Service security configuration form not found");
        }
        String string3 = (String)list.get(0);
        List list2 = aRServerUser.getListEntryObjects(string3, qualifierInfo = new QualifierInfo(relationalOperationInfo = new RelationalOperationInfo(1, arithmeticOrRelationalOperand2 = new ArithmeticOrRelationalOperand(179), arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(new Value(string)))), 0, 2, null, fieldIds, false, null);
        if (list2 == null || list2.size() == 0) {
            throw new ARException(2, 9130, "Security configuration not found for configuration id:" + string);
        }
        Entry entry = (Entry)list2.get(0);
        PolicyDetails policyDetails = new PolicyDetails();
        policyDetails.setPolicyId(string);
        if (((Value)entry.get((Object)9003)).getValue() != null) {
            string2 = this.getSecurityAction((String)((Value)entry.get((Object)9003)).getValue());
            policyDetails.setRequestSecurityAction(string2);
        }
        if (((Value)entry.get((Object)9004)).getValue() != null) {
            string2 = this.getSecurityAction((String)((Value)entry.get((Object)9004)).getValue());
            policyDetails.setResponseSecurityAction(string2);
        }
        string2 = this.getKeyIdentifier((Integer)((Value)entry.get((Object)9000)).getValue());
        policyDetails.setSignKeyID(string2);
        policyDetails.setEncKeyID(string2);
        if (((Value)entry.get((Object)9005)).getValue() != null) {
            policyDetails.setUserAlias((String)((Value)entry.get((Object)9005)).getValue());
        }
        if (((Value)entry.get((Object)9006)).getValue() != null) {
            policyDetails.setEncryptionUserAlias((String)((Value)entry.get((Object)9006)).getValue());
        }
        PaddedPasswordEncryption paddedPasswordEncryption = new PaddedPasswordEncryption(true, true);
        paddedPasswordEncryption.setPasswordKeyForEncryption(this.ENC_PASS_KEY.getBytes());
        if (((Value)entry.get((Object)9011)).getValue() != null) {
            object = (String)((Value)entry.get((Object)9011)).getValue();
            byArray = paddedPasswordEncryption.decryptCharData(((String)object).getBytes());
            policyDetails.setUserAliasPassword(new String(byArray));
        }
        if (((Value)entry.get((Object)9009)).getValue() != null) {
            object = (String)((Value)entry.get((Object)9009)).getValue();
            byArray = paddedPasswordEncryption.decryptCharData(((String)object).getBytes());
            policyDetails.setEncryptionUserAliasPassword(new String(byArray));
        }
        if (((Value)entry.get((Object)9019)).getValue() != null) {
            policyDetails.setHeaderEncFlag(true);
        }
        if (((Value)entry.get((Object)9024)).getValue() != null && (Integer)(object = (Integer)((Value)entry.get((Object)9024)).getValue()) > 0) {
            if ((Integer)object == 1) {
                policyDetails.setEncSymAlg("AES_192");
            }
            if ((Integer)object == 2) {
                policyDetails.setEncSymAlg("AES_256");
            }
            if ((Integer)object == 3) {
                policyDetails.setEncSymAlg("Triple DES");
            }
        }
        object = this.storePolicyFiles(this.pluginContext, aRServerUser, entry, 9008, string3);
        policyDetails.setPropBytes((byte[])object);
        object = this.storePolicyFiles(this.pluginContext, aRServerUser, entry, 9007, string3);
        policyDetails.setKsBytes((byte[])object);
        if (((Value)entry.get((Object)9023)).getValue() != null) {
            policyDetails.setSignConfirm(true);
        }
        this.pluginContext.logMessage(this.pluginInfo, 0, "Policy Details:" + policyDetails);
        return policyDetails;
    }

    private String getSecurityAction(String string) throws ARException {
        String string2 = "";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("Signature")) {
                string3 = "Signature";
            }
            if (string2.equals("Encrypt")) {
                string4 = "Encrypt";
            }
            if (!string2.equals("Timestamp")) continue;
            string5 = "Timestamp";
        }
        string2 = null;
        if (string5 != null) {
            string2 = string5;
        }
        if (string3 != null) {
            string2 = string2 == null ? string3 : string2 + " " + string3;
        }
        if (string4 != null) {
            string2 = string2 == null ? string4 : string2 + " " + string4;
        }
        return string2;
    }

    private String getKeyIdentifier(int n) throws ARException {
        switch (n) {
            case 0: {
                return "DirectReference";
            }
            case 1: {
                return "IssuerSerial";
            }
        }
        throw new ARException(2, 9130, "Invalid Key Identifier index:" + n);
    }

    private byte[] storePolicyFiles(ARPluginContext aRPluginContext, ARServerUser aRServerUser, Entry entry, int n, String string) throws ARException {
        byte[] byArray = aRServerUser.getEntryBlob(string, entry.getEntryId(), n);
        return byArray;
    }

    private ARServerUser getARSvrUsr() throws ARException {
        if (this.arSvrUsr == null) {
            String string = this.pluginContext.getARConfigEntry("Server-Name");
            int n = Integer.parseInt(this.pluginContext.getARConfigEntry("TCD-Specific-Port"));
            this.arSvrUsr = new ARServerUser((ARNativeAuthenticationInfo)this.pluginContext, "", string);
            this.arSvrUsr.setPort(n);
        }
        return this.arSvrUsr;
    }
}

