/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcBroadcastEvent;
import org.acplt.oncrpc.OncRpcBroadcastListener;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.OncRpcUdpSocketHelper;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrUdpDecodingStream;
import org.acplt.oncrpc.XdrUdpEncodingStream;

public class OncRpcUdpClient
extends OncRpcClient {
    private DatagramSocket socket;
    private OncRpcUdpSocketHelper socketHelper;
    protected XdrUdpEncodingStream sendingXdr;
    protected XdrUdpDecodingStream receivingXdr;
    protected int retransmissionTimeout;
    protected int retransmissionMode;

    public OncRpcUdpClient(InetAddress inetAddress, int n2, int n3, int n4) throws OncRpcException, IOException {
        this(inetAddress, n2, n3, n4, 8192);
    }

    public OncRpcUdpClient(InetAddress inetAddress, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        super(inetAddress, n2, n3, n4, 17);
        this.retransmissionTimeout = this.timeout;
        this.retransmissionMode = 1;
        if (n5 < 1024) {
            n5 = 1024;
        }
        this.socket = new DatagramSocket();
        this.socketHelper = new OncRpcUdpSocketHelper(this.socket);
        if (this.socketHelper.getSendBufferSize() < n5) {
            this.socketHelper.setSendBufferSize(n5);
        }
        if (this.socketHelper.getReceiveBufferSize() < n5) {
            this.socketHelper.setReceiveBufferSize(n5);
        }
        this.sendingXdr = new XdrUdpEncodingStream(this.socket, n5);
        this.receivingXdr = new XdrUdpDecodingStream(this.socket, n5);
    }

    public void close() throws OncRpcException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    public synchronized void call(int n2, int n3, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        block16: for (int i2 = 1; i2 >= 0; --i2) {
            this.nextXid();
            OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, n3, n2, this.auth);
            OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
            long l2 = System.currentTimeMillis() + (long)this.timeout;
            int n4 = this.retransmissionTimeout;
            do {
                try {
                    this.sendingXdr.beginEncoding(this.host, this.port);
                    oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
                    xdrAble.xdrEncode(this.sendingXdr);
                    this.sendingXdr.endEncoding();
                }
                catch (IOException iOException) {
                    throw new OncRpcException(3, iOException.getLocalizedMessage());
                }
                if (this.timeout == 0) {
                    return;
                }
                while (true) {
                    block24: {
                        try {
                            int n5 = (int)(l2 - System.currentTimeMillis());
                            if (n5 > n4) {
                                n5 = n4;
                            } else if (n5 < 0) {
                                n5 = 0;
                            }
                            this.socket.setSoTimeout(n5);
                            this.receivingXdr.beginDecoding();
                            if (!this.host.equals(this.receivingXdr.getSenderAddress())) break block24;
                            try {
                                oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                            }
                            catch (OncRpcException oncRpcException) {
                                this.receivingXdr.endDecoding();
                                throw oncRpcException;
                            }
                            if (oncRpcClientReplyMessage.messageId != oncRpcClientCallMessage.messageId) break block24;
                            if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                                this.receivingXdr.endDecoding();
                                if (i2 > 0 && oncRpcClientReplyMessage.replyStatus == 1 && oncRpcClientReplyMessage.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue block16;
                                throw oncRpcClientReplyMessage.newException();
                            }
                            try {
                                xdrAble2.xdrDecode(this.receivingXdr);
                            }
                            catch (OncRpcException oncRpcException) {
                                this.receivingXdr.endDecoding();
                                throw oncRpcException;
                            }
                            this.receivingXdr.endDecoding();
                            return;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            break;
                        }
                        catch (IOException iOException) {
                            try {
                                this.receivingXdr.endDecoding();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            throw new OncRpcException(4, iOException.getLocalizedMessage());
                        }
                        catch (OncRpcException oncRpcException) {
                            try {
                                this.receivingXdr.endDecoding();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (oncRpcException.getReason() == 44) break block24;
                            throw oncRpcException;
                        }
                    }
                    try {
                        this.receivingXdr.endDecoding();
                    }
                    catch (IOException iOException) {
                        throw new OncRpcException(4, iOException.getLocalizedMessage());
                    }
                }
                if (this.retransmissionMode != 0) continue;
                n4 *= 2;
            } while (System.currentTimeMillis() < l2);
            throw new OncRpcTimeoutException();
        }
    }

    public synchronized void broadcastCall(int n2, XdrAble xdrAble, XdrAble xdrAble2, OncRpcBroadcastListener oncRpcBroadcastListener) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, this.version, n2, this.auth);
        OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
        try {
            this.sendingXdr.beginEncoding(this.host, this.port);
            oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
            xdrAble.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding();
        }
        catch (IOException iOException) {
            throw new OncRpcException(3, iOException.getLocalizedMessage());
        }
        long l2 = System.currentTimeMillis() + (long)this.timeout;
        do {
            try {
                int n3 = (int)(l2 - System.currentTimeMillis());
                if (n3 < 0) {
                    n3 = 0;
                }
                this.socket.setSoTimeout(n3);
                this.receivingXdr.beginDecoding();
                oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                if (oncRpcClientReplyMessage.messageId == oncRpcClientCallMessage.messageId) {
                    if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                        this.receivingXdr.endDecoding();
                    }
                    xdrAble2.xdrDecode(this.receivingXdr);
                    if (oncRpcBroadcastListener != null) {
                        OncRpcBroadcastEvent oncRpcBroadcastEvent = new OncRpcBroadcastEvent(this, this.receivingXdr.getSenderAddress(), n2, xdrAble, xdrAble2);
                        oncRpcBroadcastListener.replyReceived(oncRpcBroadcastEvent);
                    }
                    this.receivingXdr.endDecoding();
                    continue;
                }
                try {
                    this.receivingXdr.endDecoding();
                }
                catch (IOException iOException) {
                    throw new OncRpcException(4, iOException.getLocalizedMessage());
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                throw new OncRpcException(4, iOException.getLocalizedMessage());
            }
        } while (System.currentTimeMillis() < l2);
    }

    public void setRetransmissionMode(int n2) {
        this.retransmissionMode = n2;
    }

    public int getRetransmissionMode() {
        return this.retransmissionMode;
    }

    public void setRetransmissionTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("timeouts must be positive.");
        }
        this.retransmissionTimeout = n2;
    }

    public int getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public void setCharacterEncoding(String string) {
        this.receivingXdr.setCharacterEncoding(string);
        this.sendingXdr.setCharacterEncoding(string);
    }

    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }
}

