/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.support;

import com.bmc.thirdparty.org.springframework.beans.factory.support.MethodOverride;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MethodOverrides {
    private final Set overrides = new HashSet();

    public MethodOverrides() {
    }

    public MethodOverrides(MethodOverrides other) {
        this.addOverrides(other);
    }

    public void addOverrides(MethodOverrides other) {
        if (other != null) {
            this.overrides.addAll(other.getOverrides());
        }
    }

    public void addOverride(MethodOverride override) {
        this.overrides.add(override);
    }

    public Set getOverrides() {
        return this.overrides;
    }

    public boolean isEmpty() {
        return this.overrides.isEmpty();
    }

    public MethodOverride getOverride(Method method) {
        Iterator it = this.overrides.iterator();
        while (it.hasNext()) {
            MethodOverride methodOverride = (MethodOverride)it.next();
            if (!methodOverride.matches(method)) continue;
            return methodOverride;
        }
        return null;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MethodOverrides that = (MethodOverrides)o2;
        return ((Object)this.overrides).equals(that.overrides);
    }

    public int hashCode() {
        return ((Object)this.overrides).hashCode();
    }
}

