/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework;

import com.bmc.thirdparty.org.springframework.aop.framework.Advised;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisedSupport;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisorChainFactory;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisorChainFactoryUtils;
import com.bmc.thirdparty.org.springframework.core.CollectionFactory;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public final class HashMapCachingAdvisorChainFactory
implements AdvisorChainFactory {
    private final Map methodCache = CollectionFactory.createIdentityMapIfPossible(32);

    public List getInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
        List cached = (List)this.methodCache.get(method);
        if (cached == null) {
            cached = AdvisorChainFactoryUtils.calculateInterceptorsAndDynamicInterceptionAdvice(config, proxy, method, targetClass);
            this.methodCache.put(method, cached);
        }
        return cached;
    }

    public void activated(AdvisedSupport advisedSupport) {
    }

    public void adviceChanged(AdvisedSupport advisedSupport) {
        this.methodCache.clear();
    }
}

