/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.nio.ArClientRequestHandler;
import com.bmc.arsys.arrpc.nio.ArRpcCallHandler;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ArSelectorThread
implements Runnable {
    private static Logger do = Logger.getLogger(ArSelectorThread.class);
    private Selector a;
    private CopyOnWriteArrayList<ArRpcCallHandler> if = new CopyOnWriteArrayList();

    public ArSelectorThread() throws IOException {
        this.a = Selector.open();
    }

    public void addHandler(ArRpcCallHandler arRpcCallHandler) throws IOException, ClosedChannelException {
        this.if.add(arRpcCallHandler);
        this.a.wakeup();
    }

    private void a() throws IOException {
        if (this.if.size() > 0) {
            Iterator<ArRpcCallHandler> iterator = this.if.iterator();
            this.if.clear();
            while (iterator.hasNext()) {
                ArRpcCallHandler arRpcCallHandler = iterator.next();
                try {
                    do.debug("Registering a new rpc call handler " + arRpcCallHandler.hashCode() + " for selector " + this.a.hashCode());
                    arRpcCallHandler.register(this.a);
                }
                catch (Exception exception) {
                    do.error("Registering new Handler failed " + exception.getLocalizedMessage());
                    arRpcCallHandler.close();
                }
            }
        }
    }

    private void a(SelectionKey selectionKey) {
        ArClientRequestHandler arClientRequestHandler = (ArClientRequestHandler)selectionKey.attachment();
        do.debug("dispatch SelectionKey " + selectionKey.hashCode() + " to attached request handler: " + (arClientRequestHandler == null ? null : Integer.valueOf(arClientRequestHandler.hashCode())));
        if (arClientRequestHandler != null) {
            arClientRequestHandler.handleRequest(selectionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do.debug("Starting new Selector thread with id " + this.a.hashCode());
        try {
            while (!Thread.interrupted()) {
                try {
                    Set<SelectionKey> set;
                    int n2 = this.a.select();
                    this.registerForRead(false, null, false);
                    if (n2 == 0) {
                        this.a();
                        continue;
                    }
                    do.trace("Selector " + this.a.hashCode() + " reacting...");
                    Set<SelectionKey> set2 = set = this.a.selectedKeys();
                    synchronized (set2) {
                        Iterator<SelectionKey> iterator = set.iterator();
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        while (iterator.hasNext()) {
                            SelectionKey selectionKey = iterator.next();
                            try {
                                if (!selectionKey.isValid() || !selectionKey.isReadable()) continue;
                                if (!arrayList.contains(selectionKey.attachment())) {
                                    arrayList.add(selectionKey.attachment());
                                    this.a(selectionKey);
                                    continue;
                                }
                                do.trace("Same selector " + selectionKey.selector().hashCode() + " reacted more than one events...");
                            }
                            catch (CancelledKeyException cancelledKeyException) {
                                do.trace(cancelledKeyException.getLocalizedMessage());
                            }
                        }
                        arrayList.clear();
                        set.clear();
                        do.trace("Selector " + this.a.hashCode() + " done react.");
                    }
                }
                catch (Throwable throwable) {
                    do.error("Exception in selector thread loop. Shutting down selector thread" + Thread.currentThread().getId(), throwable);
                }
            }
        }
        finally {
            do.debug("Closing a selector thread with id " + this.a.hashCode());
            this.close();
        }
    }

    public void close() {
        try {
            this.a.close();
            this.if.clear();
        }
        catch (Throwable throwable) {
            do.error(throwable.getLocalizedMessage());
        }
    }

    public void registerForRead(boolean bl, SelectionKey selectionKey, boolean bl2) {
        if (bl && selectionKey != null) {
            do.trace("+++++++++++++++++++++registerForRead " + bl + " " + bl2 + " " + selectionKey.hashCode());
            selectionKey.selector().wakeup();
            do.trace("+++++++++++++++++++++registerForRead woke up Selector for OP_READ");
            int n2 = selectionKey.interestOps();
            int n3 = selectionKey.interestOps() | 1;
            selectionKey.interestOps(n3);
            do.trace("+++++++++++++++++++++registerForRead has set from " + n2 + " to " + n3 + " for selector " + selectionKey.selector().hashCode() + " SelectionKey " + selectionKey.hashCode());
            if (bl2) {
                selectionKey.selector().wakeup();
                do.trace("+++++++++++++++++++++registerForRead wakeUpSelector done for next event.");
            }
        }
    }

    public void unregisterForRead(SelectionKey selectionKey) {
        if (selectionKey != null) {
            do.trace("=====================unregisterForRead. Focus on current event.");
            selectionKey.selector().wakeup();
            do.trace("=====================unregisterForRead woke up Selector for ~OP_READ");
            int n2 = selectionKey.interestOps();
            int n3 = selectionKey.interestOps() & 0xFFFFFFFE;
            selectionKey.interestOps(n3);
            do.trace("=====================unregisterForRead has set from " + n2 + " to " + n3 + " for selector " + selectionKey.selector().hashCode() + " SelectionKey " + selectionKey.hashCode());
        }
    }
}

