/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.binding.ARPluginSvrThreadPoolExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARWorkQueueMonitor
implements Runnable {
    private static Logger log = Logger.getLogger(ARWorkQueueMonitor.class);
    ARPluginSvrThreadPoolExecutor executor;
    ThreadFactory threadFactory;
    BlockingQueue<?> workQueue;
    int workQueueTaskThreshold = ARPluginServerConfiguration.getInstance().getWorkQueueTaskThreshold();

    public ARWorkQueueMonitor(ARPluginSvrThreadPoolExecutor aRPluginSvrThreadPoolExecutor, ThreadFactory threadFactory, BlockingQueue<?> blockingQueue) {
        this.executor = aRPluginSvrThreadPoolExecutor;
        this.threadFactory = threadFactory;
        this.workQueue = blockingQueue;
    }

    @Override
    public void run() {
        while (!this.executor.isReadyForRpcCall()) {
        }
        int n = 0;
        while (true) {
            long l;
            if ((l = ARPluginServerConfiguration.getInstance().getWorkQueueMonitorLogInterval()) <= 0L || l == Long.MAX_VALUE || !this.executor.isReadyForRpcCall() || (n = this.workQueue.size()) <= this.workQueueTaskThreshold) {
                continue;
            }
            log.info((Object)("Alerts: Work queue has " + n + " tasks."));
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }
}

