/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.mvc.multiaction;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import com.bmc.thirdparty.org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import com.bmc.thirdparty.org.springframework.web.util.UrlPathHelper;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractUrlMethodNameResolver
implements MethodNameResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public final String getHandlerMethodName(HttpServletRequest request) throws NoSuchRequestHandlingMethodException {
        String urlPath = this.urlPathHelper.getLookupPathForRequest(request);
        String name = this.getHandlerMethodNameForUrlPath(urlPath);
        if (name == null) {
            throw new NoSuchRequestHandlingMethodException(request);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Returning handler method name '" + name + "' for lookup path: " + urlPath);
        }
        return name;
    }

    protected abstract String getHandlerMethodNameForUrlPath(String var1);
}

