/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.Image;
import com.bmc.arsys.api.ImageCriteria;
import com.bmc.arsys.api.ImageData;
import com.bmc.arsys.api.ObjectBase;
import com.bmc.arsys.api.PropertyMap;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.ReferenceType;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewCriteria;
import com.bmc.arsys.api.ViewDisplayPropertyMap;
import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.OutputWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageExtractor
extends JavaDriver {
    static OutputWriter outputWriter = new OutputWriter();
    ARServerUser arServerUser;
    int totalImages;
    int totalDistinctImages;
    long memorySaving;
    long totalDistinctImageSize;
    ArrayList<String> schemaNames;
    HashMap<Long, String> imageMap;
    Checksum checksumEngine;
    long curImageChecksum;
    int imageChunkSize;

    public ImageExtractor() {
        this.initThreadControlBlockPtr();
        this.schemaNames = new ArrayList();
        this.imageMap = new HashMap();
        this.totalImages = 0;
        this.totalDistinctImages = 0;
        this.checksumEngine = new Adler32();
        this.curImageChecksum = 0L;
        this.memorySaving = 0L;
        this.totalDistinctImageSize = 0L;
        String string = System.getProperty("ImageChunkSize");
        if (string == null) {
            this.imageChunkSize = 20;
        } else {
            Integer n = new Integer(string);
            this.imageChunkSize = n;
        }
    }

    public long getTotalImageSize() {
        return this.totalDistinctImageSize;
    }

    public long getMemorySaving() {
        return this.memorySaving;
    }

    public int getTotalImageCount() {
        return this.totalImages;
    }

    public int getDistinctImageCount() {
        return this.totalDistinctImages;
    }

    public int getSchemaCount() {
        return this.schemaNames.size();
    }

    long calculateChecksum(byte[] byArray) {
        this.checksumEngine.reset();
        this.checksumEngine.update(byArray, 0, byArray.length);
        return this.checksumEngine.getValue();
    }

    void populateImageList() throws ARException {
        outputWriter.printHeader("", "Using image chunk value : " + this.imageChunkSize + ".", "\n");
        List<String> list = null;
        list = this.arServerUser.getListImage();
        if (list == null) {
            return;
        }
        int n = list.size();
        outputWriter.printHeader("", "There are  " + n + " images in the system.", "\n");
        int n2 = n / this.imageChunkSize;
        int n3 = n % this.imageChunkSize;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            this.processExistingImages(list.subList(n4, n4 + this.imageChunkSize));
            n4 += this.imageChunkSize;
        }
        this.processExistingImages(list.subList(n4, n4 + n3));
    }

    private void processExistingImages(List<String> list) throws ARException {
        List<Image> list2 = null;
        ImageCriteria imageCriteria = new ImageCriteria();
        imageCriteria.setRetrieveAll(true);
        list2 = this.arServerUser.getListImageObjects(list, imageCriteria);
        if (list2 == null) {
            return;
        }
        Adler32 adler32 = new Adler32();
        for (int i = 0; i < list2.size(); ++i) {
            Image image = list2.get(i);
            byte[] byArray = image.getImageData().getValue();
            this.totalDistinctImageSize += (long)byArray.length;
            adler32.update(byArray, 0, byArray.length);
            long l = adler32.getValue();
            this.imageMap.put(new Long(l), image.getName());
            adler32.reset();
        }
    }

    void readSchemaNames(String string, boolean bl) throws ARException, FileNotFoundException, IOException {
        if (string == null || string.length() == 0) {
            this.schemaNames = (ArrayList)this.arServerUser.getListForm(0L);
        } else if (bl) {
            this.populateSchemaNamesUsingApplicationNames(string);
        } else {
            this.populateSchemaNamesFromFile(string);
        }
    }

    private void populateSchemaNamesFromFile(String string) throws FileNotFoundException, IOException {
        JavaDriver.getThreadControlBlockPtr().setCurrentInputFile(string);
        String string2 = null;
        BufferedReader bufferedReader = JavaDriver.getThreadControlBlockPtr().getCurrentInputFile();
        string2 = bufferedReader.readLine();
        while (string2 != null) {
            int n = 0;
            for (n = string2.length() - 1; n >= 0 && string2.charAt(n) == ' ' && string2.charAt(n) == '\t' && string2.charAt(n) == '\n'; --n) {
            }
            if (string2.length() >= 1 && string2.charAt(0) == '#') continue;
            this.schemaNames.add(string2);
            string2 = bufferedReader.readLine();
        }
        JavaDriver.getThreadControlBlockPtr().closeCurrentInputFile();
    }

    private void populateSchemaNamesUsingApplicationNames(String string) throws ARException, FileNotFoundException, IOException {
        JavaDriver.getThreadControlBlockPtr().setCurrentInputFile(string);
        String string2 = null;
        BufferedReader bufferedReader = JavaDriver.getThreadControlBlockPtr().getCurrentInputFile();
        string2 = bufferedReader.readLine();
        while (string2 != null) {
            int n = 0;
            for (n = string2.length() - 1; n >= 0 && string2.charAt(n) == ' ' && string2.charAt(n) == '\t' && string2.charAt(n) == '\n'; --n) {
            }
            if (string2.length() >= 1 && string2.charAt(0) == '#') continue;
            Container container = this.arServerUser.getContainer(string2);
            List<Reference> list = container.getReferences();
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getReferenceType() != ReferenceType.APPLICATION_FORMS || list.get(++i).getReferenceType() != ReferenceType.SCHEMA) continue;
                this.schemaNames.add(list.get(i).getName());
            }
            string2 = bufferedReader.readLine();
        }
        JavaDriver.getThreadControlBlockPtr().closeCurrentInputFile();
    }

    boolean isUniqueImageObject(byte[] byArray) {
        this.curImageChecksum = this.calculateChecksum(byArray);
        if (this.imageMap.get(new Long(this.curImageChecksum)) == null) {
            this.totalDistinctImageSize += (long)byArray.length;
            return true;
        }
        this.memorySaving += (long)byArray.length;
        return false;
    }

    void processNewImageObject(String string, byte[] byArray) throws ARException {
        Image image = new Image(string);
        ImageData imageData = new ImageData(byArray);
        image.setImageData(imageData);
        image.setType("jpg");
        image.setDescription("Extracted by Image Utility version 1.0");
        image.setOwner(this.arServerUser.getUser());
        this.arServerUser.createImage(image);
    }

    void processSchemaList() {
        String string = null;
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            string = this.schemaNames.get(i);
            if (string == null) continue;
            outputWriter.printHeader("", "Currently processing Form " + string + "...", "\n");
            try {
                this.processViews(string);
                this.processFields(string);
                continue;
            }
            catch (ARException aRException) {
                outputWriter.printHeader("", "Error while processing schema " + string + ".", "\n");
                outputWriter.printHeader("", "Error message " + aRException.getMessage() + ".", "\n");
            }
        }
    }

    private void processViews(String string) throws ARException {
        ViewCriteria viewCriteria = new ViewCriteria();
        viewCriteria.setPropertiesToRetrieve(ViewCriteria.PROPERTY_LIST);
        List<View> list = this.arServerUser.getListViewObjects(string, 0L, viewCriteria);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2;
            boolean bl;
            ViewDisplayPropertyMap viewDisplayPropertyMap;
            View view = list.get(i);
            if (view == null || (viewDisplayPropertyMap = view.getDisplayProperties()) == null || !(bl = this.processPropertyMap(string2 = string + "_" + view.getName(), viewDisplayPropertyMap))) continue;
            view.setDisplayProperties(viewDisplayPropertyMap);
            this.arServerUser.setView(view);
        }
    }

    private boolean processPropertyMap(String string, PropertyMap propertyMap) throws ARException {
        boolean bl = false;
        for (Integer n : propertyMap.keySet()) {
            Object object;
            Value value = (Value)propertyMap.get((int)n);
            DataType dataType = value.getDataType();
            if (dataType == null || dataType.toInt() != 9) continue;
            Object object2 = null;
            ByteListValue byteListValue = (ByteListValue)value.getValue();
            byte[] byArray = byteListValue.getValue();
            if (this.isUniqueImageObject(byArray)) {
                ++this.totalDistinctImages;
                object2 = string + "_" + this.curImageChecksum;
                object = ((String)object2).replace(':', '_');
                this.processNewImageObject((String)object, byArray);
                this.imageMap.put(new Long(this.curImageChecksum), (String)object);
                object2 = object;
            } else {
                object2 = this.imageMap.get(new Long(this.curImageChecksum));
            }
            if (object2 == null) continue;
            object = new Value((String)object2, DataType.CHAR);
            propertyMap.put(n, object);
            bl = true;
            ++this.totalImages;
        }
        return bl;
    }

    private void processFields(String string) throws ARException {
        List<Field> list = null;
        try {
            list = this.arServerUser.getListFieldObjects(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Error while processing fields on the form " + string);
            return;
        }
        if (list == null) {
            return;
        }
        String string2 = null;
        for (int i = 0; i < list.size(); ++i) {
            boolean bl = false;
            Field field = list.get(i);
            if (field == null) continue;
            string2 = string + "_" + field.getName();
            DisplayInstanceMap displayInstanceMap = field.getDisplayInstance();
            if (displayInstanceMap == null) continue;
            PropertyMap propertyMap = null;
            for (Integer n : displayInstanceMap.keySet()) {
                propertyMap = (PropertyMap)displayInstanceMap.get((int)n);
                if (propertyMap == null) continue;
                bl = this.processPropertyMap(string2, propertyMap);
            }
            if (!bl) continue;
            field.setDisplayInstance(displayInstanceMap);
            this.arServerUser.setField(field);
        }
    }

    void verifyImages() {
        outputWriter.printHeader("", "\nVerifying the extracted image name references, Please wait....", "\n");
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            try {
                Object object;
                Serializable serializable;
                Object object2;
                Cloneable cloneable;
                outputWriter.printHeader("", "\nVerifying the image name references in schema : " + this.schemaNames.get(i), "");
                ViewCriteria viewCriteria = new ViewCriteria();
                viewCriteria.setPropertiesToRetrieve(ViewCriteria.PROPERTY_LIST);
                List<View> list = this.arServerUser.getListViewObjects(this.schemaNames.get(i), 0L, viewCriteria);
                for (int j = 0; j < list.size(); ++j) {
                    View view = list.get(j);
                    cloneable = view.getDisplayProperties();
                    object2 = ((TreeMap)cloneable).keySet().iterator();
                    while (object2.hasNext()) {
                        serializable = (Integer)object2.next();
                        int n = (Integer)serializable;
                        Serializable serializable2 = (Value)((TreeMap)cloneable).get(n);
                        if (n != 100 && n != 101 && n != 167 && n != 200 || ((Value)serializable2).getDataType().toInt() != 4 || this.isImagePresentInServer((String)(object = ((Value)serializable2).getValue().toString()))) continue;
                        outputWriter.printHeader("", "\nImage : " + (String)object, " is associated with View : " + view.getName() + " couldn't not be verified");
                    }
                }
                List<Field> list2 = this.arServerUser.getListFieldObjects(this.schemaNames.get(i));
                for (int j = 0; j < list2.size(); ++j) {
                    cloneable = list2.get(j);
                    if (cloneable == null || (object2 = ((Field)cloneable).getDisplayInstance()) == null) continue;
                    serializable = null;
                    for (Serializable serializable2 : ((TreeMap)object2).keySet()) {
                        serializable = (PropertyMap)((TreeMap)object2).get((Integer)serializable2);
                        if (serializable == null) continue;
                        object = ((TreeMap)serializable).keySet().iterator();
                        while (object.hasNext()) {
                            String string;
                            Integer n = (Integer)object.next();
                            Value value = (Value)((TreeMap)serializable).get((int)n);
                            DataType dataType = value.getDataType();
                            if (dataType == null || n != 100 && n != 101 && n != 167 && n != 200 || value.getDataType().toInt() != 4 || this.isImagePresentInServer(string = value.getValue().toString())) continue;
                            outputWriter.printHeader("", "\nImage : " + string, " is associated with Field : " + ((ObjectBase)cloneable).getName() + " couldn't not be verified");
                        }
                    }
                }
                continue;
            }
            catch (Exception exception) {
                outputWriter.printString("\nError : " + exception.toString() + "verifying schema " + this.schemaNames.get(i));
            }
        }
        outputWriter.printHeader("\n", "\nCompleted verification of extracted images.", "\n");
    }

    boolean isImagePresentInServer(String string) throws ARException {
        List<Image> list = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.length() == 0) {
            return false;
        }
        arrayList.add(string);
        ImageCriteria imageCriteria = new ImageCriteria();
        imageCriteria.setRetrieveAll(true);
        try {
            list = this.arServerUser.getListImageObjects(arrayList, imageCriteria);
            if (list == null) {
                outputWriter.printHeader("\n", "\nCouldn't find image " + string + " in server.", "\n");
                return false;
            }
        }
        catch (ARException aRException) {
            outputWriter.printHeader("\n", "\nError" + aRException.toString() + " getting image " + string + " from server.", "\n");
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Image image = list.get(i);
            if (image.getImageData().getValue().length != 0) continue;
            outputWriter.printHeader("\n", "\nImage " + string + " contains zero byte.", "\n");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        block14: {
            ImageExtractor imageExtractor = null;
            boolean bl = true;
            imageExtractor = new ImageExtractor();
            JavaDriver.getThreadControlBlockPtr().setPrimaryThread(true);
            JavaDriver.getThreadControlBlockPtr().setCurrentInputToStdIn();
            JavaDriver.getThreadControlBlockPtr().setOutputToStdOut();
            String string = InputReader.getString("Server Host:", "localhost");
            int n = InputReader.getInt("Server Port:", 0);
            String string2 = InputReader.getString("User Name:", "Demo");
            String string3 = InputReader.getString("Password:", "");
            String string4 = null;
            InputReader.setNullPromptOption(true);
            String string5 = InputReader.getString("Would you like to use application names(Yes/No)?", "Yes");
            bl = string5.equals("Yes") || string5.equals("yes");
            String string6 = null;
            string6 = bl ? InputReader.getString("Input File containing the application names :", "") : InputReader.getString("Input File containing the form names :", "");
            imageExtractor.arServerUser = new ARServerUser(string2, string3, string4, string, n);
            imageExtractor.arServerUser.login();
            Calendar calendar = Calendar.getInstance();
            long l = calendar.getTimeInMillis();
            imageExtractor.populateImageList();
            imageExtractor.readSchemaNames(string6, bl);
            if (bl) {
                outputWriter.printHeader("", "Processing " + imageExtractor.getSchemaCount() + " forms belonging to specified application(s).", "\n");
            } else {
                outputWriter.printHeader("", "Processing " + imageExtractor.getSchemaCount() + " Forms.", "\n");
            }
            imageExtractor.processSchemaList();
            imageExtractor.verifyImages();
            calendar = Calendar.getInstance();
            long l2 = calendar.getTimeInMillis();
            long l3 = (l2 - l) / 1000L;
            outputWriter.printHeader("", "\n", "\n");
            outputWriter.printHeader("", "Current Run Report         \n", "\n");
            outputWriter.printHeader("", "==========================================", "\n");
            outputWriter.printHeader("", "Total Images                 : " + imageExtractor.getTotalImageCount(), "\n");
            outputWriter.printHeader("", "Distinct Images              : " + imageExtractor.getDistinctImageCount(), "\n");
            outputWriter.printHeader("", "Total Saving     ( In bytes) : " + imageExtractor.getMemorySaving(), "\n");
            outputWriter.printHeader("", "Processing Completed in " + l3 + " seconds.", "\n");
            outputWriter.printHeader("", "==========================================", "\n");
            Object var18_15 = null;
            try {
                imageExtractor.arServerUser.logout();
                Object var21_18 = null;
            }
            catch (Throwable throwable) {
                Object var21_20 = null;
                System.exit(0);
                throw throwable;
            }
            System.exit(0);
            {
                break block14;
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var21_19 = null;
                    System.exit(0);
                    break block14;
                }
            }
            {
                catch (Exception exception) {
                    outputWriter.printString("Error in executing the command\n");
                    exception.printStackTrace();
                    Object var18_16 = null;
                    try {
                        imageExtractor.arServerUser.logout();
                        Object var21_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_23 = null;
                        System.exit(0);
                        throw throwable;
                    }
                    System.exit(0);
                    {
                        break block14;
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                            Object var21_22 = null;
                            System.exit(0);
                            break block14;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block15: {
                    Object var18_17 = null;
                    try {
                        imageExtractor.arServerUser.logout();
                        Object var21_24 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var21_26 = null;
                        System.exit(0);
                        throw throwable2;
                    }
                    System.exit(0);
                    {
                        break block15;
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var21_25 = null;
                            System.exit(0);
                        }
                    }
                }
                throw throwable;
            }
        }
    }
}

