/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.mapping;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.mapping.ARSOperation;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ARSPort {
    protected Element element;
    protected String name;
    protected String targetNamespace;
    protected String locationURI;
    protected HashMap<String, ARSOperation> operations = new HashMap();
    protected LinkedList<ARSOperation> operationsList = new LinkedList();
    protected HashMap<String, ARSMapping> mappings = new HashMap();
    protected LinkedList<ARSMapping> mappingsList = new LinkedList();
    protected String bindingStyle = "document";
    protected String useStyle = "literal";

    public String getName() {
        return this.name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public Collection getOperations() {
        return this.operationsList;
    }

    public Collection getMappings() {
        return this.mappingsList;
    }

    public ARSOperation getOperation(String string) {
        return this.operations.get(string);
    }

    public ARSMapping getMapping(String string) {
        return this.mappings.get(string);
    }

    public String getBindingStyle() {
        return this.bindingStyle;
    }

    public String getUseStyle() {
        return this.useStyle;
    }

    public ARSPort(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.locationURI = string2;
        this.bindingStyle = string4;
        this.useStyle = string5;
        this.element = null;
        this.targetNamespace = string3;
    }

    public ARSPort(Element element, String string) {
        this.element = element;
        this.parseXML(string);
    }

    public ARSPort(ARSPort aRSPort, String string, String string2, StringBuffer stringBuffer) {
        XMLSchemaParser xMLSchemaParser = new XMLSchemaParser(string, stringBuffer);
        Document document = WsdlUtil.newDocument();
        document.appendChild(document.importNode(aRSPort.element, true));
        this.element = document.getDocumentElement();
        this.parseXML(string2);
        NodeList nodeList = this.element.getElementsByTagNameNS(null, "externalSchema");
        if (nodeList != null && nodeList.getLength() > 0) {
            ((Element)nodeList.item(0)).setAttributeNS(null, "name", string);
        }
        for (int i = 0; i < this.mappingsList.size(); ++i) {
            ARSMapping aRSMapping = this.mappingsList.get(i);
            ARSMapping aRSMapping2 = aRSPort.getMapping(aRSMapping.getName());
            ARSMapping aRSMapping3 = null;
            try {
                QName qName;
                if (aRSMapping2.getMappingMode() == 3) {
                    qName = new QName(aRSMapping2.getExternalNamespace(), aRSMapping2.getExternalGlobalName());
                    aRSMapping3 = new ARSMapping(xMLSchemaParser, qName, "complexType", document);
                    aRSMapping3.setMappingName(aRSMapping2.getName());
                } else if (aRSMapping2.getMappingMode() == 2) {
                    qName = new QName(aRSMapping2.getExternalNamespace(), aRSMapping2.getExternalGlobalName());
                    aRSMapping3 = new ARSMapping(xMLSchemaParser, qName, "element", document);
                    aRSMapping3.setMappingName(aRSMapping2.getName());
                }
            }
            catch (ARWSException aRWSException) {
                aRSMapping3 = new ARSMapping(aRSMapping2.getName(), aRSMapping2.getTargetNamespace(), document);
                aRSMapping2.warnChildren(stringBuffer);
            }
            if (aRSMapping3 == null) continue;
            aRSMapping3.resolveMapping(aRSMapping, stringBuffer);
            this.mappingsList.set(i, aRSMapping3);
            this.mappings.put(aRSMapping3.getName(), aRSMapping3);
            aRSMapping.getMappingElement().getParentNode().replaceChild(aRSMapping3.getMappingElement(), aRSMapping.getMappingElement());
        }
    }

    public void parseXML(String string) {
        if (!this.element.getLocalName().equals("port")) {
            throw new ARWSException("OTHER_ERROR", "ERROR: root element in parseWebServiceInfo should be webservice");
        }
        this.name = this.element.getAttribute("name");
        if (this.name == null) {
            throw new ARWSException("OTHER_ERROR", "ERROR: port should have a name attribute");
        }
        this.locationURI = this.element.getAttribute("locationURI");
        this.targetNamespace = this.element.getAttribute("targetNamespace");
        NodeList nodeList = this.element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if (element.getLocalName().equals("arDocMapping")) {
                object = new ARSMapping(element);
                this.addMapping((ARSMapping)object);
                if (this.targetNamespace != null) continue;
                this.targetNamespace = ((ARSMapping)object).getTargetNamespace();
                continue;
            }
            if (element.getLocalName().equals("operation")) {
                object = new ARSOperation(element);
                this.addOperation((ARSOperation)object);
                continue;
            }
            if (!element.getLocalName().equals("portProperties")) continue;
            object = element.getChildNodes();
            for (int j = 0; j < object.getLength(); ++j) {
                int n;
                String string2;
                Element element2;
                Node node2 = object.item(j);
                if (node2.getNodeType() != 1 || !(element2 = (Element)node2).getLocalName().equals("portType") || (string2 = element2.getAttribute("name")) == null || string2.equals("") || (n = string2.indexOf(32)) <= -1) continue;
                this.bindingStyle = string2.substring(0, n);
                int n2 = string2.lastIndexOf(32);
                if (n2 <= -1) continue;
                this.useStyle = string2.substring(n2 + 1, string2.length());
            }
        }
        if (this.targetNamespace == null || this.targetNamespace.equals("")) {
            this.targetNamespace = string;
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void generateXML(Document document, Element element) {
        Element element2 = document.createElementNS(null, "port");
        element2.setAttributeNS(null, "name", this.getName());
        element2.setAttributeNS(null, "targetNamespace", this.getTargetNamespace());
        element2.setAttributeNS(null, "locationURI", this.getLocationURI());
        this.element = element2;
        element.appendChild(element2);
        Element element3 = document.createElementNS(null, "portType");
        element3.setAttributeNS(null, "name", this.getBindingStyle() + " - " + this.getUseStyle());
        Element element4 = document.createElementNS(null, "portProperties");
        element4.appendChild(element3);
        element2.appendChild(element4);
        for (Object object : this.getMappings()) {
            ((ARSMapping)object).generateXML(element2);
        }
        for (Object object : this.getOperations()) {
            ((ARSOperation)object).generateXML(element2);
        }
    }

    public void addOperation(ARSOperation aRSOperation) {
        if (!this.operations.containsKey(aRSOperation.getName())) {
            this.operations.put(aRSOperation.getName(), aRSOperation);
            this.operationsList.add(aRSOperation);
        }
    }

    public void addMapping(ARSMapping aRSMapping) {
        if (!this.mappings.containsKey(aRSMapping.getName())) {
            this.mappings.put(aRSMapping.getName(), aRSMapping);
            this.mappingsList.add(aRSMapping);
        }
    }
}

