/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClassLoader
extends URLClassLoader {
    private static Logger LOGGER = Logger.getLogger(PluginClassLoader.class);
    private ArrayList<String> mPaths;
    private String mCacheDir;
    private static ArrayList<String> systemPackages = new ArrayList(200);

    public PluginClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
    }

    public PluginClassLoader(URL[] uRLArray) {
        super(uRLArray);
    }

    public PluginClassLoader(URL[] uRLArray, ClassLoader classLoader, ArrayList<String> arrayList, String string) {
        super(uRLArray, classLoader);
        this.mPaths = arrayList;
        this.mCacheDir = string;
        if (!this.mCacheDir.endsWith("" + File.separatorChar + "")) {
            this.mCacheDir = this.mCacheDir + File.separatorChar;
        }
    }

    @Override
    protected String findLibrary(String string) {
        String string2;
        String string3 = ";";
        if (string.indexOf(46) == -1) {
            string2 = System.getProperty("os.name");
            if (string2 != null) {
                if (string2.substring(0, 3).equalsIgnoreCase("Win")) {
                    string = string + ".dll";
                    string3 = ";";
                } else if (string2.equalsIgnoreCase("AIX")) {
                    string = "lib" + string + ".a";
                    string3 = ":";
                } else if (string2.equalsIgnoreCase("HP-UX")) {
                    string = "lib" + string + ".sl";
                    string3 = ":";
                } else {
                    string = "lib" + string + ".so";
                    string3 = ":";
                }
            } else {
                string = string + ".dll";
                string3 = ";";
            }
        }
        string2 = System.getProperty("java.library.path");
        for (int i = 0; i < this.mPaths.size(); ++i) {
            String string4 = this.mPaths.get(i);
            string2 = string2 + string3 + string4;
        }
        System.setProperty("java.library.path", string2);
        return super.findLibrary(string);
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        int n = string.lastIndexOf(46);
        if (n >= 0 && systemPackages.contains(string.substring(0, n))) {
            return super.loadClass(string, bl);
        }
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = this.getParent();
                if (classLoader != null) {
                    clazz = classLoader.loadClass(string);
                }
                throw classNotFoundException;
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    static {
        systemPackages.add("java.lang");
        systemPackages.add("java.lang.reflect");
        systemPackages.add("java.io");
        systemPackages.add("java.net");
        systemPackages.add("java.applet");
        systemPackages.add("java.awt");
        systemPackages.add("java.awt.image");
        systemPackages.add("java.awt.datatransfer");
        systemPackages.add("java.awt.peer");
        systemPackages.add("java.awt.event");
        systemPackages.add("java.rmi");
        systemPackages.add("java.rmi.registry");
        systemPackages.add("java.rmi.server");
        systemPackages.add("java.rmi.dgc");
        systemPackages.add("java.util");
        systemPackages.add("java.util.zip");
        systemPackages.add("java.text");
        systemPackages.add("java.text.resources");
        systemPackages.add("java.security");
        systemPackages.add("java.security.acl");
        systemPackages.add("java.math");
        systemPackages.add("java.sql");
        systemPackages.add("java.beans");
        systemPackages.add("com.bmc.arsys.pluginsvr");
        systemPackages.add("com.bmc.arsys.pluginsvr.plugins");
        systemPackages.add("com.bmc.arsys.pluginsvr.mapping");
        systemPackages.add("com.bmc.arsys.pluginsvr.legacy");
        systemPackages.add("com.bmc.arsys.pluginsvr.encrypt");
        systemPackages.add("com.bmc.arsys.pluginsvr.oncrpcext");
        systemPackages.add("com.bmc.arsys.api");
        systemPackages.add("com.bmc.arsys.util");
        systemPackages.add("com.bmc.arsys.utils");
        systemPackages.add("com.bmc.arsys.arencrypt");
        systemPackages.add("com.bmc.arsys.arcompress");
        systemPackages.add("com.bmc.arsys.arsqlparser");
        systemPackages.add("com.bmc.arsys.artranscode");
        systemPackages.add("com.bmc.arsys.arrpc");
        systemPackages.add("com.bmc.arsys.arrpc.xdr");
        systemPackages.add("org.acplt.oncrpc");
        systemPackages.add("org.acplt.oncrpc.server");
        systemPackages.add("org.acplt.oncrpc.ant");
        systemPackages.add("org.acplt.oncrpc.apps.jportmap");
        systemPackages.add("org.acplt.oncrpc.apps.jrpcgen");
        systemPackages.add("org.acplt.oncrpc.jrpcgen.cup_runtime");
        systemPackages.add("javax.xml");
        systemPackages.add("javax.xml.datatype");
        systemPackages.add("javax.xml.namespace");
        systemPackages.add("javax.xml.parsers");
        systemPackages.add("javax.xml.transform");
        systemPackages.add("javax.xml.transform.dom");
        systemPackages.add("javax.xml.transform.sax");
        systemPackages.add("javax.xml.transform.stream");
        systemPackages.add("javax.xml.validation");
        systemPackages.add("javax.xml.xpath");
        systemPackages.add("org.w3c.dom");
        systemPackages.add("org.w3c.dom.bootstrap");
        systemPackages.add("org.w3c.dom.events");
        systemPackages.add("org.w3c.dom.ls");
        systemPackages.add("org.xml.sax");
        systemPackages.add("org.xml.sax.ext");
        systemPackages.add("org.xml.sax.helpers");
        systemPackages.add("org.apache.xml.serialize");
        systemPackages.add("org.apache.xerces.dom");
        systemPackages.add("org.apache.xerces.dom.events");
        systemPackages.add("org.apache.xerces.dom3");
        systemPackages.add("org.apache.xerces.dom3.as");
        systemPackages.add("org.apache.xerces.dom3.ls");
        systemPackages.add("org.apache.xerces.impl");
        systemPackages.add("org.apache.xerces.impl.dtd");
        systemPackages.add("org.apache.xerces.impl.dtd.models");
        systemPackages.add("org.apache.xerces.impl.dv");
        systemPackages.add("org.apache.xerces.impl.dv.dtd");
        systemPackages.add("org.apache.xerces.impl.dv.util");
        systemPackages.add("org.apache.xerces.impl.dv.xs");
        systemPackages.add("org.apache.xerces.impl.io");
        systemPackages.add("org.apache.xerces.impl.msg");
        systemPackages.add("org.apache.xerces.impl.validation");
        systemPackages.add("org.apache.xerces.impl.xpath");
        systemPackages.add("org.apache.xerces.impl.xpath.regex");
        systemPackages.add("org.apache.xerces.impl.xs");
        systemPackages.add("org.apache.xerces.impl.xs.identity");
        systemPackages.add("org.apache.xerces.impl.xs.models");
        systemPackages.add("org.apache.xerces.impl.xs.traversers");
        systemPackages.add("org.apache.xerces.impl.xs.util");
        systemPackages.add("org.apache.xerces.jaxp");
        systemPackages.add("org.apache.xerces.parsers");
        systemPackages.add("org.apache.xerces.util");
        systemPackages.add("org.apache.xerces.xni");
        systemPackages.add("org.apache.xerces.xni.grammars");
        systemPackages.add("org.apache.xerces.xni.parser");
        systemPackages.add("org.apache.xerces.xni.psvi");
        systemPackages.add("org.apache.commons.logging");
        systemPackages.add("org.apache.commons.logging.impl");
        systemPackages.add("org.apache.commons.lang");
        systemPackages.add("org.apache.commons.lang.mutable");
        systemPackages.add("org.apache.commons.lang.math");
        systemPackages.add("org.apache.commons.lang.time");
        systemPackages.add("org.apache.commons.lang.exception");
        systemPackages.add("org.apache.commons.lang.text");
        systemPackages.add("org.apache.commons.lang.enum");
        systemPackages.add("org.apache.commons.lang.builder");
        systemPackages.add("org.apache.commons.digester");
        systemPackages.add("org.apache.commons.digester.plugins");
        systemPackages.add("org.apache.commons.digester.xmlrules");
        systemPackages.add("org.apache.commons.digester.substitution");
        systemPackages.add("org.apache.commons.digester.plugin.strategies");
        systemPackages.add("org.apache.commons.configuration");
        systemPackages.add("org.apache.commons.configuration.beanutils");
        systemPackages.add("org.apache.commons.configuration.event");
        systemPackages.add("org.apache.commons.configuration.plist");
        systemPackages.add("org.apache.commons.configuration.event");
        systemPackages.add("org.apache.commons.configuration.reloading");
        systemPackages.add("org.apache.commons.configuration.tree");
        systemPackages.add("org.apache.commons.configuration.web");
        systemPackages.add("org.apache.commons.configuration.tree.xpath");
        systemPackages.add("org.apache.commons.collections");
        systemPackages.add("org.apache.commons.collections.bag");
        systemPackages.add("org.apache.commons.collections.bidimap");
        systemPackages.add("org.apache.commons.collections.collection");
        systemPackages.add("org.apache.commons.collections.comparators");
        systemPackages.add("org.apache.commons.collections.functors");
        systemPackages.add("org.apache.commons.collections.iterators");
        systemPackages.add("org.apache.commons.collections.map");
        systemPackages.add("org.apache.commons.collections.list");
        systemPackages.add("org.apache.commons.collections.set");
        systemPackages.add("org.apache.commons.codec");
        systemPackages.add("org.apache.commons.codec.binary");
        systemPackages.add("org.apache.commons.codec.language");
        systemPackages.add("org.apache.commons.beanutils");
        systemPackages.add("org.apache.commons.beanutils.locale");
        systemPackages.add("org.apache.commons.beanutils.converters");
        systemPackages.add("org.apache.commons.beanutils.locale.converters");
        systemPackages.add("org.apache.log4j");
        systemPackages.add("org.apache.log4j.chainsaw");
        systemPackages.add("org.apache.log4j.config");
        systemPackages.add("org.apache.log4j.helpers");
        systemPackages.add("org.apache.log4j.jdbc");
        systemPackages.add("org.apache.log4j.jmx");
        systemPackages.add("org.apache.log4j.lf5");
        systemPackages.add("org.apache.log4j.lf5.config");
        systemPackages.add("org.apache.log4j.lf5.util");
        systemPackages.add("org.apache.log4j.lf5.viewer");
        systemPackages.add("org.apache.log4j.lf5.viewer.categoryexplorer");
        systemPackages.add("org.apache.log4j.lf5.viewer.configure");
        systemPackages.add("org.apache.log4j.lf5.viewer.images");
        systemPackages.add("org.apache.log4j.net");
        systemPackages.add("org.apache.log4j.nt");
        systemPackages.add("org.apache.log4j.or");
        systemPackages.add("org.apache.log4j.or.jms");
        systemPackages.add("org.apache.log4j.or.sax");
        systemPackages.add("org.apache.log4j.spi");
        systemPackages.add("org.apache.log4j.varia");
        systemPackages.add("org.apache.log4j.xml");
    }
}

