/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.nio.ArConnectionInfo;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.arrpc.nio.ArRpcCallHandler;
import com.bmc.arsys.arrpc.nio.ArSelectorThread;
import com.bmc.arsys.pluginsvr.ARPluginSvrRemoteHostInfo;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.binding.ARPluginSvrExecutorFactory;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrXdrTcpDecodingStream;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrXdrTcpEncodingStream;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.apache.log4j.Logger;

public class ARPluginSvrRpcCallHandler
extends ArRpcCallHandler {
    private static Logger LOGGER = Logger.getLogger(ARPluginSvrRpcCallHandler.class);

    public ARPluginSvrRpcCallHandler(ArSelectorThread arSelectorThread, SocketChannel socketChannel, OncRpcDispatchable oncRpcDispatchable, int n, int n2) throws IOException {
        super(arSelectorThread, socketChannel, oncRpcDispatchable, n, n2);
    }

    protected void createXdrTcpEncodingStream(int n) throws IOException {
        if (this.getXdrEncodingStream() != null) {
            try {
                this.getXdrEncodingStream().close();
            }
            catch (OncRpcException oncRpcException) {
                LOGGER.debug((Object)("EncodingStream can not be closes." + oncRpcException.getLocalizedMessage()));
            }
        }
        this.setXdrTcpEncodingStream(new ARPluginSvrXdrTcpEncodingStream((ArEncryptionContext)this, this.getSocketChannel(), n));
        this.getXdrEncodingStream().setCharacterEncoding(this.getCharacterEncoding());
    }

    protected void createXdrTcpDecodingStream(int n) throws IOException {
        if (this.getXdrDecodingStream() != null) {
            try {
                this.getXdrDecodingStream().close();
            }
            catch (OncRpcException oncRpcException) {
                LOGGER.debug((Object)("DecodingStream can not be closes." + oncRpcException.getLocalizedMessage()));
            }
        }
        this.setXdrTcpDecodingStream(new ARPluginSvrXdrTcpDecodingStream((ArEncryptionContext)this, this.getSocketChannel(), n));
        this.getXdrDecodingStream().setCharacterEncoding(this.getCharacterEncoding());
    }

    protected void executeProcessor(ArRpcCallHandler.Processor processor) {
        ARPluginSvrExecutorFactory.getRPCCallExecutor().execute((Runnable)processor);
    }

    protected int isEncryptionPolicyValid(boolean bl, int n) {
        int n2 = 0;
        if (n != 16) {
            try {
                ARPluginServerEncryptionInfo aRPluginServerEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
                switch (aRPluginServerEncryptionInfo.getEncryptionSecurityPolicy()) {
                    case 2: {
                        if (!bl && n != 17 && n != 18) break;
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        if (bl || n == 17 || n == 18) break;
                        n2 = 5;
                        break;
                    }
                }
            }
            catch (ARException aRException) {
                LOGGER.debug((Object)("check isEncryptionPolicyValid got exception " + aRException.getLocalizedMessage()));
            }
        }
        return n2;
    }

    public void retrieveCall(XdrAble xdrAble) throws OncRpcException, IOException {
        if (this.getXdrDecodingStream() instanceof ARPluginSvrXdrTcpDecodingStream) {
            ARPluginSvrXdrTcpDecodingStream aRPluginSvrXdrTcpDecodingStream = (ARPluginSvrXdrTcpDecodingStream)this.getXdrDecodingStream();
            aRPluginSvrXdrTcpDecodingStream.resetArFlags();
            aRPluginSvrXdrTcpDecodingStream.setCharacterEncoding(this.getCharacterEncoding());
            aRPluginSvrXdrTcpDecodingStream.arExcBeforeUnXdrDecodeParams(xdrAble);
            if (!aRPluginSvrXdrTcpDecodingStream.isXdrDecodeDone()) {
                try {
                    xdrAble.xdrDecode((XdrDecodingStream)aRPluginSvrXdrTcpDecodingStream);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    LOGGER.error((Object)"Decode mapping wrong.");
                    throw new OncRpcException(4);
                }
                if (this.isPendingDecoding()) {
                    this.setPendingDecoding(false);
                    aRPluginSvrXdrTcpDecodingStream.endDecoding();
                }
            }
        } else {
            super.retrieveCall(xdrAble);
        }
    }

    protected String updateRemoteHostCharSet(OncRpcCallInformation oncRpcCallInformation) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(oncRpcCallInformation.peerAddress.getHostAddress());
        stringBuffer.append(":");
        stringBuffer.append(oncRpcCallInformation.peerPort);
        String string = stringBuffer.toString();
        this.setRemoteHostKey(string);
        ARPluginSvrThreadLocalStorageBlock.getTLB().setCurrentRemoteHostKey(string);
        String string2 = ARPluginSvrRemoteHostInfo.getRemoteHostCharSet((String)string);
        ARPluginSvrThreadLocalStorageBlock.getTLB().setRemoteHostCharSet(string2);
        this.setCharacterEncoding(string2);
        if (LOGGER.isTraceEnabled()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("Remote host ").append(stringBuffer.toString()).append(" uses ");
            if (!ArConnectionInfo.isRemoteHostCodeSetExist()) {
                stringBuffer2.append(" default ");
            }
            stringBuffer2.append(" codeset: ").append(string2);
            LOGGER.trace((Object)stringBuffer2.toString());
        }
        return string2;
    }

    protected void setRemoteHostCharSetToStreams() {
        String string = ARPluginSvrThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
        String string2 = ARPluginSvrRemoteHostInfo.getRemoteHostCharSet((String)string);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("set encode/decode streams to handle remote host request charset: " + string2));
        }
        this.setRemoteHostCharSet(string2);
        super.setRemoteHostCharSetToStreams();
    }
}

