/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSThesaurusFilter
extends TokenFilter {
    public static final String TOKEN_TYPE_SYNONYM = "SYNONYM";
    private Stack<Token> synonymStack = new Stack();
    private Hashtable<String, String[]> thesTable;

    public FTSThesaurusFilter(TokenStream tokenStream, Hashtable<String, String[]> hashtable) {
        super(tokenStream);
        this.thesTable = hashtable;
    }

    public Token next() throws IOException {
        if (this.synonymStack.size() > 0) {
            return this.synonymStack.pop();
        }
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        this.addAliasesToStack(token);
        return token;
    }

    private void addAliasesToStack(Token token) throws IOException {
        String[] stringArray = this.thesTable.get(token.term());
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Token token2 = new Token(stringArray[i], token.startOffset(), token.endOffset(), TOKEN_TYPE_SYNONYM);
            token2.setPositionIncrement(0);
            this.synonymStack.push(token2);
        }
    }
}

