/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class Conventions {
    private static final String PLURAL_SUFFIX = "List";

    public static String getVariableName(Object value) {
        Class valueClass = value.getClass();
        boolean pluralize = false;
        if (valueClass.isArray()) {
            valueClass = valueClass.getComponentType();
            pluralize = true;
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            valueClass = Conventions.peekAhead(collection);
            pluralize = true;
        }
        String name = StringUtils.uncapitalize(ClassUtils.getShortName(valueClass));
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String attributeNameToPropertyName(String attributeName) {
        Assert.notNull(attributeName, "'attributeName' cannot be null.");
        if (attributeName.indexOf("-") == -1) {
            return attributeName;
        }
        char[] chars = attributeName.toCharArray();
        char[] result = new char[chars.length - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '-') {
                upperCaseNext = true;
                continue;
            }
            if (upperCaseNext) {
                result[currPos++] = Character.toUpperCase(c);
                upperCaseNext = false;
                continue;
            }
            result[currPos++] = c;
        }
        return new String(result, 0, currPos);
    }

    private static String pluralize(String name) {
        return name + PLURAL_SUFFIX;
    }

    private static Class peekAhead(Collection collection) {
        Iterator it = collection.iterator();
        if (it.hasNext()) {
            return it.next().getClass();
        }
        throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
    }

    public static String getQualifiedAttributeName(Class enclosingClass, String attributeName) {
        Assert.notNull(enclosingClass, "'enclosingClass' cannot be null.");
        Assert.notNull(attributeName, "'attributeName' cannot be null.");
        return enclosingClass.getName() + "." + attributeName;
    }
}

