/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.client;

import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.ws.client.ARPolicyLoader;
import com.bmc.arsys.ws.client.PolicyDetails;
import com.bmc.arsys.ws.client.WSPolicyProcessor;
import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.mapping.ARSOperation;
import com.bmc.arsys.ws.util.WsdlUtil;
import java.io.StringReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.Text;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.DOM2Writer;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.XMLUtils;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebServiceSoapClient {
    public static final int WS_IDENTIFIER = 0;
    public static final int WS_JAVA_CLASSNAME = 1;
    public static final int WS_JAVA_METHOD_NAME = 2;
    public static final int WS_JAVA_METHOD_PARAMLIST = 3;
    public static final int WS_WSDL_URL = 4;
    public static final int WS_NAME = 5;
    public static final int WS_OPERATION_DOC = 6;
    public static final int WS_ENDPOINT_URI = 7;
    public static final int WS_TARGETNS = 8;
    public static final int WS_INPUT_MAP = 9;
    public static final int WS_OUTPUT_MAP = 10;
    public static final int WS_INPUT_DOC = 11;
    public static final int WS_BASIC_AUTH_USER = 12;
    public static final int WS_BASIC_AUTH_PASSWD = 13;
    public static final int WS_AUTH_TYPE = 14;
    public static final int WS_UT_PASSWD_TYPE = 15;
    public static final int WS_POLICY_ID = 16;
    public static final int WS_MAX_PARAMS = 19;
    public static String WS_UT_AUTH = "UTAuth";
    public static int timeout = 40;

    private static String removePasswordFromString(ARPluginContext context, ARPluginInfo info, String inputString) throws Exception {
        int startOccur = 0;
        int endOccur = 0;
        Pattern passwordPattern = Pattern.compile("password>(.*)</(.*)(password)>");
        try {
            Matcher matchPasswdPattern = passwordPattern.matcher(inputString);
            boolean IsMatchPasswdPattern = matchPasswdPattern.find();
            if (!IsMatchPasswdPattern) {
                passwordPattern = Pattern.compile("Password>(.*)</(.*)(Password)>");
                matchPasswdPattern = passwordPattern.matcher(inputString);
                IsMatchPasswdPattern = matchPasswdPattern.find();
            }
            if (IsMatchPasswdPattern) {
                startOccur = matchPasswdPattern.start();
                endOccur = matchPasswdPattern.end();
                String capturedString = matchPasswdPattern.group();
                Pattern pr = Pattern.compile(">(.*)</");
                Matcher mr = pr.matcher(capturedString);
                boolean br = mr.find();
                String replacedString = "";
                if (br) {
                    replacedString = mr.replaceAll(">****</");
                }
                String preString = inputString.substring(0, startOccur);
                String postString = inputString.substring(endOccur, inputString.length());
                String newString = preString + replacedString + postString;
                return newString;
            }
            return inputString;
        }
        catch (Exception e) {
            e.printStackTrace();
            context.logMessage(info, 2, e.toString());
            System.err.println(e.toString());
            throw e;
        }
    }

    public static String call(ARPluginContext context, ARPluginInfo info, String[] inputValues) throws Exception {
        return WebServiceSoapClient.call(context, info, inputValues, timeout);
    }

    public static String call(ARPluginContext context, ARPluginInfo info, String[] inputValues, int timeout) throws Exception {
        try {
            Node curr;
            int i;
            String soapService = inputValues[5];
            String soapURL = inputValues[7];
            String soapNamespace = inputValues[8];
            String soapOperationDoc = inputValues[6];
            String soapInputDocument = inputValues[11];
            String soapInputMap = inputValues[9];
            String policyId = inputValues[16];
            String authUser = null;
            String authPass = null;
            String defAuthUser = null;
            String defAuthPass = null;
            String utPassType = null;
            String wsAuthType = null;
            context.logMessage(info, 0, "input values length = " + String.valueOf(inputValues.length));
            context.logMessage(info, 0, "soapOperationDoc = " + soapOperationDoc);
            context.logMessage(info, 0, "soapInputMap = " + soapInputMap);
            if (inputValues.length > 13) {
                authUser = inputValues[12];
                authPass = inputValues[13];
                utPassType = inputValues[15];
                wsAuthType = inputValues[14];
            }
            Document operationDoc = WsdlUtil.newDocument(new InputSource(new StringReader(soapOperationDoc)));
            ARSOperation arsOperation = new ARSOperation(operationDoc.getDocumentElement());
            String soapAction = arsOperation.getSoapActionURI();
            String soapMethod = arsOperation.getName();
            Document inputMapDoc = null;
            ARSMapping arsMapping = null;
            Element inputMapRootElement = null;
            if (soapInputMap != null) {
                inputMapDoc = WsdlUtil.newDocument(new InputSource(new StringReader(soapInputMap)));
                arsMapping = new ARSMapping(inputMapDoc.getDocumentElement());
                inputMapRootElement = arsMapping.getRootElement();
            }
            context.logMessage(info, 0, "soapService = " + soapService);
            context.logMessage(info, 0, "soapMethod = " + soapMethod);
            context.logMessage(info, 0, "soapURL = " + soapURL);
            context.logMessage(info, 0, "soapNamespace = " + soapNamespace);
            String modifiedSoapInputDocument = WebServiceSoapClient.removePasswordFromString(context, info, soapInputDocument);
            context.logMessage(info, 0, "soapInputDocument = " + modifiedSoapInputDocument);
            context.logMessage(info, 0, "soapAction = " + soapAction);
            context.logMessage(info, 0, "soapMethod = " + soapMethod);
            context.logMessage(info, 0, "policyId = " + policyId);
            if (inputValues.length > 13) {
                context.logMessage(info, 0, "URL Basic Auth User = " + inputValues[12]);
                context.logMessage(info, 0, "URL Basic Auth Password = <hidden>");
                context.logMessage(info, 0, "UT Password Type = " + inputValues[15]);
                context.logMessage(info, 0, "WS Auth Type = " + inputValues[14]);
            }
            context.logMessage(info, 0, "Number of inputs = " + inputValues.length);
            Service service = new Service();
            Call call = (Call)service.createCall();
            if (soapAction != null && !soapAction.equals("")) {
                call.setUseSOAPAction(true);
                call.setSOAPActionURI(soapAction);
            }
            context.logMessage(info, 0, "modified soapURL = " + soapURL);
            call.setTargetEndpointAddress(new URL(soapURL));
            call.setOperationName(soapMethod);
            if (authUser != null && authPass != null && !authUser.equals("") && !authPass.equals("")) {
                context.logMessage(info, 0, "Setting user and password for site / proxy auth, username" + authUser);
                call.setUsername(authUser);
                call.setPassword(authPass);
            }
            if (timeout != 0) {
                context.logMessage(info, 0, "set WS timeout: " + timeout + " sec");
                call.setTimeout(new Integer(timeout * 1000));
            }
            StringReader inputDocStringReader = new StringReader(soapInputDocument);
            InputSource inputDocInputSource = new InputSource(inputDocStringReader);
            Document doc = XMLUtils.newDocument((InputSource)inputDocInputSource);
            SOAPEnvelope env = new SOAPEnvelope();
            SOAPEnvelope env12 = new SOAPEnvelope((SOAPConstants)SOAPConstants.SOAP12_CONSTANTS);
            Element rootElement = doc.getDocumentElement();
            NodeList rootNodeList = rootElement.getChildNodes();
            String topLevelElement = arsOperation.getInputTopElement();
            Node dataTypeNode = null;
            Node dataTypeName = null;
            if (inputMapRootElement != null) {
                Node tempNode = inputMapRootElement.getFirstChild();
                NamedNodeMap nnm = null;
                if (tempNode == null) {
                    tempNode = inputMapRootElement.getNextSibling();
                }
                if (tempNode != null) {
                    nnm = tempNode.getAttributes();
                }
                if (nnm != null) {
                    dataTypeNode = nnm.getNamedItem("dataType");
                } else {
                    if ((tempNode = tempNode.getNextSibling()) != null) {
                        nnm = tempNode.getAttributes();
                    }
                    if (nnm != null) {
                        dataTypeNode = nnm.getNamedItem("dataType");
                    }
                    if (dataTypeNode != null) {
                        dataTypeName = nnm.getNamedItem("name");
                    }
                }
            }
            Element newElement = null;
            int originalLength = 0;
            if (dataTypeName != null && dataTypeName.getNodeValue().equals(topLevelElement)) {
                originalLength = rootNodeList.getLength();
                for (int k = 0; k < originalLength; ++k) {
                    String s1;
                    Node n1 = rootNodeList.item(k);
                    short type = n1.getNodeType();
                    if (type != 1 || !(s1 = n1.getLocalName()).equals(arsOperation.getInputTopElement())) continue;
                    newElement = (Element)n1;
                    break;
                }
            }
            if (newElement == null) {
                newElement = doc.createElementNS(soapNamespace, topLevelElement);
                originalLength = rootNodeList.getLength();
                for (i = 0; i < originalLength; ++i) {
                    newElement.appendChild(rootNodeList.item(0));
                }
            }
            NamedNodeMap attributes = rootElement.getAttributes();
            originalLength = attributes.getLength();
            for (i = 0; i < originalLength; ++i) {
                Node attr = attributes.item(i);
                if (attr == null || "xmlns:xsi".equalsIgnoreCase(attr.getNodeName()) || "xmlns:xsd".equalsIgnoreCase(attr.getNodeName())) continue;
                newElement.setAttributeNode((Attr)attr.cloneNode(true));
            }
            WebServiceSoapClient.processSOAPHeader(context, info, env, WebServiceSoapClient.getFirstChildElement(newElement), defAuthUser, defAuthPass, utPassType, wsAuthType);
            WebServiceSoapClient.processSOAPHeader(context, info, env12, WebServiceSoapClient.getFirstChildElement(newElement), defAuthUser, defAuthPass, utPassType, wsAuthType);
            doc.replaceChild(newElement, rootElement);
            SOAPBodyElement body = new SOAPBodyElement(doc.getDocumentElement());
            if (arsOperation.getBindingStyle().equals("rpc")) {
                body = new SOAPBodyElement();
                WebServiceSoapClient.copyNode((MessageElement)body, doc.getDocumentElement(), true);
            }
            env.addBodyElement(body);
            env12.addBodyElement(body);
            body.setNamespaceURI(soapNamespace);
            String tmpEnvStr = env.toString();
            String modifiedEnvString = WebServiceSoapClient.removePasswordFromString(context, info, tmpEnvStr);
            context.logMessage(info, 0, "Input Env = " + modifiedEnvString);
            if (policyId != null) {
                ARPolicyLoader policyLoader = new ARPolicyLoader(context, info);
                PolicyDetails pd = policyLoader.loadPolicyDetails(policyId);
                WSPolicyProcessor.processPolicy(pd, call, soapNamespace);
            } else if (wsAuthType != null && wsAuthType.equals(WS_UT_AUTH)) {
                PolicyDetails pd = new PolicyDetails();
                pd.setResponseSecurityAction("Timestamp");
                WSPolicyProcessor.processPolicy(pd, call, soapNamespace);
            }
            context.logMessage(info, 0, "About to invoke");
            SOAPEnvelope outEnv = null;
            long startTime = System.currentTimeMillis();
            try {
                call.setProperty("call.FaultOnNoResponse", (Object)new Boolean(true));
                outEnv = call.invoke(env);
            }
            catch (AxisFault fault) {
                context.logMessage(info, 2, fault.toString());
                if (fault.getFaultCode().equals(SOAPConstants.SOAP11_CONSTANTS.getVerMismatchFaultCodeQName())) {
                    String tmpEnvStr12 = env12.toString();
                    String modifiedEnvString12 = WebServiceSoapClient.removePasswordFromString(context, info, tmpEnvStr12);
                    context.logMessage(info, 0, "Upgraded Soap 12 Env = " + modifiedEnvString12);
                    context.logMessage(info, 0, "About to re-invoke");
                    if (policyId != null) {
                        ARPolicyLoader policyLoader = new ARPolicyLoader(context, info);
                        PolicyDetails pd = policyLoader.loadPolicyDetails(policyId);
                        WSPolicyProcessor.processPolicy(pd, call, soapNamespace);
                    }
                    outEnv = call.invoke(env12);
                }
                String tmpOut = "";
                if (fault.getMessage().equals("Null response message!")) {
                    context.logMessage(info, 0, "AxisFault returned null response message for webservice " + soapService + " Request " + soapMethod);
                    return tmpOut;
                }
                long endTime = System.currentTimeMillis();
                context.logMessage(info, 2, "WS timeout setting  = " + timeout + " sec");
                context.logMessage(info, 2, "AxisFault during  = " + (endTime - startTime) + " millisec");
                context.logMessage(info, 2, "soapService = " + soapService);
                context.logMessage(info, 2, "soapMethod = " + soapMethod);
                context.logMessage(info, 2, "soapURL = " + soapURL);
                context.logMessage(info, 2, "soapNamespace = " + soapNamespace);
                context.logMessage(info, 2, "soapInputDocument = " + modifiedSoapInputDocument);
                context.logMessage(info, 2, "soapOperationDoc = " + soapOperationDoc);
                context.logMessage(info, 2, "soapAction = " + soapAction);
                context.logMessage(info, 2, "soapMethod = " + soapMethod);
                throw fault;
            }
            context.logMessage(info, 0, "Finished invoking");
            context.logMessage(info, 0, "Output Envelope = " + outEnv);
            Element outEnvElement = outEnv.getAsDOM();
            for (curr = outEnvElement.getFirstChild(); !(curr == null || curr.getNodeType() == 1 && ((Element)curr).getLocalName().equals("Body")); curr = curr.getNextSibling()) {
            }
            for (curr = curr.getFirstChild(); curr != null && curr.getNodeType() != 1; curr = curr.getNextSibling()) {
            }
            Element outElement = (Element)curr;
            Document parentDoc = outElement.getOwnerDocument();
            NodeList outNodeList = outElement.getChildNodes();
            Element newRootElement = parentDoc.createElementNS(soapNamespace, "ROOT");
            originalLength = outNodeList.getLength();
            if (originalLength == 1 && outNodeList.item(0).getNodeType() != 1) {
                newRootElement.appendChild(outElement);
            } else {
                for (i = 0; i < originalLength; ++i) {
                    Node returnNode = outNodeList.item(i).cloneNode(true);
                    String nameSpaceURI = returnNode.getNamespaceURI();
                    if (nameSpaceURI != null && nameSpaceURI.equals("http://www.w3.org/2003/05/soap-rpc")) continue;
                    newRootElement.appendChild(returnNode);
                }
            }
            attributes = outEnvElement.getAttributes();
            originalLength = attributes.getLength();
            for (i = 0; i < originalLength; ++i) {
                newRootElement.setAttributeNode((Attr)attributes.item(i).cloneNode(true));
            }
            attributes = outElement.getAttributes();
            originalLength = attributes.getLength();
            for (i = 0; i < originalLength; ++i) {
                newRootElement.setAttributeNode((Attr)attributes.item(i).cloneNode(true));
            }
            String outValue = DOM2Writer.nodeToString((Node)newRootElement, (boolean)false);
            context.logMessage(info, 0, outValue);
            return outValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            context.logMessage(info, 2, e.toString());
            System.err.println(e.toString());
            throw e;
        }
    }

    private static void copyNode(MessageElement dest, Node source, boolean hasPrefix) {
        boolean noNameSpace = false;
        if (hasPrefix) {
            dest.setPrefix(source.getPrefix());
            if (source.getLocalName() != null) {
                dest.setQName(new QName(source.getNamespaceURI(), source.getLocalName()));
            } else {
                dest.setQName(new QName(source.getNamespaceURI(), source.getNodeName()));
            }
        } else if (source.getLocalName() != null) {
            dest.setQName(new QName(null, source.getLocalName()));
        } else {
            dest.setQName(new QName(null, source.getNodeName()));
        }
        NamedNodeMap attrs = source.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node att = attrs.item(i);
            if (att.getNodeValue().equals("NONAMESPACE")) {
                noNameSpace = true;
                continue;
            }
            if (att.getNamespaceURI() != null && att.getPrefix() != null && att.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") && "xmlns".equals(att.getPrefix())) {
                Mapping map = new Mapping(att.getNodeValue(), att.getLocalName());
                dest.addMapping(map);
            }
            if (att.getLocalName() != null) {
                dest.addAttribute(att.getPrefix(), att.getNamespaceURI() != null ? att.getNamespaceURI() : "", att.getLocalName(), att.getNodeValue());
                continue;
            }
            if (att.getNodeName() == null) continue;
            dest.addAttribute(att.getPrefix(), att.getNamespaceURI() != null ? att.getNamespaceURI() : "", att.getNodeName(), att.getNodeValue());
        }
        NodeList children = source.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Text childElement;
            Node child = children.item(i);
            if (child.getNodeType() == 3 || child.getNodeType() == 4 || child.getNodeType() == 8) {
                childElement = new Text((CharacterData)child);
                dest.appendChild((Node)childElement);
                continue;
            }
            childElement = new MessageElement();
            dest.appendChild((Node)childElement);
            if (noNameSpace) {
                WebServiceSoapClient.copyNode((MessageElement)childElement, child, false);
                continue;
            }
            WebServiceSoapClient.copyNode((MessageElement)childElement, child, true);
        }
    }

    public static Element getFirstChildElement(Node node) {
        Node firstChild;
        for (firstChild = node.getFirstChild(); firstChild != null && firstChild.getNodeType() != 1; firstChild = firstChild.getNextSibling()) {
        }
        return (Element)firstChild;
    }

    public static Element getSpecificChildElement(ARPluginContext context, ARPluginInfo info, Node node, String str) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        while (!(child == null || child.getLocalName() != null && child.getLocalName().equals(str) || child.getNodeValue() != null && child.getNodeValue().equals(str))) {
            child = child.getNextSibling();
        }
        return (Element)child;
    }

    private static Element doUsernameToken(ARPluginContext context, ARPluginInfo info, Document inputDoc, String user, String passwd, String passType) {
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(inputDoc);
        secHeader.setMustUnderstand(true);
        WSSecUsernameToken secUT = new WSSecUsernameToken();
        if (passType == null || passType.equals("Text")) {
            secUT.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        } else if (passType.equals("Digest")) {
            secUT.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            secUT.addNonce();
        }
        if (passwd == null) {
            secUT.setUserInfo(user, "");
        } else {
            secUT.setUserInfo(user, passwd);
        }
        secUT.addCreated();
        secUT.prepare(inputDoc);
        secUT.prependToHeader(secHeader);
        Element secHeaderElem = secHeader.getSecurityHeader();
        return secHeaderElem;
    }

    public static void processSOAPHeader(ARPluginContext context, ARPluginInfo info, SOAPEnvelope env, Element soapHeaderElem, String defAuthUser, String defAuthPass, String utPassType, String wsAuthType) throws Exception {
        Document doc = null;
        if (wsAuthType == null || wsAuthType.equals(WS_UT_AUTH)) {
            doc = env.getAsDocument();
        }
        if (soapHeaderElem == null || !soapHeaderElem.getLocalName().equals("SOAPHeader")) {
            return;
        }
        soapHeaderElem.getParentNode().removeChild(soapHeaderElem);
        NodeList headers = soapHeaderElem.getChildNodes();
        if (headers != null && headers.getLength() != 0) {
            for (int j = 0; j < headers.getLength(); ++j) {
                Element userNameElem;
                Element userNameToken;
                Node fn;
                if (headers.item(j).getNodeType() != 1) continue;
                Element headerElem = (Element)headers.item(j);
                if (headerElem.getLocalName().equals("AuthenticationInfo")) {
                    Element userName = WebServiceSoapClient.getFirstChildElement(headerElem);
                    if (!userName.getLocalName().equals("userName") || !userName.hasChildNodes()) continue;
                    Element passwdElem = WebServiceSoapClient.getSpecificChildElement(context, info, headerElem, "password");
                    if (passwdElem != null && (fn = passwdElem.getFirstChild()) != null) {
                        String passwd = fn.getNodeValue();
                        PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
                        byte[] decPasswd = pwdEnc.decryptPasswordEx(passwd.getBytes());
                        passwd = new String(decPasswd);
                        fn.setNodeValue(passwd);
                    }
                }
                if (headerElem.getLocalName().equals("Security") && (userNameToken = WebServiceSoapClient.getFirstChildElement(headerElem)).getLocalName().equals("UsernameToken") && (userNameElem = WebServiceSoapClient.getSpecificChildElement(context, info, userNameToken, "Username")) != null) {
                    Element secHeaderElem;
                    fn = userNameElem.getFirstChild();
                    String username = fn.getNodeValue();
                    String passwd = null;
                    Element passwdElem = WebServiceSoapClient.getSpecificChildElement(context, info, userNameToken, "Password");
                    if (passwdElem != null && (fn = passwdElem.getFirstChild()) != null) {
                        passwd = fn.getNodeValue();
                        PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
                        byte[] decPasswd = pwdEnc.decryptPasswordEx(passwd.getBytes());
                        passwd = new String(decPasswd);
                    }
                    if ((secHeaderElem = WebServiceSoapClient.doUsernameToken(context, info, doc, username, passwd, utPassType)) != null) {
                        headerElem = secHeaderElem;
                    }
                }
                SOAPHeaderElement header2 = new SOAPHeaderElement(headerElem);
                header2.setMustUnderstand(true);
                env.addHeader(header2);
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 2 && argv[0].equals("convertNumberToWords")) {
            WebServiceSoapClient.convertNumberToWords(Integer.parseInt(argv[1]));
        } else if (argv.length == 2 && argv[0].equals("getBookPriceByISBN")) {
            WebServiceSoapClient.getBookPriceByISBN(argv[1]);
        } else if (argv.length == 1 && argv[0].equals("getSecurityToken")) {
            WebServiceSoapClient.getSecurityToken();
        } else {
            System.out.println("Usage:");
            System.out.println("   java WebServiceSoapClient convertNumberToWords 28");
            System.out.println("   java WebServiceSoapClient getBookPriceByISBN 1-57610-872-4");
        }
    }

    public static String test_rpc() throws Exception {
        String[] inputValues = new String[]{"c4245525-eeff-460b-a51a-79820047329f", "WebServiceSoapClient", "call", "([Ljava/lang/String;)Ljava/lang/String;", "http://bmc.arsystem/soap12/RpcEncoded/GetZipCode", "RpcEncoded", "<operation name=\"GetZipCode\" type=\"create\" useStyle=\"encoded\" bindingStyle=\"rpc\" soapActionURI=\"http://bmc.arsystem/soap12/RpcEncoded/GetZipCode\"><inputMapping name=\"NumToWords_EnglishRequest\" topLevelElement=\"GetZipCode\"/><outputMapping name=\"GetZipCodeResponse\" topLevelElement=\"GetZipCodeResponse\"/></operation>", "http://qaauto11:4040/Csharp_7.1/soap12/RpcEncoded.asmx", "http://bmc.arsystem/soap12/RpcEncoded", "dummy-inputMap", "dummy-outputMap", "<ROOT xmlns=\"NONAMESPACE\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><street xsi:type=\"xsd:string\"/><city xsi:type=\"xsd:string\">San Jose</city><state xsi:type=\"xsd:string\">CA</state></ROOT>", "Demo", ""};
        return WebServiceSoapClient.call(null, null, inputValues);
    }

    public static String convertNumberToWords(int number) throws Exception {
        String[] inputValues = new String[]{"c4245525-eeff-460b-a51a-79820047329f", "WebServiceSoapClient", "call", "([Ljava/lang/String;)Ljava/lang/String;", "http://www.tankebolaget.se/scripts/NumToWords.dll/wsdl/INumToWords", "INumToWordsservice", "<operation name=\"NumToWords_English\" type=\"create\" useStyle=\"encoded\" bindingStyle=\"rpc\" soapActionURI=\"urn:NumToWordsIntf-INumToWords#NumToWords_English\"><inputMapping name=\"NumToWords_EnglishRequest\" topLevelElement=\"NumToWords_English\"/><outputMapping name=\"NumToWords_EnglishResponse\" topLevelElement=\"NumToWords_EnglishResponse\"/></operation>", "http://www.tankebolaget.se/scripts/NumToWords.dll/soap/INumToWords", "urn:NumToWordsIntf-INumToWords", "dummy-inputMap", "dummy-outputMap", "<ROOT xmlns=\"urn:NumToWordsIntf-INumToWords\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><aNumber xsi:type=\"xsd:int\">" + number + "</aNumber>" + "</ROOT>"};
        return WebServiceSoapClient.call(null, null, inputValues);
    }

    public static String getBookPriceByISBN(String isbn) throws Exception {
        String[] inputValues = new String[]{"c4245525-eeff-460b-a51a-79820047329f", "WebServiceSoapClient", "call", "([Ljava/lang/String;)Ljava/lang/String;", "http://www.xmethods.net/sd/2001/BNQuoteService.wsdl", "BNQuoteService", "<operation name=\"getPrice\" type=\"create\" useStyle=\"encoded\" bindingStyle=\"rpc\"><inputMapping name=\"getPriceRequest\" topLevelElement=\"getPrice\"/><outputMapping name=\"getPriceResponse\" topLevelElement=\"getPriceResponse\"/></operation>", "http://services.xmethods.net:80/soap/servlet/rpcrouter", "urn:xmethods-BNPriceCheck", "dummy-inputMap", "dummy-outputMap", "<ROOT xmlns=\"urn:BNQuoteService\" xmlns:ns1=\"urn:xmethods-BNPriceCheck\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  ><ns1:isbn xsi:type=\"xsd:string\">" + isbn + "</ns1:isbn>" + "</ROOT>"};
        return WebServiceSoapClient.call(null, null, inputValues);
    }

    public static String getSecurityToken() throws Exception {
        String[] inputValues = new String[]{"c4245525-eeff-460b-a51a-79820047329f", "WebServiceSoapClient", "call", "([Ljava/lang/String;)Ljava/lang/String;", "D:\\dev\\files\\bugs\\MarimbaSecurityTicketService1115.wsdl", "SecurityTokenServiceService", "<operation name=\"GenerateTicket\" type=\"create\" useStyle=\"literal\" bindingStyle=\"document\"><inputMapping name=\"GenerateTicket\" topLevelElement=\"GenerateTicket\"/><outputMapping name=\"GenerateTicketReturn\" topLevelElement=\"GenerateTicketResponse\"/></operation>", "http://winslet.eng.bmc.com:8888/shell/services/SecurityTicketService", "http://www.bmc.com/schemas/scm/cms/security", "<?xml version=\"1.0\" encoding=\"windows-1252\"?><arDocMapping name=\"GenerateTicket\" arDocVersion=\"9\" schemaSource=\"imported\"><formMapping><form formName=\"SSO:Launcher\" foreignKeyId=\"1\" primaryKeyId=\"1\" distinguishingKeyId=\"1\"/><element name=\"ROOT\" targetNamespace=\"http://www.bmc.com/schemas/scm/cms/security\"><element name=\"SOAPHeader\" dataType=\"\"><element name=\"UsernameToken\" dataType=\"\" complexType=\"UsernameTokenType\" targetNamespace=\"http://www.bmc.com/schemas/scm/cms/security\"><element name=\"Username\" dataType=\"string\" targetNamespace=\"http://www.bmc.com/schemas/scm/cms/security\"><fieldMapping arFieldId=\"101\"/></element><element name=\"Password\" dataType=\"string\" targetNamespace=\"http://www.bmc.com/schemas/scm/cms/security\"><fieldMapping arFieldId=\"102\"/></element></element></element><element name=\"GenerateTicket\" dataType=\"string\" targetNamespace=\"http://www.bmc.com/schemas/scm/cms/security\"/></element></formMapping></arDocMapping>", "<?xml version=\"1.0\" encoding=\"windows-1252\"?><arDocMapping name=\"GenerateTicketReturn\" arDocVersion=\"9\" schemaSource=\"imported\"><formMapping><form formName=\"SSO:Launcher\" foreignKeyId=\"1\" primaryKeyId=\"1\" distinguishingKeyId=\"1\"/><element name=\"ROOT\" targetNamespace=\"http://www.bmc.com/schemas/scm/cms/security\"><element name=\"GenerateTicketReturn\" dataType=\"string\" targetNamespace=\"http://www.bmc.com/schemas/scm/cms/security\"><fieldMapping arFieldId=\"301716400\"/></element></element></formMapping></arDocMapping>", "<ROOT xmlns=\"http://www.bmc.com/schemas/scm/cms/security\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <SOAPHeader>    <UsernameToken>         <Username>bmc</Username>            <Password>yL+I4iv1YlFVgZWGR7gnNWJz+X6D99pJtG49xsv42QRmCyqJDhxi4iqDc1ZlQ9s8ZdCm4CrCrcjQy8ppk5TLBFyFi5g3YTRXDnqeCGF9c/kiYKgdtIgySA==</Password>       </UsernameToken>    </SOAPHeader>   <GenerateTicket/></ROOT>"};
        return WebServiceSoapClient.call(null, null, inputValues);
    }
}

