/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.client;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PaddedPasswordEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.ws.client.PolicyDetails;
import java.util.List;
import java.util.StringTokenizer;

class ARPolicyLoader {
    static final int FIELD_POLICY_ID = 179;
    static final int FIELD_REQ_SEC_ACTION = 9003;
    static final int FIELD_RES_SEC_ACTION = 9004;
    static final int FIELD_SEC_TOK_REF = 9000;
    static final int FIELD_SIGN_ALIAS = 9005;
    static final int FIELD_SIGN_ALIAS_PASS = 9011;
    static final int FIELD_ENC_ALIAS = 9006;
    static final int FIELD_ENC_ALIAS_PASS = 9009;
    static final int FIELD_PROP_FILE = 9008;
    static final int FIELD_KEYSTORE_FILE = 9007;
    static final int FIELD_HEADER_ENC_FLG = 9019;
    static final int FIELD_ENC_SYM_ALG = 9024;
    static final int FIELD_DISABLE_SIGN_CONFIRM = 9023;
    private ARServerUser arSvrUsr = null;
    private ARPluginContext pluginContext = null;
    private ARPluginInfo pluginInfo = null;
    private String ENC_PASS_KEY = "arwebservicepluginkey";
    static final int[] fieldIds = new int[]{179, 9003, 9004, 9000, 9005, 9011, 9006, 9009, 9008, 9007, 9019, 9024, 9024, 9023};

    ARPolicyLoader(ARPluginContext pluginContext, ARPluginInfo pluginInfo) {
        this.pluginContext = pluginContext;
        this.pluginInfo = pluginInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolicyDetails loadPolicyDetails(String policyId) throws ARException, AREncryptionException {
        PolicyDetails pd = null;
        ARServerUser user = null;
        try {
            user = this.getARSvrUsr();
            user.login();
            pd = this.loadPolicyDetails(user, policyId);
        }
        finally {
            if (user != null) {
                user.logout();
            }
        }
        return pd;
    }

    private PolicyDetails loadPolicyDetails(ARServerUser user, String policyId) throws ARException, AREncryptionException {
        Integer enc_sym_alg;
        byte[] decryptedBuff;
        String passBuff;
        ArithmeticOrRelationalOperand op2;
        ArithmeticOrRelationalOperand op1;
        RelationalOperationInfo rInfo;
        QualifierInfo qInfo;
        List formLst = user.getListForm(0L, FormType.REGULAR.toInt(), null, fieldIds);
        if (formLst == null || formLst.isEmpty()) {
            throw new ARException(2, 9130, "Web Service security configuration form not found");
        }
        String formNm = (String)formLst.get(0);
        List entries = user.getListEntryObjects(formNm, qInfo = new QualifierInfo(rInfo = new RelationalOperationInfo(1, op1 = new ArithmeticOrRelationalOperand(179), op2 = new ArithmeticOrRelationalOperand(new Value(policyId)))), 0, 2, null, fieldIds, false, null);
        if (entries == null || entries.size() == 0) {
            throw new ARException(2, 9130, "Security configuration not found for configuration id:" + policyId);
        }
        Entry entry = (Entry)entries.get(0);
        PolicyDetails pd = new PolicyDetails();
        pd.setPolicyId(policyId);
        if (((Value)entry.get((Object)9003)).getValue() != null) {
            String reqSecAction = this.getSecurityAction((String)((Value)entry.get((Object)9003)).getValue());
            pd.setRequestSecurityAction(reqSecAction);
        }
        if (((Value)entry.get((Object)9004)).getValue() != null) {
            String resSecAction = this.getSecurityAction((String)((Value)entry.get((Object)9004)).getValue());
            pd.setResponseSecurityAction(resSecAction);
        }
        String SecTokRef = this.getKeyIdentifier((Integer)((Value)entry.get((Object)9000)).getValue());
        pd.setSignKeyID(SecTokRef);
        pd.setEncKeyID(SecTokRef);
        if (((Value)entry.get((Object)9005)).getValue() != null) {
            pd.setUserAlias((String)((Value)entry.get((Object)9005)).getValue());
        }
        if (((Value)entry.get((Object)9006)).getValue() != null) {
            pd.setEncryptionUserAlias((String)((Value)entry.get((Object)9006)).getValue());
        }
        PaddedPasswordEncryption cde = new PaddedPasswordEncryption(true, true);
        cde.setPasswordKeyForEncryption(this.ENC_PASS_KEY.getBytes());
        if (((Value)entry.get((Object)9011)).getValue() != null) {
            passBuff = (String)((Value)entry.get((Object)9011)).getValue();
            decryptedBuff = cde.decryptCharData(passBuff.getBytes());
            pd.setUserAliasPassword(new String(decryptedBuff));
        }
        if (((Value)entry.get((Object)9009)).getValue() != null) {
            passBuff = (String)((Value)entry.get((Object)9009)).getValue();
            decryptedBuff = cde.decryptCharData(passBuff.getBytes());
            pd.setEncryptionUserAliasPassword(new String(decryptedBuff));
        }
        if (((Value)entry.get((Object)9019)).getValue() != null) {
            pd.setHeaderEncFlag(true);
        }
        if (((Value)entry.get((Object)9024)).getValue() != null && (enc_sym_alg = (Integer)((Value)entry.get((Object)9024)).getValue()) > 0) {
            if (enc_sym_alg == 1) {
                pd.setEncSymAlg("AES_192");
            }
            if (enc_sym_alg == 2) {
                pd.setEncSymAlg("AES_256");
            }
            if (enc_sym_alg == 3) {
                pd.setEncSymAlg("Triple DES");
            }
        }
        byte[] bt = this.storePolicyFiles(this.pluginContext, user, entry, 9008, formNm);
        pd.setPropBytes(bt);
        bt = this.storePolicyFiles(this.pluginContext, user, entry, 9007, formNm);
        pd.setKsBytes(bt);
        if (((Value)entry.get((Object)9023)).getValue() != null) {
            pd.setSignConfirm(true);
        }
        this.pluginContext.logMessage(this.pluginInfo, 0, "Policy Details:" + pd);
        return pd;
    }

    private String getSecurityAction(String actionString) throws ARException {
        String ret = "";
        String signStr = null;
        String encryptStr = null;
        String tsStr = null;
        StringTokenizer st = new StringTokenizer(actionString, " ");
        while (st.hasMoreTokens()) {
            ret = st.nextToken();
            if (ret.equals("Signature")) {
                signStr = "Signature";
            }
            if (ret.equals("Encrypt")) {
                encryptStr = "Encrypt";
            }
            if (!ret.equals("Timestamp")) continue;
            tsStr = "Timestamp";
        }
        ret = null;
        if (tsStr != null) {
            ret = tsStr;
        }
        if (signStr != null) {
            ret = ret == null ? signStr : ret + " " + signStr;
        }
        if (encryptStr != null) {
            ret = ret == null ? encryptStr : ret + " " + encryptStr;
        }
        return ret;
    }

    private String getKeyIdentifier(int index) throws ARException {
        switch (index) {
            case 0: {
                return "DirectReference";
            }
            case 1: {
                return "IssuerSerial";
            }
        }
        throw new ARException(2, 9130, "Invalid Key Identifier index:" + index);
    }

    private byte[] storePolicyFiles(ARPluginContext context, ARServerUser user, Entry entry, int fieldId, String formNm) throws ARException {
        byte[] bt = user.getEntryBlob(formNm, entry.getEntryId(), fieldId);
        return bt;
    }

    private ARServerUser getARSvrUsr() throws ARException {
        if (this.arSvrUsr == null) {
            String svrNm = this.pluginContext.getARConfigEntry("Server-Name");
            int port = Integer.parseInt(this.pluginContext.getARConfigEntry("TCD-Specific-Port"));
            this.arSvrUsr = new ARServerUser((ARNativeAuthenticationInfo)this.pluginContext, "", svrNm);
            this.arSvrUsr.setPort(port);
        }
        return this.arSvrUsr;
    }
}

