/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.pluginsvr.ARPluginDefinition;
import com.bmc.arsys.pluginsvr.ARPluginDefinitionNodeI;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.PluginGroup;
import com.bmc.arsys.pluginsvr.binding.ARPluginDynamicInstantiateHandler;
import com.bmc.arsys.pluginsvr.legacy.CARDBCPlugin;
import com.bmc.arsys.pluginsvr.legacy.CAREAPlugin;
import com.bmc.arsys.pluginsvr.legacy.CARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.AREAPluggable;
import com.bmc.arsys.pluginsvr.plugins.AREAPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluginRepository;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.PluginClassLoader;
import com.bmc.arsys.pluginsvr.plugins.PluginEnvelope;
import com.bmc.arsys.pluginsvr.plugins.TrustedAREAPluggable;
import com.bmc.arsys.utils.CatalogReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginLoaderRouter {
    private static ClassLoader rootCl = Thread.currentThread().getContextClassLoader();
    private static Logger LOGGER = Logger.getLogger(ARPluginLoaderRouter.class);
    private static ConcurrentHashMap<Thread, ARPluginLoaderRouter> MAP_THREAD_PLUGINSLOADERROUTER = new ConcurrentHashMap();
    private static HashMap<String, URLClassLoader> MAP_PLUGINSET_CLASS_LOADERS = new HashMap();
    private static HashMap<String, URLClassLoader> MAP_PLUGIN_CLASS_LOADERS = new HashMap();
    private static HashMap<String, Class<?>> MAP_PLUGIN_CLASSES = new HashMap();
    public final ARDBCPluginRepository ARDBC = new ARDBCPluginRepository();
    public final AREAPluginRepository AREA = new AREAPluginRepository();
    public final ARFilterAPIPluginRepository FILTERAPI = new ARFilterAPIPluginRepository();

    public static void addPluginRouter(Thread t, ARPluginLoaderRouter router) {
        MAP_THREAD_PLUGINSLOADERROUTER.put(t, router);
    }

    public static ARPluginLoaderRouter getPluginRouter(Thread t) {
        return MAP_THREAD_PLUGINSLOADERROUTER.get(t);
    }

    public static void removePluginRouter(Thread t) {
        ARPluginLoaderRouter router = MAP_THREAD_PLUGINSLOADERROUTER.remove(t);
        router.cleanUpPlugins();
    }

    private static synchronized URLClassLoader getPluginSetClassLoader(String name) {
        return MAP_PLUGINSET_CLASS_LOADERS.get(name);
    }

    private static synchronized void addPluginSetClassLoader(String name, URLClassLoader loader) {
        MAP_PLUGINSET_CLASS_LOADERS.put(name, loader);
    }

    static synchronized URLClassLoader getPluginClassLoader(String name) {
        return MAP_PLUGIN_CLASS_LOADERS.get(name);
    }

    private static synchronized void addPluginClassLoader(String name, URLClassLoader loader) {
        MAP_PLUGIN_CLASS_LOADERS.put(name, loader);
    }

    private static synchronized void addPluginClass(String name, Class<?> clz) {
        MAP_PLUGIN_CLASSES.put(name, clz);
    }

    private static synchronized Class<?> getPluginClass(String name) {
        return MAP_PLUGIN_CLASSES.get(name);
    }

    public static void initializeJavaPlugins() {
        LOGGER.info((Object)"Loading all Java Plugins and Plugin sets");
        String[] args = ARPluginServerConfiguration.getInstance().getCmdLineArgs();
        ArrayList<ARPluginDefinition> topLevelPlugins = ARPluginServerConfiguration.getInstance().getConfiguredPlugins();
        ARPluginLoaderRouter.loadAllPlugins(null, topLevelPlugins, args);
        HashMap<String, PluginGroup> pluginsets = ARPluginServerConfiguration.getInstance().getConfiguredPluginGroups();
        ARPluginLoaderRouter.loadPluginGroups(pluginsets, args);
    }

    private static void logURLs(URL[] urls) {
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                LOGGER.info((Object)("URL" + (i + 1) + ": " + urls[i].toString()));
            }
        }
    }

    private static void loadPluginGroups(HashMap<String, PluginGroup> pluginsets, String[] args) {
        Set<String> keys = pluginsets.keySet();
        for (String groupName : keys) {
            URLClassLoader ucl;
            PluginGroup group;
            block4: {
                LOGGER.info((Object)("Loading Java PluginSet " + groupName));
                group = pluginsets.get(groupName);
                ucl = null;
                ucl = ARPluginLoaderRouter.getPluginSetClassLoader(groupName);
                try {
                    if (ucl != null) break block4;
                    URL[] urls = ARPluginLoaderRouter.getJarURLs(group, true);
                    LOGGER.info((Object)("Number of shared URLs for group " + groupName + " is " + urls.length));
                    ARPluginLoaderRouter.logURLs(urls);
                    ClassLoader parentLoader = null;
                    parentLoader = group.getParent().equals(ARPluginServerConfiguration.DEFAULT_SET_NAME) ? Thread.currentThread().getContextClassLoader() : ARPluginLoaderRouter.getPluginSetClassLoader(group.getParent());
                    ucl = new PluginClassLoader(urls, parentLoader, group.getFolders(), ARPluginServerConfiguration.getInstance().getWorkingDirectory());
                    ARPluginLoaderRouter.addPluginSetClassLoader(groupName, ucl);
                }
                catch (MalformedURLException mue) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + groupName), (Throwable)mue);
                    continue;
                }
                catch (IOException mue) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + groupName), (Throwable)mue);
                    continue;
                }
            }
            LOGGER.info((Object)("Loading all Java Plugins for the group " + groupName));
            ARPluginLoaderRouter.loadAllPlugins(ucl, group.getPlugins(), args);
            ARPluginLoaderRouter.loadPluginGroups(group.getGroups(), args);
        }
    }

    private static void loadAllPlugins(URLClassLoader ucl, ArrayList<ARPluginDefinition> pPluginList, String[] pArgs) {
        for (ARPluginDefinition plugDef : pPluginList) {
            try {
                URLClassLoader pluginucl;
                block7: {
                    ClassLoader parent = null;
                    parent = ucl == null ? Thread.currentThread().getContextClassLoader() : ucl;
                    LOGGER.info((Object)("Attempting to load Java Plugin " + plugDef.getPluginName()));
                    pluginucl = ARPluginLoaderRouter.getPluginClassLoader(plugDef.getPluginName());
                    try {
                        if (pluginucl != null) break block7;
                        URL[] urls = ARPluginLoaderRouter.getJarURLs(plugDef, true);
                        LOGGER.info((Object)("Number of URLs for plugin " + plugDef.getPluginName() + " is " + urls.length));
                        ARPluginLoaderRouter.logURLs(urls);
                        pluginucl = new PluginClassLoader(urls, parent, plugDef.getClassPathFolders(), ARPluginServerConfiguration.getInstance().getWorkingDirectory());
                        ARPluginLoaderRouter.addPluginClassLoader(plugDef.getPluginName(), pluginucl);
                    }
                    catch (MalformedURLException mue) {
                        LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + plugDef.getPluginName()), (Throwable)mue);
                        plugDef.setActive(false);
                        continue;
                    }
                    catch (IOException mue) {
                        LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + plugDef.getPluginName()), (Throwable)mue);
                        plugDef.setActive(false);
                        continue;
                    }
                }
                ARPluginLoaderRouter.loadClass(pluginucl, plugDef, plugDef.getFileName(), plugDef.getClassName(), pArgs);
                if (plugDef.isActive()) {
                    LOGGER.info((Object)("Successfully loaded Java Plugin " + plugDef.getPluginName()));
                    continue;
                }
                LOGGER.info((Object)("Java Plugin " + plugDef.getPluginName() + " is not active"));
            }
            catch (Throwable e) {
                LOGGER.error((Object)("Not able to load Java Plugin : " + plugDef.getPluginName()));
                plugDef.setActive(false);
            }
        }
    }

    static void loadClass(URLClassLoader ucl, ARPluginDefinition plugDef, String pJarPath, String pClassName, String[] args) {
        String pName = plugDef.getPluginName();
        try {
            Class<?> cl = ARPluginLoaderRouter.loadJars(ucl, pName, pJarPath, pClassName, plugDef, args);
            ARPluginLoaderRouter.addPluginClass(pName, cl);
        }
        catch (ARException are) {
            plugDef.setActive(false);
        }
        catch (Throwable e) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + plugDef.getPluginName()), e);
            plugDef.setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> loadJars(URLClassLoader ucl, String name, String pJarPath, String pClassName, ARPluginDefinition plugDef, String[] args) throws ARException {
        String msg;
        boolean flag = false;
        boolean flagAR = false;
        Class<?> pcl = null;
        try {
            pcl = Class.forName(pClassName, true, ucl);
            try {
                if (pcl != null) {
                    Method init = pcl.getMethod("init", ARPluginContext.class);
                    if (init != null) {
                        ARPluginContext context = new ARPluginContext();
                        context.setCmdLineArgs(args);
                        ARPluginInfo info = new ARPluginInfo(plugDef.getPluginName(), plugDef.getVersion(), true);
                        context.setPluginInfo(info);
                        init.invoke(null, context);
                    }
                    flag = true;
                }
            }
            catch (NoSuchMethodException ne) {
                LOGGER.info((Object)("No static init routine found, skipping init call - " + name));
            }
            catch (SecurityException se) {
                LOGGER.warn((Object)("Exception while finding static init method - " + name), (Throwable)se);
            }
            catch (InvocationTargetException ie) {
                LOGGER.warn((Object)("Invocation exception for static init method - " + name), (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                LOGGER.warn((Object)("Illegal Access exception for static init method - " + name), (Throwable)iae);
            }
            catch (IllegalArgumentException ile) {
                LOGGER.warn((Object)("Illegal argument exception for static init method - " + name), (Throwable)ile);
            }
            catch (Throwable e) {
                LOGGER.warn((Object)("Exception in static init method - " + name), e);
            }
            finally {
                if (flag) {
                    msg = "Done invoking static init method in plugin " + name;
                    LOGGER.debug((Object)msg);
                }
            }
            flagAR = true;
        }
        catch (ClassNotFoundException cnfe) {
            try {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + name), (Throwable)cnfe);
                throw new ARException(2, 8756, cnfe.getLocalizedMessage());
                catch (ClassCastException cce) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + name), (Throwable)cce);
                    throw new ARException(2, 8756, cce.getLocalizedMessage());
                }
                catch (Throwable e) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Plugin: " + name), e);
                    throw new ARException(2, 8756, e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                String msg2 = (flagAR ? "Done " : "Failed ") + " to call init plugin " + name;
                if (!flagAR) {
                    LOGGER.error((Object)msg2);
                    throw throwable;
                }
                LOGGER.info((Object)msg2);
                throw throwable;
            }
        }
        msg = (flagAR ? "Done " : "Failed ") + " to call init plugin " + name;
        if (!flagAR) {
            LOGGER.error((Object)msg);
            return pcl;
        }
        LOGGER.info((Object)msg);
        return pcl;
    }

    private static URL[] getJarURLs(ARPluginDefinitionNodeI plugindef, boolean create) throws IOException {
        ArrayList<URL> cps = new ArrayList<URL>();
        if (plugindef != null) {
            ArrayList<String> jars;
            File cpJar;
            String fileName;
            ArrayList<String> folders = plugindef.getClassPathFolders();
            if (folders != null) {
                for (String folder : folders) {
                    File cpFolder = new File(folder);
                    if (!cpFolder.exists()) continue;
                    cps.add(cpFolder.toURI().toURL());
                }
            }
            if ((fileName = plugindef.getFileName()) != null && (cpJar = new File(fileName)).exists()) {
                cps.add(cpJar.toURI().toURL());
            }
            if ((jars = plugindef.getClassPathJars()) != null) {
                for (String jar : jars) {
                    File cpJar2 = new File(jar);
                    if (!cpJar2.exists()) continue;
                    cps.add(cpJar2.toURI().toURL());
                }
            }
            ARPluginLoaderRouter.getAllManifest(create, cps, jars, folders);
        }
        return cps.toArray(new URL[0]);
    }

    private static void getAllManifest(boolean create, List<URL> cps, ArrayList<String> jars, ArrayList<String> folders) throws IOException {
        if (jars != null && jars.size() > 0) {
            for (String jar : jars) {
                try {
                    File pluginJarFile = new File(jar);
                    JarFile jf = null;
                    try {
                        jf = new JarFile(pluginJarFile);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (jf == null || folders == null || folders.size() <= 0) continue;
                    for (String folder : folders) {
                        File pluginFolder = new File(folder);
                        ARPluginLoaderRouter.getManifest(create, cps, jf, pluginFolder);
                    }
                }
                catch (Exception e) {
                }
            }
        }
    }

    private static void getManifest(boolean create, List<URL> cps, JarFile jf, File pluginFolder) throws IOException {
        Attributes ma;
        String cp;
        Manifest mf = jf.getManifest();
        if (mf != null && (cp = (ma = mf.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String fname = st.nextToken();
                URL u = ARPluginLoaderRouter.getDependentJarURL(jf, pluginFolder, fname, create);
                if (u == null) continue;
                cps.add(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL getDependentJarURL(JarFile jf, File parent, String fname, boolean create) throws IOException {
        ZipEntry depEntry = jf.getEntry(fname);
        if (depEntry != null) {
            File depJar = new File(parent, fname);
            if (create || !depJar.exists()) {
                depJar.getParentFile().mkdirs();
                InputStream is = jf.getInputStream(depEntry);
                try {
                    ARPluginLoaderRouter.copyStreamDataToFile(is, depJar);
                }
                finally {
                    is.close();
                }
            }
            return depJar.toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamDataToFile(InputStream is, File output) throws IOException {
        FileOutputStream fos = new FileOutputStream(output);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            int len;
            byte[] buff = new byte[8192];
            while ((len = is.read(buff)) != -1) {
                bos.write(buff, 0, len);
            }
        }
        finally {
            bos.close();
        }
    }

    public ARPluginLoaderRouter() {
        String[] args = ARPluginServerConfiguration.getInstance().getCmdLineArgs();
        ArrayList<ARPluginDefinition> topLevelPlugins = ARPluginServerConfiguration.getInstance().getConfiguredPlugins();
        this.instantiateAllPlugins(null, topLevelPlugins, args);
        HashMap<String, PluginGroup> pluginsets = ARPluginServerConfiguration.getInstance().getConfiguredPluginGroups();
        this.instantiatePluginGroups(pluginsets, args);
        ArrayList<ARPluginDefinition> nativePlugins = ARPluginServerConfiguration.getInstance().getNativePlugins();
        this.loadNativePluginWrappers(nativePlugins);
    }

    public void initializeInstanceData(ARPluginContext context) {
    }

    public void cleanUpPlugins() {
        ARPluginContext context = new ARPluginContext();
        context.setCmdLineArgs(ARPluginServerConfiguration.getInstance().getCmdLineArgs());
        this.AREA.terminatePlugins(context);
        this.FILTERAPI.terminatePlugins(context);
        this.ARDBC.terminatePlugins(context);
    }

    private void loadNativePluginWrappers(ArrayList<ARPluginDefinition> nativePlugins) {
        if (PluginProxy.IsNativeMethodAccessible()) {
            for (int i = 0; i < nativePlugins.size(); ++i) {
                ARPluginDefinition def = nativePlugins.get(i);
                String code = def.getPluginCode();
                String type = def.getPluginType();
                String name = def.getPluginName();
                if (code == null || !code.equalsIgnoreCase("C")) continue;
                try {
                    PluginEnvelope pEnvelope;
                    ARPlugin plugin;
                    if (type.equalsIgnoreCase("FilterAPI")) {
                        plugin = new CARFilterAPIPlugin(name);
                        pEnvelope = new PluginEnvelope(plugin, new ARPluginInfo(name, 2, false));
                        this.FILTERAPI.addPlugin(name, pEnvelope);
                        continue;
                    }
                    if (type.equalsIgnoreCase("ARDBC")) {
                        plugin = new CARDBCPlugin(name);
                        pEnvelope = new PluginEnvelope(plugin, new ARPluginInfo(name, 4, false));
                        this.ARDBC.addPlugin(name, pEnvelope);
                        continue;
                    }
                    if (!type.equalsIgnoreCase("AREA")) continue;
                    plugin = new CAREAPlugin(name);
                    pEnvelope = new PluginEnvelope(plugin, new ARPluginInfo(name, 3, false));
                    this.AREA.addPlugin(name, pEnvelope);
                    continue;
                }
                catch (ARException e) {
                    LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8767) + " Plugin: " + name), (Throwable)e);
                }
            }
        }
    }

    public void instantiatePluginGroups(HashMap<String, PluginGroup> pluginsets, String[] args) {
        Set<String> keys = pluginsets.keySet();
        for (String groupName : keys) {
            LOGGER.info((Object)("Creating instances of all plugins in the group " + groupName));
            PluginGroup group = pluginsets.get(groupName);
            URLClassLoader ucl = null;
            ucl = ARPluginLoaderRouter.getPluginSetClassLoader(groupName);
            if (ucl == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + " Group: " + groupName));
                continue;
            }
            this.instantiateAllPlugins(ucl, group.getPlugins(), args);
            this.instantiatePluginGroups(group.getGroups(), args);
        }
    }

    public void instantiateAllPlugins(URLClassLoader ucl, ArrayList<ARPluginDefinition> pPluginList, String[] pArgs) {
        for (ARPluginDefinition plugDef : pPluginList) {
            if (!plugDef.isActive()) continue;
            Class<?> cl = null;
            LOGGER.info((Object)("Attempting to Create an instance of the plugin " + plugDef.getPluginName()));
            URLClassLoader pluginucl = ARPluginLoaderRouter.getPluginClassLoader(plugDef.getPluginName());
            if (pluginucl == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + plugDef.getFileName()));
                continue;
            }
            cl = ARPluginLoaderRouter.getPluginClass(plugDef.getPluginName());
            if (cl == null) {
                LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + plugDef.getFileName()));
                continue;
            }
            this.loadPlugin(pluginucl, cl, plugDef, pArgs);
        }
    }

    void loadPlugin(URLClassLoader ucl, Class<?> cl, ARPluginDefinition plugDef, String[] args) {
        String pName = plugDef.getPluginName();
        boolean doneFlag = false;
        try {
            ARPluggable pl = this.instantiatePlugin(cl, ucl);
            ARPluginInfo info = new ARPluginInfo(plugDef.getPluginName(), plugDef.getVersion(), !plugDef.getPluginCode().equals("C"));
            PluginEnvelope pluginEnvelope = this.initializePlugin(pName, args, pl, info);
            if (pluginEnvelope == null) {
                plugDef.setActive(false);
                return;
            }
            pName = pluginEnvelope.getPluginName();
            if (pl instanceof ARFilterAPIPluggable) {
                this.FILTERAPI.addPlugin(pName, pluginEnvelope);
            } else if (pl instanceof AREAPluggable) {
                TrustedAREAPluggable trustedPlugin;
                int key;
                if (pl instanceof TrustedAREAPluggable && (key = (trustedPlugin = (TrustedAREAPluggable)pl).secretKey()) > 0) {
                    pluginEnvelope.setTrustedAreaPluginFlag(true);
                }
                this.AREA.addPlugin(pName, pluginEnvelope);
            } else if (pl instanceof ARDBCPluggable) {
                this.ARDBC.addPlugin(pName, pluginEnvelope);
            }
            doneFlag = true;
        }
        catch (ARException are) {
            plugDef.setActive(false);
        }
        catch (Throwable e) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pName), e);
            plugDef.setActive(false);
        }
        String msg = "Thread " + Thread.currentThread().getId() + (doneFlag ? " successfully created an instance of " : " failed to create an instance of ") + pName;
        if (doneFlag) {
            LOGGER.info((Object)msg);
        } else {
            LOGGER.error((Object)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginEnvelope initializePlugin(String pName, String[] args, ARPluggable pPlugin, ARPluginInfo pluginInfo) throws ARException {
        assert (pPlugin != null);
        ARPluginContext dummyContext = new ARPluginContext();
        if (pPlugin == null) {
            return null;
        }
        String id = pluginInfo.getName();
        dummyContext.setCmdLineArgs(args);
        dummyContext.setPluginInfo(pluginInfo);
        if (id != null) {
            PluginEnvelope envelope = this.getPluginFromAnyMap(id);
            Object instance = null;
            if (envelope == null) {
                try {
                    Thread.currentThread().setContextClassLoader(ARPluginLoaderRouter.getPluginClassLoader(id));
                    pPlugin.initialize(dummyContext);
                    PluginEnvelope pluginEnvelope = envelope = new PluginEnvelope(pPlugin, pluginInfo, instance);
                    return pluginEnvelope;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(rootCl);
                }
            }
        }
        return null;
    }

    private PluginEnvelope getPluginFromAnyMap(String pName) {
        PluginEnvelope envelope = null;
        envelope = this.FILTERAPI.getPlugin(pName);
        if (envelope != null) {
            return envelope;
        }
        envelope = this.AREA.getPlugin(pName);
        if (envelope != null) {
            return envelope;
        }
        envelope = this.ARDBC.getPlugin(pName);
        return envelope;
    }

    private ARPluggable instantiatePlugin(Class<?> pcl, URLClassLoader ucl) throws ARException {
        ARPluggable pl = null;
        try {
            pl = (ARPluggable)pcl.newInstance();
            if (pl.getClass().getClassLoader() != ucl) {
                LOGGER.info((Object)("The plugin " + pl.getClass() + " for " + pcl.getName() + " has been loaded by a parent classloader."));
            }
        }
        catch (InstantiationException ie) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pcl.getName()), (Throwable)ie);
            throw new ARException(2, 8756, ie.getLocalizedMessage());
        }
        catch (ClassCastException cce) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pcl.getName()), (Throwable)cce);
            throw new ARException(2, 8756, cce.getLocalizedMessage());
        }
        catch (IllegalAccessException iae) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pcl.getName()), (Throwable)iae);
            throw new ARException(2, 8756, iae.getLocalizedMessage());
        }
        catch (Throwable e) {
            LOGGER.error((Object)(CatalogReader.getInstance().getMessage(8756) + pcl.getName()), e);
            throw new ARException(2, 8756, e.getLocalizedMessage());
        }
        return pl;
    }

    public static void initializeNewJavaPlugins(ArrayList<ARPluginDefinition> newTopLevelPlugins, HashMap<String, PluginGroup> newPluginGroups, String[] args) {
        LOGGER.info((Object)"Loading all Newly configured Java Plugins and Plugin sets");
        ARPluginLoaderRouter.loadAllPlugins(null, newTopLevelPlugins, args);
        ARPluginLoaderRouter.loadPluginGroups(newPluginGroups, args);
    }

    public static void instantiateNewJavaPlugins(ArrayList<ARPluginDefinition> newTopLevelPlugins, HashMap<String, PluginGroup> newPluginGroups, String[] args) {
        Thread t1 = new Thread(new ARPluginDynamicInstantiateHandler(newTopLevelPlugins, newPluginGroups, args));
        t1.start();
    }

    public static Set<Thread> getAllThreads() {
        Set ts = MAP_THREAD_PLUGINSLOADERROUTER.keySet();
        for (Thread t : ts) {
            LOGGER.trace((Object)("Exising thread " + t.getId() + " " + t.getName()));
            if (t.isAlive()) continue;
            ts.remove(t);
        }
        return ts;
    }

    public static boolean findThread(Thread t1) {
        Set ts = MAP_THREAD_PLUGINSLOADERROUTER.keySet();
        boolean flag = false;
        for (Thread t : ts) {
            if (!t.isAlive()) {
                ts.remove(t);
                continue;
            }
            if (!t.equals(t1)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static void prePluginCall(ARPluginContext context, String remoteHostCharSet) {
        context.setRemoteHostCharSet(remoteHostCharSet);
        if (context.getPluginInfo() != null && context.getPluginInfo().getName() != null) {
            URLClassLoader cl = ARPluginLoaderRouter.getPluginClassLoader(context.getPluginInfo().getName());
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            Thread.currentThread().setContextClassLoader(rootCl);
        }
    }
}

