/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.arealdap;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.plugins.arealdap.LDAPConstants;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;

public class LDAPProps
implements LDAPConstants {
    private String authHost;
    private String authPort;
    private String bindUser;
    private String bindPasswd;
    private String URL;
    private int timeout = 40;
    private String userBase;
    private String userFilter;
    private String chaseReferral;
    private boolean useSSL = false;
    private String emailAttribName;
    private String defaultEmail;
    private int useGroups;
    private String rolesAttribName;
    private String defaultRoles;
    private String notifyMechAttribName;
    private int defaultNotifyMech;
    private String licenseMaskAttribName;
    private String licenseTypeAttribName;
    private String licenseFTSAttribName;
    private String licenseRes1AttribName;
    private String licenseAppAttribName;
    private String groupBase;
    private String groupFilter;
    private String defaultGroups;

    public void init(ARPluginContext pluginContext) {
        this.setAuthHost(pluginContext.getARConfigEntry("AREA-LDAP-Hostname"));
        this.setAuthPort(pluginContext.getARConfigEntry("AREA-LDAP-Port"));
        this.setBindUser(pluginContext.getARConfigEntry("AREA-LDAP-Bind-User"));
        this.setBindPasswd(pluginContext.getARConfigEntry("AREA-LDAP-Bind-Password"));
        this.setTimeout(pluginContext.getARConfigEntry("AREA-LDAP-Connect-Timeout"));
        this.setURL("ldap://" + this.getAuthHost() + ":" + this.getAuthPort() + "/");
        this.setUserBase(pluginContext.getARConfigEntry("AREA-LDAP-User-Base"));
        this.setUserFilter(pluginContext.getARConfigEntry("AREA-LDAP-User-Filter"));
        this.setChaseReferral(pluginContext.getARConfigEntry("AREA-LDAP-Chase-Referral"));
        this.setUseSSL(pluginContext.getARConfigEntry("AREA-LDAP-UseSSL"));
        this.setEmailAttribName(pluginContext.getARConfigEntry("AREA-LDAP-Email"));
        this.setDefaultEmail(pluginContext.getARConfigEntry("AREA-LDAP-Email-Default"));
        this.setUseGroups(pluginContext.getARConfigEntry("AREA-LDAP-Use-Groups"));
        this.setRolesAttribName(pluginContext.getARConfigEntry("AREA-LDAP-Roles"));
        this.setDefaultRoles(pluginContext.getARConfigEntry("AREA-LDAP-Roles-Default"));
        this.setNotifyMeth(pluginContext.getARConfigEntry("AREA-LDAP-Notify-Meth"));
        this.setDefaultNotifyMech(pluginContext.getARConfigEntry("AREA-LDAP-Notify-Meth-Default"));
        this.setLicenseMaskAttribName(pluginContext.getARConfigEntry("AREA-LDAP-LicMask"));
        this.setLicenseTypeAttribName(pluginContext.getARConfigEntry("AREA-LDAP-Lic"));
        this.setLicenseFTSAttribName(pluginContext.getARConfigEntry("AREA-LDAP-LicFTS"));
        this.setLicenseRes1AttribName(pluginContext.getARConfigEntry("AREA-LDAP-LicRes1"));
        this.setLicenseAppAttribName(pluginContext.getARConfigEntry("AREA-LDAP-LicAPP"));
        this.setGroupBase(pluginContext.getARConfigEntry("AREA-LDAP-Group-Base"));
        this.setGroupFilter(pluginContext.getARConfigEntry("AREA-LDAP-Group-Filter"));
        this.setDefaultGroups(pluginContext.getARConfigEntry("AREA-LDAP-Group-Default"));
    }

    public void setAuthHost(String authHost) {
        this.authHost = authHost;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    public void setAuthPort(String authPort) {
        this.authPort = authPort;
    }

    public String getAuthPort() {
        return this.authPort;
    }

    public void setBindUser(String bindUser) {
        this.bindUser = bindUser;
    }

    public String getBindUser() {
        return this.bindUser;
    }

    public void setBindPasswd(String bindPasswd) {
        PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
        byte[] decPasswd = null;
        try {
            decPasswd = pwdEnc.decryptPasswordEx(bindPasswd.getBytes());
        }
        catch (AREncryptionException e) {
            e.printStackTrace();
        }
        this.bindPasswd = new String(decPasswd);
    }

    public String getBindPasswd() {
        return this.bindPasswd;
    }

    public void setURL(String uRL) {
        this.URL = uRL;
    }

    public String getURL() {
        return this.URL;
    }

    public void setTimeout(String connectTimeout) {
        try {
            this.timeout = Integer.parseInt(connectTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setChaseReferral(String chaseReferral) {
        this.chaseReferral = chaseReferral;
    }

    public String getChaseReferral() {
        return this.chaseReferral;
    }

    public void setUseSSL(String useSSL) {
        if ("T".equalsIgnoreCase(useSSL)) {
            this.useSSL = true;
        }
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setEmailAttribName(String emailAttribName) {
        this.emailAttribName = emailAttribName;
    }

    public String getEmailAttribName() {
        return this.emailAttribName;
    }

    public void setUseGroups(String useGroups) {
        try {
            this.useGroups = Integer.parseInt(useGroups);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getUseGroups() {
        return this.useGroups;
    }

    public void setRolesAttribName(String rolesAttribName) {
        this.rolesAttribName = rolesAttribName;
    }

    public String getRolesAttribName() {
        return this.rolesAttribName;
    }

    public void setNotifyMeth(String notifyMeth) {
        this.notifyMechAttribName = notifyMeth;
    }

    public String getNotifyMeth() {
        return this.notifyMechAttribName;
    }

    public void setLicenseMaskAttribName(String licenseMaskAttribName) {
        this.licenseMaskAttribName = licenseMaskAttribName;
    }

    public String getLicenseMaskAttribName() {
        return this.licenseMaskAttribName;
    }

    public void setLicenseTypeAttribName(String licenseTypeAttribName) {
        this.licenseTypeAttribName = licenseTypeAttribName;
    }

    public String getLicenseTypeAttribName() {
        return this.licenseTypeAttribName;
    }

    public void setDefaultEmail(String defaultEmail) {
        this.defaultEmail = defaultEmail;
    }

    public String getDefaultEmail() {
        return this.defaultEmail;
    }

    public void setDefaultNotifyMech(String defaultNotifyMech) {
        try {
            this.defaultNotifyMech = Integer.parseInt(defaultNotifyMech);
        }
        catch (NumberFormatException ne) {
            this.defaultNotifyMech = 0;
        }
    }

    public int getDefaultNotifyMech() {
        return this.defaultNotifyMech;
    }

    public void setDefaultRoles(String defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public String getDefaultRoles() {
        return this.defaultRoles;
    }

    public void setLicenseFTSAttribName(String licenseFTSAttribName) {
        this.licenseFTSAttribName = licenseFTSAttribName;
    }

    public String getLicenseFTSAttribName() {
        return this.licenseFTSAttribName;
    }

    public void setLicenseRes1AttribName(String licenseRes1AttribName) {
        this.licenseRes1AttribName = licenseRes1AttribName;
    }

    public String getLicenseRes1AttribName() {
        return this.licenseRes1AttribName;
    }

    public void setLicenseAppAttribName(String licenseAppAttribName) {
        this.licenseAppAttribName = licenseAppAttribName;
    }

    public String getLicenseAppAttribName() {
        return this.licenseAppAttribName;
    }

    public void setGroupBase(String groupBase) {
        this.groupBase = groupBase;
    }

    public String getGroupBase() {
        return this.groupBase;
    }

    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public void setDefaultGroups(String defaultGroups) {
        this.defaultGroups = defaultGroups;
    }

    public String getDefaultGroups() {
        return this.defaultGroups;
    }
}

