/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzerConfigReader;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSStemmingFilter;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSThesaurusFilter;
import com.bmc.arsys.fts.impl.lucene.analyzers.LiteralTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.SinkTokenizer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.index.Term;
import org.tartarus.snowball.SnowballProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSAnalyzer
extends Analyzer {
    private static final Logger LOGGER = Logger.getLogger(FTSAnalyzer.class);
    private Set<String> stopSet = new HashSet<String>();
    private Hashtable<String, String> rootTable = new Hashtable();
    private static Hashtable<String, String[]> thesTable = new Hashtable();
    private Set<String> regexSet = new HashSet<String>();
    private Analyzer indexAnalyzer = null;
    private Analyzer searchAnalyzer = null;
    private SnowballProgram stemmer = null;
    private boolean useStopwords = false;
    private boolean useRootwords = false;
    private boolean useThesuarus = false;
    private boolean useRegex = false;
    private boolean useIndexAnalyzer = false;
    private boolean useSearchAnalyzer = false;
    private boolean useStemmer = false;
    private boolean isSearch = false;
    private FTSAnalyzerConfigReader.FTSAnalyzerConfig config = null;
    public static final String[] STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;
    public static final String STOPWORD_TOKEN = "~!~STOPWORD~!~";
    private boolean isCaseSensitive = false;
    private boolean isLiteral = false;
    private boolean doStemming = true;
    private boolean isInWildcardProcessing = false;
    public SinkTokenizer sink1 = new SinkTokenizer(null);
    public TokenStream source1 = null;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public FTSAnalyzer(FTSAnalyzerConfigReader.FTSAnalyzerConfig configArg, boolean caseSensitive) {
        this.config = configArg;
        this.reload(caseSensitive);
    }

    public void reload(boolean caseSensitive) {
        Class<?> analyzeClass;
        Iterator i;
        HashSet tempSet;
        File file;
        this.isCaseSensitive = caseSensitive;
        if (this.config.rootwordfile != null && !this.config.rootwordfile.equals("") && (file = new File(this.config.rootwordfile)).exists()) {
            try {
                tempSet = new HashSet();
                tempSet = WordlistLoader.getWordSet((File)file);
                i = tempSet.iterator();
                while (i.hasNext()) {
                    String[] words = ((String)i.next()).split(" ");
                    String rootWord = words[0];
                    for (int x = 0; x < words.length; ++x) {
                        this.rootTable.put(words[x], rootWord);
                    }
                }
                this.useRootwords = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.thesaurusfile != null && !this.config.thesaurusfile.equals("") && (file = new File(this.config.thesaurusfile)).exists()) {
            try {
                tempSet = new HashSet();
                tempSet = WordlistLoader.getWordSet((File)file);
                i = tempSet.iterator();
                int count = 0;
                while (i.hasNext()) {
                    String[] words = ((String)i.next()).split(" ");
                    for (int a = 0; a < words.length; ++a) {
                        String workingWord = words[a];
                        String[] synonyms = new String[words.length - 1];
                        for (int x = 0; x < words.length; ++x) {
                            int count2 = 0;
                            for (int y = 0; y < words.length; ++y) {
                                if (words[y].equals(workingWord)) continue;
                                synonyms[count2] = words[y];
                                ++count2;
                            }
                        }
                        thesTable.put(workingWord, synonyms);
                        ++count;
                    }
                }
                this.useThesuarus = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.regexfile != null && !this.config.regexfile.equals("") && (file = new File(this.config.regexfile)).exists()) {
            try {
                this.regexSet = WordlistLoader.getWordSet((File)file);
                this.useRegex = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.stemmer != null && !this.config.stemmer.equals("")) {
            try {
                Class<?> stemClass = this.config.stemmer.indexOf(".") > -1 ? Class.forName(this.config.stemmer) : Class.forName("org.tartarus.snowball.ext." + this.config.stemmer + "Stemmer");
                this.stemmer = (SnowballProgram)stemClass.newInstance();
                this.useStemmer = true;
            }
            catch (Exception e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the stemmer"), (Throwable)e);
            }
        }
        if (this.config.stopwordfile != null && !this.config.stopwordfile.equals("") && (file = new File(this.config.stopwordfile)).exists()) {
            try {
                this.stopSet = this.stopwordStemmer(WordlistLoader.getWordSet((File)file));
                this.useStopwords = true;
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
        if (this.config.indexAnalyzer != null && !this.config.indexAnalyzer.equals("")) {
            try {
                analyzeClass = Class.forName(this.config.indexAnalyzer);
                this.indexAnalyzer = (Analyzer)analyzeClass.newInstance();
                this.useIndexAnalyzer = true;
            }
            catch (Exception e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the indexAnalyzer"), (Throwable)e);
            }
        }
        if (this.config.searchAnalyzer != null && !this.config.searchAnalyzer.equals("")) {
            try {
                analyzeClass = Class.forName(this.config.searchAnalyzer);
                this.searchAnalyzer = (Analyzer)analyzeClass.newInstance();
                this.useSearchAnalyzer = true;
            }
            catch (Exception e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the searchAnalyzer"), (Throwable)e);
            }
        }
        this.setPreviousTokenStream(null);
    }

    private Set<String> stopwordStemmer(HashSet<String> stopwords) {
        if (this.doStemming && this.stemmer != null) {
            HashSet<String> stemmedStopwords = new HashSet<String>();
            for (String stopword : stopwords) {
                this.stemmer.setCurrent(stopword);
                this.stemmer.stem();
                stemmedStopwords.add(this.stemmer.getCurrent());
            }
            return stemmedStopwords;
        }
        return stopwords;
    }

    public FTSAnalyzer(String string, boolean caseSensitivity) {
        File file;
        this.isCaseSensitive = caseSensitivity;
        if (string != null && !string.equals("") && (file = new File(string)).exists()) {
            try {
                this.stopSet = WordlistLoader.getWordSet((File)file);
            }
            catch (IOException e) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)e);
            }
        }
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result;
        this.checkFieldName(fieldName);
        if (this.isLiteral) {
            LiteralTokenizer literalTokenizer = new LiteralTokenizer(reader);
            if (!this.isCaseSensitive) {
                literalTokenizer = new LowerCaseFilter((TokenStream)literalTokenizer);
            }
            return literalTokenizer;
        }
        if (this.useIndexAnalyzer && !this.isSearch) {
            result = this.indexAnalyzer.tokenStream(fieldName, reader);
        } else if (this.useSearchAnalyzer && this.isSearch) {
            result = this.searchAnalyzer.tokenStream(fieldName, reader);
        } else {
            StandardTokenizer tokenStream = new StandardTokenizer(reader, true);
            tokenStream.setMaxTokenLength(this.maxTokenLength);
            result = new StandardFilter((TokenStream)tokenStream);
        }
        if (!this.isCaseSensitive && !this.useIndexAnalyzer) {
            result = new LowerCaseFilter(result);
        }
        if (!this.isSearch && this.useThesuarus && this.doStemming) {
            result = new FTSThesaurusFilter((TokenStream)result, thesTable);
        }
        if (this.doStemming && this.useStemmer) {
            result = new FTSStemmingFilter((TokenStream)result, this.stemmer, this.rootTable);
        }
        if (this.useStopwords) {
            StopFilter stopFilter = new StopFilter(result, this.stopSet);
            stopFilter.setEnablePositionIncrements(true);
            result = stopFilter;
        }
        return result;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    private void checkFieldName(String fieldName) {
        this.isLiteral = fieldName.endsWith("_literal") || fieldName.endsWith("_literalCase");
        if (fieldName.equals("entryid") || fieldName.equals("docid") || fieldName.equals("schemaid")) {
            this.isLiteral = true;
        }
        if (fieldName.endsWith("_noStem") || fieldName.endsWith("_caseNoStem")) {
            this.doStemming = false;
        } else if (!this.isInWildcardProcessing) {
            this.doStemming = true;
        }
    }

    private String getFilteredTokenStreamKey() {
        StringBuffer sb = new StringBuffer("");
        if (this.isLiteral) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.isCaseSensitive) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useIndexAnalyzer) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useSearchAnalyzer) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useStopwords) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useThesuarus) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.doStemming) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        if (this.useStemmer) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        String filteredTokenStreamKey;
        Object filteredTokenStream;
        if (this.useIndexAnalyzer) {
            return this.tokenStream(fieldName, reader);
        }
        this.checkFieldName(fieldName);
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new StandardTokenizer(reader);
            streams.tokenStreamLiteral = new LiteralTokenizer(reader);
        }
        if ((filteredTokenStream = streams.getFilteredTokenStream(filteredTokenStreamKey = this.getFilteredTokenStreamKey())) == null) {
            if (this.isLiteral) {
                filteredTokenStream = !this.isCaseSensitive ? new LowerCaseFilter((TokenStream)streams.tokenStreamLiteral) : streams.tokenStreamLiteral;
            } else {
                filteredTokenStream = new StandardFilter((TokenStream)streams.tokenStream);
                if (!this.isCaseSensitive && !this.useIndexAnalyzer) {
                    filteredTokenStream = new LowerCaseFilter(filteredTokenStream);
                }
                if (!this.isSearch && this.useThesuarus && this.doStemming) {
                    filteredTokenStream = new FTSThesaurusFilter((TokenStream)filteredTokenStream, thesTable);
                }
                if (this.doStemming && this.useStemmer) {
                    filteredTokenStream = new FTSStemmingFilter((TokenStream)filteredTokenStream, this.stemmer, this.rootTable);
                }
                if (this.useStopwords) {
                    StopFilter stopFilter = new StopFilter(filteredTokenStream, this.stopSet);
                    stopFilter.setEnablePositionIncrements(true);
                    filteredTokenStream = stopFilter;
                }
            }
            streams.setFilteredTokenStream(filteredTokenStreamKey, (TokenStream)filteredTokenStream);
        }
        if (this.isLiteral) {
            streams.tokenStreamLiteral.reset(reader);
        } else {
            streams.tokenStream.reset(reader);
        }
        return filteredTokenStream;
    }

    public Term analyzeSearchTerm(String fieldName, String searchTerm, boolean hasWildcard) {
        if (hasWildcard) {
            return this.analyzeSearchWildcardTerm(fieldName, searchTerm);
        }
        return this.analyzeSearchTerm(fieldName, searchTerm);
    }

    public ArrayList<Term> analyzeSearchPhrase(String fieldName, String searchPhrase, boolean hasWildcard) {
        if (hasWildcard) {
            return this.analyzeSearchWildcardPhrase(fieldName, searchPhrase);
        }
        return this.analyzeSearchPhrase(fieldName, searchPhrase);
    }

    private Term analyzeSearchTerm(String fieldName, String searchTerm) {
        this.isSearch = true;
        Term term = null;
        TokenStream tokenStream = this.tokenStream(fieldName, new StringReader(searchTerm));
        try {
            term = new Term(fieldName, tokenStream.next().term());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.isSearch = false;
        return term;
    }

    private ArrayList<Term> analyzeSearchPhrase(String fieldName, String searchPhrase) {
        ArrayList<Term> arrayList;
        block6: {
            this.isSearch = true;
            arrayList = new ArrayList<Term>();
            TokenStream tokenStream = this.tokenStream(fieldName, new StringReader(searchPhrase));
            boolean processTokens = true;
            try {
                while (processTokens) {
                    Token token = tokenStream.next();
                    if (token == null) {
                        processTokens = false;
                        break;
                    }
                    int pos = token.getPositionIncrement();
                    if (pos == 0) continue;
                    if (pos > 1) {
                        for (int x = 0; x < pos - 1; ++x) {
                            arrayList.add(null);
                        }
                    }
                    String strTerm = token.term();
                    arrayList.add(new Term(fieldName, strTerm));
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " analyzeSearchPhrase: failed to get next term "), (Throwable)e);
            }
        }
        this.isSearch = false;
        return arrayList;
    }

    private Term analyzeSearchWildcardTerm(String fieldName, String searchTerm) {
        this.isSearch = true;
        this.checkFieldName(fieldName);
        if (!this.isCaseSensitive) {
            searchTerm = searchTerm.toLowerCase();
        }
        this.isSearch = false;
        return new Term(fieldName, searchTerm);
    }

    private ArrayList<Term> analyzeSearchWildcardPhrase(String fieldName, String searchPhrase) {
        this.isSearch = true;
        this.isInWildcardProcessing = true;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        String[] termValues = searchPhrase.split(" ");
        this.doStemming = false;
        for (int x = 0; x < termValues.length; ++x) {
            if (termValues[x].matches("[\\W && [^\\d] && [^\u3100-\u312f\u3040-\u309f\u30a0-\u30ff\u31f0-\u31ff\u3300-\u337f\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\uff65-\uff9f]]+")) continue;
            ArrayList<Term> terms = this.analyzeSearchPhrase(fieldName, termValues[x]);
            if (termValues[x].indexOf("*") > -1) {
                if (terms.size() > 1) {
                    for (Term t : terms) {
                        if (t == null) {
                            arrayList.add(new Term(fieldName, STOPWORD_TOKEN));
                            continue;
                        }
                        arrayList.add(this.wildcardTheTerm(t, termValues[x]));
                    }
                    continue;
                }
                if (terms.size() == 0) {
                    arrayList.add(new Term(fieldName, STOPWORD_TOKEN));
                    continue;
                }
                arrayList.add(this.analyzeSearchWildcardTerm(fieldName, termValues[x]));
                continue;
            }
            if (terms.size() == 0) {
                arrayList.add(new Term(fieldName, STOPWORD_TOKEN));
                continue;
            }
            for (Term t : terms) {
                if (t == null) {
                    arrayList.add(new Term(fieldName, STOPWORD_TOKEN));
                    continue;
                }
                arrayList.add(t);
            }
        }
        this.doStemming = true;
        this.isInWildcardProcessing = false;
        this.isSearch = false;
        return arrayList;
    }

    private Term wildcardTheTerm(Term term, String origValue) {
        StringBuffer stringBuffer = new StringBuffer("");
        String tokenizedWord = term.text();
        String checkValue = null;
        checkValue = !this.isCaseSensitive ? origValue.toLowerCase() : origValue;
        int begin = checkValue.indexOf(tokenizedWord);
        int end = begin + tokenizedWord.length() - 1;
        if (begin > 0 && checkValue.charAt(begin - 1) == '*') {
            stringBuffer.append("*");
        }
        stringBuffer.append(tokenizedWord);
        if (end < checkValue.length() - 1 && checkValue.charAt(end + 1) == '*') {
            stringBuffer.append("*");
        }
        return term.createTerm(stringBuffer.toString());
    }

    private static final class SavedStreams {
        LiteralTokenizer tokenStreamLiteral;
        StandardTokenizer tokenStream;
        private Hashtable<String, TokenStream> filteredTokenStream = new Hashtable();

        private SavedStreams() {
        }

        public TokenStream getFilteredTokenStream(String key) {
            if (this.filteredTokenStream.containsKey(key)) {
                return this.filteredTokenStream.get(key);
            }
            return null;
        }

        public void setFilteredTokenStream(String key, TokenStream tokenStream) {
            this.filteredTokenStream.put(key, tokenStream);
        }
    }
}

